/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.devkit.maven;

import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

/**
 * Clean the build path for a Mule application
 */
@Mojo(name = "clean", requiresDependencyResolution = ResolutionScope.RUNTIME)
@Execute(lifecycle = "mule-package", phase = LifecyclePhase.PACKAGE)
public class CleanMojo extends AbstractMuleMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        File module = new File(this.outputDirectory, this.finalName);
        if (module.exists()) {
            final boolean success = module.delete();
            if (success) {
                getLog().info("Deleted Mule module: " + module);
            } else {
                getLog().info("Failed to delete Mule module: " + module);
            }
        } else {
            getLog().info("Nothing to clean");
        }
    }
}
