/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.devkit.maven;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

import java.io.File;

/**
 * Base Mule Application Mojo
 */
public abstract class AbstractMuleMojo extends AbstractMojo {
    /**
     * Directory containing the generated Mule App.
     */
    @Parameter(required = true, defaultValue = "${project.build.directory}")
    protected File outputDirectory;

    /**
     * Name of the generated Mule App.
     */
    @Parameter(required = true, alias = "appName", defaultValue = "${project.build.finalName}")
    protected String finalName;

    /**
     * Directory containing the app resources.
     */
    @Parameter(required = true, defaultValue = "${basedir}/src/main/app")
    protected File appDirectory;

    /**
     * The Maven project.
     */
    @Parameter(required = true, defaultValue = "${project}", readonly = true)
    public MavenProject project;



    /**
     * Whether to skip the creating of a Mule Studio plugin.
     */
    @Parameter(property = "devkit.studio.package.skip", defaultValue = "true")
    protected boolean skipStudioPluginPackage;

    /**
     * Whether to do a verbose logging or not. Commonly, a DevKit user will never want to see any generation regarding
     * a connector. But if the want to, this property can be set to true and all the logging will be there.
     */
    @Parameter(property = "devkit.verbose.enabled", defaultValue = "false", required = false)
    protected boolean verboseEnabled;

    /**
     * Parameter used to define the timeout of packaging the UpdateSite.zip file
     */
    @Parameter(property = "devkit.studio.package.timeout", defaultValue = "20")
    protected int studioPackageTimeout;

    protected File getMuleZipFile() {
        return new File(this.outputDirectory, this.finalName + ".zip");
    }

    protected File getFilteredAppDirectory() {
        return new File(outputDirectory, "app");
    }
}
