/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.devkit.maven;

import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name = "attach-test-resources")
public class AttachTestResourcesMojo extends AbstractMuleMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        String appFolder = this.appDirectory.getAbsolutePath();

        getLog().info("Attaching test resource " + appFolder);

        Resource appFolderResource = new Resource();
        appFolderResource.setDirectory(appFolder);

        this.project.addTestResource(appFolderResource);
    }
}
