/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven.extension;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ExtensionPomGenerator {
    private static XPath xpath = XPathFactory.newInstance().newXPath();
    private static String VERSION_NODE = "version";
    private static String ARTIFACT_ID_NODE = "artifactId";
    private static String GROUP_ID_NODE = "groupId";
    private static String PACKAGING_ID_NODE = "packaging";
    private static String EXTENSION_PACKAGING = "mule-extension";

    public static void generate(File projectBasedir, File extensionDirectory, String devkitVersion, String muleVersion) throws Exception {
        Document pom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(projectBasedir.getPath().concat("/pom.xml"));
        ExtensionPomGenerator.updateParent(pom, muleVersion);
        ExtensionPomGenerator.updatePackaging(pom);
        ExtensionPomGenerator.clearUnnecessaryElementsFromPom(pom);
        ExtensionPomGenerator.addDevkitSupportShadedDependency(pom, devkitVersion);
        ExtensionPomGenerator.export(extensionDirectory, pom);
    }

    private static void updatePackaging(Document pom) throws XPathExpressionException {
        pom.getDocumentElement().getElementsByTagName(PACKAGING_ID_NODE).item(0).setTextContent(EXTENSION_PACKAGING);
    }

    private static void addDevkitSupportShadedDependency(Document pom, String devkitVersion) throws Exception {
        Document shadingTemplate = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(Thread.currentThread().getContextClassLoader().getResourceAsStream("shaded-devkit-support.xml"));
        ExtensionPomGenerator.addDevkitSupportDependency(pom, shadingTemplate, devkitVersion);
        ExtensionPomGenerator.addShadingForDevkitSupport(pom, shadingTemplate);
    }

    private static void addShadingForDevkitSupport(Document pom, Document shadingTemplate) throws XPathExpressionException {
        if (pom.getDocumentElement().getElementsByTagName("build").getLength() == 0) {
            pom.getDocumentElement().appendChild(pom.createElement("build"));
        }
        if (pom.getDocumentElement().getElementsByTagName("plugins").getLength() == 0) {
            pom.getDocumentElement().getElementsByTagName("build").item(0).appendChild(pom.createElement("plugins"));
        }
        if (pom.getDocumentElement().getElementsByTagName("plugin").getLength() == 0 || xpath.evaluate("//plugins/pelugin/artifactId[text()=\"maven-shade-plugin\"]", pom.getDocumentElement(), XPathConstants.NODE) == null) {
            Node plugins = pom.getDocumentElement().getElementsByTagName("plugins").item(0);
            plugins.appendChild(pom.adoptNode(shadingTemplate.getElementsByTagName("plugin").item(0).cloneNode(true)));
        } else {
            Node oldShadePlugin = ((Node)xpath.evaluate("//plugins/plugin/artifactId[text()=\"maven-shade-plugin\"]", pom.getDocumentElement(), XPathConstants.NODE)).getParentNode();
            Node oldIncludes = (Node)xpath.evaluate("//configuration/artifactSet/includes", oldShadePlugin, XPathConstants.NODE);
            oldIncludes.appendChild(pom.adoptNode(shadingTemplate.getElementsByTagName("include").item(0).cloneNode(true)));
            Node oldRelocations = (Node)xpath.evaluate("//configuration/relocations", oldShadePlugin, XPathConstants.NODE);
            oldRelocations.appendChild(pom.adoptNode(shadingTemplate.getElementsByTagName("relocation").item(0).cloneNode(true)));
        }
    }

    private static void addDevkitSupportDependency(Document pom, Document shadingTemplate, String devkitVersion) throws XPathExpressionException {
        Node dependenciesNode = (Node)xpath.evaluate("//project/dependencies", pom.getDocumentElement(), XPathConstants.NODE);
        if (dependenciesNode == null) {
            dependenciesNode = pom.createElement("dependencies");
            pom.getDocumentElement().appendChild(dependenciesNode);
        }
        NodeList devkitDependencies = shadingTemplate.getElementsByTagName("dependency");
        for (int i = 0; i < devkitDependencies.getLength(); ++i) {
            Node dependency = devkitDependencies.item(i);
            dependenciesNode.appendChild(pom.adoptNode(dependency.cloneNode(true)));
        }
        dependenciesNode.appendChild(ExtensionPomGenerator.devkitShade(pom, devkitVersion));
    }

    private static Node devkitShade(Document pom, String devkitVersion) {
        Element shadeDependency = pom.createElement("dependency");
        Element groupId = pom.createElement(GROUP_ID_NODE);
        groupId.setTextContent("org.mule.tools.devkit");
        shadeDependency.appendChild(groupId);
        Element artifact = pom.createElement(ARTIFACT_ID_NODE);
        artifact.setTextContent("mule-devkit-shade");
        shadeDependency.appendChild(artifact);
        Element version = pom.createElement(VERSION_NODE);
        version.setTextContent(devkitVersion);
        shadeDependency.appendChild(version);
        return shadeDependency;
    }

    private static void clearUnnecessaryElementsFromPom(Document pom) throws XPathExpressionException {
        Node skipNode;
        Node jdkVersion;
        Node devkitMavenPlugin = (Node)xpath.evaluate("//plugins/plugin/artifactId[text()=\"mule-devkit-maven-plugin\"]", pom.getDocumentElement(), XPathConstants.NODE);
        if (devkitMavenPlugin != null) {
            devkitMavenPlugin.getParentNode().getParentNode().removeChild(devkitMavenPlugin.getParentNode());
        }
        if ((jdkVersion = (Node)xpath.evaluate("//properties/jdk.version", pom.getDocumentElement(), XPathConstants.NODE)) != null) {
            Node parentNode = jdkVersion.getParentNode();
            parentNode.removeChild(jdkVersion);
        }
        if ((skipNode = (Node)xpath.evaluate("//properties/devkit.studio.package.skip", pom.getDocumentElement(), XPathConstants.NODE)) != null) {
            skipNode.getParentNode().removeChild(skipNode);
        }
    }

    private static void updateParent(Document pom, String muleVersion) throws XPathExpressionException {
        Node parentNode = pom.getDocumentElement().getElementsByTagName("parent").item(0);
        ((Node)xpath.evaluate("//parent/groupId", parentNode, XPathConstants.NODE)).setTextContent("org.mule.extensions");
        ((Node)xpath.evaluate("//parent/artifactId", parentNode, XPathConstants.NODE)).setTextContent("mule-extensions-parent");
        ((Node)xpath.evaluate("//parent/version", parentNode, XPathConstants.NODE)).setTextContent(muleVersion);
    }

    private static void export(File extensionDirectory, Document pom) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(pom), new StreamResult(new File(extensionDirectory, "pom.xml")));
    }
}

