/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.meta;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.config.i18n.MessageFactory;
import org.mule.config.spring.SpringRegistryLifecycleManager;
import org.mule.lifecycle.RegistryLifecycleManager;
import org.mule.registry.AbstractRegistry;
import org.mule.util.StringUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.support.GenericApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaRegistry
extends AbstractRegistry {
    public static final String REGISTRY_ID = "org.mule.devkit.Registry";
    public static final String SPRING_GENERIC_APPLICATION_CONTEXT = "springGenericApplicationContext";
    private GenericApplicationContext genericApplicationContext = new GenericApplicationContext();

    public MetaRegistry(MuleContext muleContext) {
        super(REGISTRY_ID, muleContext);
    }

    protected void doInitialise() throws InitialisationException {
    }

    public void doDispose() {
        if (this.genericApplicationContext.isActive()) {
            this.genericApplicationContext.close();
        }
        this.genericApplicationContext = null;
    }

    protected RegistryLifecycleManager createLifecycleManager() {
        return new SpringRegistryLifecycleManager(this.getRegistryId(), (Registry)this, this.muleContext);
    }

    public Object lookupObject(String key) {
        if (StringUtils.isBlank((String)key)) {
            this.logger.warn((Object)MessageFactory.createStaticMessage((String)"Detected a lookup attempt with an empty or null key"), new Throwable().fillInStackTrace());
            return null;
        }
        if (key.equals(SPRING_GENERIC_APPLICATION_CONTEXT) && this.genericApplicationContext != null) {
            return this.genericApplicationContext;
        }
        try {
            return this.genericApplicationContext.getBean(key);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.debug((Object)e);
            return null;
        }
    }

    public <T> Collection<T> lookupObjects(Class<T> type) {
        return this.lookupByType(type).values();
    }

    public <T> Collection<T> lookupObjectsForLifecycle(Class<T> type) {
        return this.internalLookupByType(type, false, false).values();
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.internalLookupByType(type, true, true);
    }

    protected <T> Map<String, T> internalLookupByType(Class<T> type, boolean nonSingletons, boolean eagerInit) {
        try {
            return this.genericApplicationContext.getBeansOfType(type, nonSingletons, eagerInit);
        }
        catch (FatalBeanException fbex) {
            String message = String.format("Failed to lookup beans of type %s from the dynamic spring registry", type);
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)message), (Throwable)fbex);
        }
        catch (Exception e) {
            this.logger.debug((Object)e);
            return Collections.emptyMap();
        }
    }

    public void registerObject(String key, Object value) throws RegistrationException {
        if (!(value instanceof BeanDefinition)) {
            throw new UnsupportedOperationException("Only bean definitions can be registered at this registry.");
        }
        this.genericApplicationContext.registerBeanDefinition(key, (BeanDefinition)value);
    }

    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        this.registerObject(key, value);
    }

    public void registerObjects(Map<String, Object> objects) throws RegistrationException {
        for (String key : objects.keySet()) {
            this.registerObject(key, objects.get(key));
        }
    }

    public void unregisterObject(String key) {
        this.genericApplicationContext.removeBeanDefinition(key);
    }

    public void unregisterObject(String key, Object metadata) throws RegistrationException {
        this.genericApplicationContext.removeBeanDefinition(key);
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRemote() {
        return false;
    }
}

