/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.meta;

import java.io.InputStream;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.registry.RegistrationException;
import org.mule.devkit.model.meta.InstantiationException;
import org.mule.devkit.model.meta.MetaModel;
import org.mule.devkit.model.schema.Annotation;
import org.mule.devkit.model.schema.Documentation;
import org.mule.devkit.model.schema.Element;
import org.mule.devkit.model.schema.OpenAttrs;
import org.mule.devkit.model.schema.Schema;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.schema.TopLevelElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaModule {
    private static Logger logger = LoggerFactory.getLogger(MetaModule.class);
    private MetaModel parentModel;
    private String name;
    private String namespace;
    private String description;
    private Class<?> _class;

    public MetaModule(MetaModel parentModel, String name, String namespace, String description, Class<?> _class) {
        this.parentModel = parentModel;
        this.name = name;
        this.namespace = namespace;
        this.description = description;
        this._class = _class;
    }

    private static String parseDescription(Schema schema) {
        for (OpenAttrs openAttr : schema.getSimpleTypeOrComplexTypeOrGroup()) {
            Documentation doc;
            Annotation annotation;
            Element element;
            if (!(openAttr instanceof TopLevelElement) || !(element = (Element)openAttr).getName().equalsIgnoreCase("config") || element.getComplexType() == null || element.getComplexType().getComplexContent() == null || element.getComplexType().getComplexContent().getExtension() == null || element.getComplexType().getComplexContent().getExtension().getAnnotation() == null || (annotation = element.getComplexType().getComplexContent().getExtension().getAnnotation()).getAppinfoOrDocumentation() == null || annotation.getAppinfoOrDocumentation().size() <= 0 || !(annotation.getAppinfoOrDocumentation().get(0) instanceof Documentation) || (doc = (Documentation)annotation.getAppinfoOrDocumentation().get(0)).getContent() == null || doc.getContent().size() <= 0 || !(doc.getContent().get(0) instanceof String)) continue;
            return (String)doc.getContent().get(0);
        }
        return null;
    }

    private static String parseClass(Schema schema) {
        for (OpenAttrs openAttr : schema.getSimpleTypeOrComplexTypeOrGroup()) {
            Element element;
            if (!(openAttr instanceof TopLevelElement) || !(element = (Element)openAttr).getName().equalsIgnoreCase("config")) continue;
            for (QName qName : element.getOtherAttributes().keySet()) {
                if (!qName.equals(SchemaConstants.MULE_DEVKIT_JAVA_CLASS_TYPE)) continue;
                return (String)element.getOtherAttributes().get(qName);
            }
        }
        return null;
    }

    public void newInstance(String name, Map<String, Object> configuration) throws InstantiationException {
        try {
            BeanDefinitionBuilder dynamicModuleBuilder = BeanDefinitionBuilder.rootBeanDefinition(this._class);
            if (Initialisable.class.isAssignableFrom(this._class)) {
                dynamicModuleBuilder.setInitMethodName("initialise");
            }
            if (Disposable.class.isAssignableFrom(this._class)) {
                dynamicModuleBuilder.setDestroyMethodName("dispose");
            }
            for (String attributeName : configuration.keySet()) {
                dynamicModuleBuilder.addPropertyValue(attributeName, configuration.get(attributeName));
            }
            this.parentModel.getMetaRegistry().registerObject(name, (Object)dynamicModuleBuilder.getBeanDefinition());
        }
        catch (RegistrationException e) {
            throw new InstantiationException(this.namespace, "Unable to create module", e);
        }
    }

    public static MetaModule parseSchema(MetaModel model, InputStream stream) {
        MetaModule metaModule = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Schema.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Schema schema = (Schema)unmarshaller.unmarshal(stream);
            String name = schema.getTargetNamespace().substring(schema.getTargetNamespace().lastIndexOf("/") + 1);
            String description = MetaModule.parseDescription(schema);
            String _class = MetaModule.parseClass(schema);
            if (_class == null) {
                return null;
            }
            metaModule = new MetaModule(model, name, schema.getTargetNamespace(), description, Class.forName(_class));
        }
        catch (JAXBException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return metaModule;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Class<?> getModuleClass() {
        return this._class;
    }

    public void getModuleClass(Class<?> _class) {
        this._class = _class;
    }
}

