/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.nexus;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.lucene.search.Query;
import org.apache.maven.index.AndMultiArtifactInfoFilter;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.SearchType;
import org.apache.maven.index.context.IndexingContext;
import org.codehaus.plexus.util.StringUtils;
import org.mule.devkit.nexus.Module;
import org.mule.devkit.nexus.ModuleCatalog;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.StringContentLocator;

public class ModuleContentLocator
implements ContentLocator {
    private final String repositoryId;
    private final IndexingContext indexingContext;
    private final ArtifactInfoFilter artifactInfoFilter;
    private final NexusIndexer nexusIndexer;

    public ModuleContentLocator(String repositoryId, IndexingContext indexingContext, NexusIndexer nexusIndexer, ArtifactInfoFilter artifactInfoFilter) {
        this.repositoryId = repositoryId;
        this.indexingContext = indexingContext;
        this.nexusIndexer = nexusIndexer;
        this.artifactInfoFilter = artifactInfoFilter;
    }

    public InputStream getContent() throws IOException {
        Query pq = this.nexusIndexer.constructQuery(MAVEN.PACKAGING, "mule-module", SearchType.EXACT);
        IteratorSearchRequest sreq = new IteratorSearchRequest(pq, this.indexingContext);
        ClassifierArtifactInfoFilter classifierFilter = new ClassifierArtifactInfoFilter();
        if (this.artifactInfoFilter != null) {
            AndMultiArtifactInfoFilter andArtifactFilter = new AndMultiArtifactInfoFilter(Arrays.asList(classifierFilter, this.artifactInfoFilter));
            sreq.setArtifactInfoFilter((ArtifactInfoFilter)andArtifactFilter);
        } else {
            sreq.setArtifactInfoFilter((ArtifactInfoFilter)classifierFilter);
        }
        IteratorSearchResponse hits = this.nexusIndexer.searchIterator(sreq);
        ModuleCatalog catalog = new ModuleCatalog();
        Module module = null;
        for (ArtifactInfo info : hits) {
            module = new Module();
            module.setGroupId(info.groupId);
            module.setArtifactId(info.artifactId);
            module.setVersion(info.version);
            module.setDescription(info.description);
            if (StringUtils.isNotEmpty((String)this.indexingContext.getRepositoryUrl())) {
                module.setRepository(this.indexingContext.getRepositoryUrl());
            }
            catalog.addModule(module);
        }
        StringWriter sw = new StringWriter();
        return new StringContentLocator(sw.toString()).getContent();
    }

    public String getMimeType() {
        return "text/xml";
    }

    public boolean isReusable() {
        return true;
    }

    public static class ClassifierArtifactInfoFilter
    implements ArtifactInfoFilter {
        public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
            return StringUtils.isBlank((String)ai.classifier);
        }
    }
}

