/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.nexus;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexingContext;
import org.mule.devkit.nexus.ModuleContentLocator;
import org.sonatype.nexus.index.DefaultIndexerManager;
import org.sonatype.nexus.index.IndexArtifactFilter;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.item.ContentGenerator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.repository.Repository;

@Named(value="ModuleContentGenerator")
public class ModuleContentGenerator
implements ContentGenerator {
    public static final String ID = "ModuleContentGenerator";
    @Inject
    private IndexerManager indexerManager;
    @Inject
    private IndexArtifactFilter indexArtifactFilter;
    @Inject
    private NexusIndexer nexusIndexer;

    public String getGeneratorId() {
        return ID;
    }

    public ContentLocator generateContent(Repository repository, String path, StorageFileItem item) throws IllegalOperationException, ItemNotFoundException, LocalStorageException {
        item.setLength(-1L);
        return new ModuleContentLocator(repository.getId(), ((DefaultIndexerManager)this.indexerManager).getRepositoryIndexContext(repository), this.nexusIndexer, new ArtifactInfoFilter(){

            public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
                return ModuleContentGenerator.this.indexArtifactFilter.filterArtifactInfo(ai);
            }
        });
    }
}

