package org.mule.devkit.nexus.capabilities;

import static org.sonatype.nexus.plugins.capabilities.CapabilityType.capabilityType;

import javax.inject.Named;
import javax.inject.Singleton;

import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptor;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.support.CapabilityDescriptorSupport;

/**
 * 
 * @author mariano.gonzalez@mulesoft.com
 *
 */
@Singleton
@Named(DevkitNexusCapabilityDescriptor.TYPE_ID)
public class DevkitNexusCapabilityDescriptor extends CapabilityDescriptorSupport implements CapabilityDescriptor{
	
	public static final String TYPE_ID = "devkit.nexus.capability";

    private static final CapabilityType TYPE = capabilityType( TYPE_ID );

    public DevkitNexusCapabilityDescriptor()
    {
        super(
            TYPE,
            "Mule DevKit Nexus Capability",
            "The DevKit Nexus Plugin augments Nexus indexing capabilities with extra information directly "
            + "related to Mule modules, adding schema information, as well as cataloging them along with DevKit plugins into "
            + "special catalog files."
        );
    }


}
