/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedSwitchCase;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneratedSwitch
implements Statement {
    private GeneratedExpression test;
    private List<GeneratedSwitchCase> cases = new ArrayList<GeneratedSwitchCase>();
    private GeneratedSwitchCase defaultCase = null;

    GeneratedSwitch(GeneratedExpression test) {
        this.test = test;
    }

    public GeneratedExpression test() {
        return this.test;
    }

    public Iterator<GeneratedSwitchCase> cases() {
        return this.cases.iterator();
    }

    public GeneratedSwitchCase _case(GeneratedExpression label) {
        GeneratedSwitchCase c = new GeneratedSwitchCase(label);
        this.cases.add(c);
        return c;
    }

    public GeneratedSwitchCase _default() {
        this.defaultCase = new GeneratedSwitchCase(null, true);
        return this.defaultCase;
    }

    @Override
    public void state(Formatter f) {
        if (Op.hasTopOp(this.test)) {
            f.p("switch ").g(this.test).p(" {").nl();
        } else {
            f.p("switch (").g(this.test).p(')').p(" {").nl();
        }
        for (GeneratedSwitchCase c : this.cases) {
            f.s(c);
        }
        if (this.defaultCase != null) {
            f.s(this.defaultCase);
        }
        f.p('}').nl();
    }
}

