/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.Statement;

public final class GeneratedSwitchCase
implements Statement {
    private GeneratedExpression label;
    private GeneratedBlock body = null;
    private boolean isDefaultCase = false;

    GeneratedSwitchCase(GeneratedExpression label) {
        this(label, false);
    }

    GeneratedSwitchCase(GeneratedExpression label, boolean isDefaultCase) {
        this.label = label;
        this.isDefaultCase = isDefaultCase;
    }

    public GeneratedExpression label() {
        return this.label;
    }

    public GeneratedBlock body() {
        if (this.body == null) {
            this.body = new GeneratedBlock(false, true);
        }
        return this.body;
    }

    public void state(Formatter f) {
        f.i();
        if (!this.isDefaultCase) {
            f.p("case ").g(this.label).p(':').nl();
        } else {
            f.p("default:").nl();
        }
        if (this.body != null) {
            f.s(this.body);
        }
        f.o();
    }
}

