package org.mule.devkit.nexus.capabilities;

import javax.inject.Named;

import org.apache.maven.index.Field;
import org.sonatype.nexus.plugins.capabilities.support.CapabilitySupport;

/**
 * 
 * @author mariano.gonzalez@mulesoft.com
 *
 */
@Named(DevkitNexusCapabilityDescriptor.TYPE_ID)
public class DevkitNexusCapability extends CapabilitySupport {
	
	public static final String NAMESPACE = "urn:devkit#";
    public static final Field IS_PLUGIN = new Field(null, NAMESPACE, "isDevKitPlugin", "Is DevKit Plugin");

    private static boolean active = false;
    
    public static boolean isActive() {
    	return active;
    }
    
    @Override
    public void onActivate() throws Exception {
    	active = true;
    }
    
    @Override
    public void onPassivate() throws Exception {
    	active = false;
    }
    
}
