
package org.mule.devkit.nexus;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Arrays;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.lucene.search.Query;
import org.apache.maven.index.AndMultiArtifactInfoFilter;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.SearchType;
import org.apache.maven.index.context.IndexingContext;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.StringContentLocator;

public class ModuleCatalogContentLocator implements ContentLocator {

    private final IndexingContext indexingContext;

    private final ArtifactInfoFilter artifactInfoFilter;

    private final NexusIndexer nexusIndexer;

    public ModuleCatalogContentLocator(
                                       IndexingContext indexingContext,
                                       NexusIndexer nexusIndexer,
                                       ArtifactInfoFilter artifactInfoFilter) {

    	this.indexingContext = indexingContext;
        this.nexusIndexer = nexusIndexer;
        this.artifactInfoFilter = artifactInfoFilter;
    }

    @Override
    public InputStream getContent()
            throws IOException {
        Query pq = nexusIndexer.constructQuery(MAVEN.PACKAGING, "mule-module", SearchType.EXACT);

        // to have sorted results by version in descending order
        IteratorSearchRequest sreq = new IteratorSearchRequest(pq, indexingContext);

        // filter that filters out classified artifacts
        ClassifierArtifactInfoFilter classifierFilter = new ClassifierArtifactInfoFilter();

        // combine it with others if needed (unused in cli, but perm filtering in server!)
        if (artifactInfoFilter != null) {
            AndMultiArtifactInfoFilter andArtifactFilter =
                    new AndMultiArtifactInfoFilter(Arrays.asList(new ArtifactInfoFilter[]{classifierFilter,
                            artifactInfoFilter}));

            sreq.setArtifactInfoFilter(andArtifactFilter);
        } else {
            sreq.setArtifactInfoFilter(classifierFilter);
        }

        IteratorSearchResponse hits = null;

        try
        {
            hits = nexusIndexer.searchIterator(sreq);

            // serialize it to XML
            StringWriter sw = new StringWriter();
            sw.append("<module-catalog>");
            sw.append("<modules>");

            for (ArtifactInfo info : hits) {
                sw.append("<module>");
                sw.append("<groupId>" + info.groupId + "</groupId>");
                sw.append("<artifactId>" + info.artifactId + "</artifactId>");
                sw.append("<version>" + info.version + "</version>");
                if (info.description != null) {
                    sw.append("<description>" + StringEscapeUtils.escapeHtml(info.description) + "</description>");
                }
                if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_0.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_1.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_2.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_3.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_4.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_5.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_6.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_7.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_8.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_9.getKey())) {
                    sw.append("<namespaces>");
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_0.getKey())) {
                        sw.append("<namespace>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_0.getKey()));
                        sw.append("</namespace>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_1.getKey())) {
                        sw.append("<namespace>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_1.getKey()));
                        sw.append("</namespace>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_2.getKey())) {
                        sw.append("<namespace>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_2.getKey()));
                        sw.append("</namespace>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_3.getKey())) {
                        sw.append("<namespace>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_3.getKey()));
                        sw.append("</namespace>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_4.getKey())) {
                        sw.append("<namespace>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_4.getKey()));
                        sw.append("</namespace>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_5.getKey())) {
                        sw.append("<namespace>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_5.getKey()));
                        sw.append("</namespace>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_6.getKey())) {
                        sw.append("<namespace>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_6.getKey()));
                        sw.append("</namespace>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_7.getKey())) {
                        sw.append("<namespace>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_7.getKey()));
                        sw.append("</namespace>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_8.getKey())) {
                        sw.append("<namespace>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_8.getKey()));
                        sw.append("</namespace>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_9.getKey())) {
                        sw.append("<namespace>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_NAMESPACE_9.getKey()));
                        sw.append("</namespace>");
                    }
                    sw.append("</namespaces>");
                }
                if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_0.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_1.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_2.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_3.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_4.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_5.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_6.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_7.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_8.getKey()) ||
                        info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_9.getKey())) {
                    sw.append("<schema-locations>");
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_0.getKey())) {
                        sw.append("<schema-location>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_LOCATION_0.getKey()));
                        sw.append("</schema-location>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_1.getKey())) {
                        sw.append("<schema-location>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_LOCATION_1.getKey()));
                        sw.append("</schema-location>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_2.getKey())) {
                        sw.append("<schema-location>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_LOCATION_2.getKey()));
                        sw.append("</schema-location>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_3.getKey())) {
                        sw.append("<schema-location>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_LOCATION_3.getKey()));
                        sw.append("</schema-location>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_4.getKey())) {
                        sw.append("<schema-location>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_LOCATION_4.getKey()));
                        sw.append("</schema-location>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_5.getKey())) {
                        sw.append("<schema-location>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_LOCATION_5.getKey()));
                        sw.append("</schema-location>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_6.getKey())) {
                        sw.append("<schema-location>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_LOCATION_6.getKey()));
                        sw.append("</schema-location>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_7.getKey())) {
                        sw.append("<schema-location>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_LOCATION_7.getKey()));
                        sw.append("</schema-location>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_8.getKey())) {
                        sw.append("<schema-location>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_LOCATION_8.getKey()));
                        sw.append("</schema-location>");
                    }
                    if (info.getAttributes().containsKey(ModuleIndexCreator.FLD_SCHEMA_LOCATION_9.getKey())) {
                        sw.append("<schema-location>");
                        sw.append(info.getAttributes().get(ModuleIndexCreator.FLD_SCHEMA_LOCATION_9.getKey()));
                        sw.append("</schema-location>");
                    }
                    sw.append("</schema-locations>");
                }
                sw.append("</module>");
            }


            sw.append("</modules>");
            sw.append("</module-catalog>");

            return new StringContentLocator(sw.toString()).getContent();

        } finally {
            if(hits != null) {
                hits.close();
            }
        }
    }

    @Override
    public String getMimeType() {
        return "text/xml";
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    public static class ClassifierArtifactInfoFilter
            implements ArtifactInfoFilter {
        public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
            return StringUtils.isBlank(ai.classifier);
        }
    }
}
