/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.atgenerated;

import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.code.GeneratedAnnotationUse;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Generated;

public class ClassAnnotationGenerator extends AbstractAtGeneratedGenerator {
    private final static List<Product> CONSUMES = Arrays.asList(new Product[]{Product.SCHEMA});
    private final static List<Product> PRODUCES = Arrays.asList(new Product[]{});

    /**
     * Cache the timestamp so that all the @Generated annotations match
     */
    private String date = null;

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public boolean shouldGenerate(Module module) {
        return true;
    }

    @Override
    public void generate(Module module) throws GenerationException {

        Iterator<GeneratedPackage> packageIterator = ctx().getCodeModel().packages();

        while (packageIterator.hasNext()) {
            GeneratedPackage pkg = packageIterator.next();
            Iterator<GeneratedClass> classesIterator = pkg.classes();

            while (classesIterator.hasNext()) {
                GeneratedClass clazz = classesIterator.next();

                annotateWithAtSuppressWarnings(clazz);
                annotateWithAtGenerated(clazz);
            }
        }
    }


    /**
     * Annotate a generated class with the @SuppressWarnings annotation in order to avoid the warning messages of the generated code.
     *
     * @param clazz the class that must be annotated
     */
    private void annotateWithAtSuppressWarnings(GeneratedClass clazz) {

        TypeReference atSuppressWarnings = ref(SuppressWarnings.class);

        for (GeneratedAnnotationUse use : clazz.annotations()) {
            if (use.getAnnotationClass().name().equals(atSuppressWarnings.name())) {
                return;
            }
        }

        clazz.annotate(atSuppressWarnings).param("value","all");
    }


    /**
     * Annotate a generated class with the @Generated annotation
     *
     * @param clazz the class that must be annotated
     */
    private void annotateWithAtGenerated(GeneratedClass clazz){
        TypeReference atGeneratedAnnotation = ref(Generated.class);

        for (GeneratedAnnotationUse use : clazz.annotations()) {
            if (use.getAnnotationClass().name().equals(atGeneratedAnnotation.name())) {
                return;
            }
        }

        clazz.annotate(atGeneratedAnnotation)
                .param("value", "Mule DevKit Version " + ctx().getManifest().getProductVersion())
                .param("date", getISO8601Date())
                .param("comments", "Build " + ctx().getManifest().getBuildNumber());
    }

    /**
     * Calculate the date value in ISO8601 format for the @Generated annotation
     *
     * @return the date value
     */
    private String getISO8601Date() {
        if (date == null) {
            StringBuffer tstamp = new StringBuffer();
            tstamp.append((new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssZ")).format(new Date()));
            // hack to get ISO 8601 style timezone - is there a better way that doesn't require
            // a bunch of timezone offset calculations?
            tstamp.insert(tstamp.length() - 2, ':');
            date = tstamp.toString();
        }
        return date;
    }

}
