/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.expressionlanguage;

import org.mule.api.annotations.ExpressionEnricher;
import org.mule.api.annotations.ExpressionEvaluator;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

public class ExpressionLanguageAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.EXPRESSION_LANGUAGE;
    }

    public void verify(Module module) throws AnnotationVerificationException {
        boolean expressionStringFound;
        if (module.getMethodsAnnotatedWith(ExpressionEvaluator.class).size() > 1) {
            throw new AnnotationVerificationException((Identifiable)module, "An @ExpressionLanguage can only contain one @ExpressionEvaluator.");
        }
        if (module.getMethodsAnnotatedWith(ExpressionEnricher.class).size() > 1) {
            throw new AnnotationVerificationException((Identifiable)module, "An @ExpressionLanguage can only contain one @ExpressionEnricher.");
        }
        if (module.getMethodsAnnotatedWith(ExpressionEvaluator.class).size() == 0 && module.getMethodsAnnotatedWith(ExpressionEnricher.class).size() == 0) {
            throw new AnnotationVerificationException((Identifiable)module, "An @ExpressionLanguage must contain one @ExpressionEnricher or one @ExpressionEvaluator or both.");
        }
        for (Method executableElement : module.getMethodsAnnotatedWith(ExpressionEvaluator.class)) {
            if (executableElement.getParameters().size() == 0) {
                throw new AnnotationVerificationException((Identifiable)executableElement, "An @ExpressionEvaluator must receive at least a String that represents the expression to evaluate.");
            }
            if (executableElement.getReturnType().toString().equals("void")) {
                throw new AnnotationVerificationException((Identifiable)executableElement, "@ExpressionEvaluator cannot be void");
            }
            expressionStringFound = false;
            for (Parameter parameter : executableElement.getParameters()) {
                if (parameter.getAnnotation(Payload.class) != null || parameter.getAnnotation(OutboundHeaders.class) != null || parameter.getAnnotation(InboundHeaders.class) != null || parameter.getAnnotation(SessionHeaders.class) != null || parameter.getAnnotation(InvocationHeaders.class) != null || parameter.getAnnotation(ExceptionPayload.class) != null || parameter.getAnnotation(CorrelationId.class) != null || parameter.getAnnotation(CorrelationSequence.class) != null) continue;
                if (parameter.asTypeMirror().toString().contains("String")) {
                    if (expressionStringFound) {
                        throw new AnnotationVerificationException((Identifiable)executableElement, "An @ExpressionEvaluator can receive only one String and the rest of the arguments must be annotated with either @Payload, @InboundHeaders, @OutboundHeaders, @SessionHeader or @InvocationHeaders.");
                    }
                    expressionStringFound = true;
                    continue;
                }
                throw new AnnotationVerificationException((Identifiable)executableElement, "An @ExpressionEvaluator can receive only one String and the rest of the arguments must be annotated with either @Payload, @InboundHeaders, @OutboundHeaders, @SessionHeader or @InvocationHeaders.");
            }
        }
        for (Method executableElement : module.getMethodsAnnotatedWith(ExpressionEnricher.class)) {
            if (executableElement.getParameters().size() == 0) {
                throw new AnnotationVerificationException((Identifiable)executableElement, "An @ExpressionEnricher must receive at least a String that represents the expression and Object that represents the object to be used for enrichment.");
            }
            if (!executableElement.getReturnType().toString().equals("void")) {
                throw new AnnotationVerificationException((Identifiable)executableElement, "@ExpressionEnricher must be void");
            }
            expressionStringFound = false;
            boolean enrichObjectFound = false;
            for (Parameter parameter : executableElement.getParameters()) {
                if (parameter.getAnnotation(Payload.class) != null || parameter.getAnnotation(OutboundHeaders.class) != null || parameter.getAnnotation(InboundHeaders.class) != null || parameter.getAnnotation(SessionHeaders.class) != null || parameter.getAnnotation(InvocationHeaders.class) != null || parameter.getAnnotation(ExceptionPayload.class) != null || parameter.getAnnotation(CorrelationId.class) != null || parameter.getAnnotation(CorrelationSequence.class) != null) continue;
                if (parameter.asTypeMirror().toString().contains("String")) {
                    if (expressionStringFound) {
                        throw new AnnotationVerificationException((Identifiable)executableElement, "An @ExpressionEnricher can receive only one Object and one String and the rest of the arguments must be annotated with either @Payload, @InboundHeaders, @OutboundHeaders, @SessionHeader or @InvocationHeaders.");
                    }
                    expressionStringFound = true;
                    continue;
                }
                if (parameter.asTypeMirror().toString().contains("Object")) {
                    if (enrichObjectFound) {
                        throw new AnnotationVerificationException((Identifiable)executableElement, "An @ExpressionEnricher can receive only one Object and one String and the rest of the arguments must be annotated with either @Payload, @InboundHeaders, @OutboundHeaders, @SessionHeader or @InvocationHeaders.");
                    }
                    enrichObjectFound = true;
                    continue;
                }
                throw new AnnotationVerificationException((Identifiable)executableElement, "An @ExpressionEnricher can receive only one Object and one String and the rest of the arguments must be annotated with either @Payload, @InboundHeaders, @OutboundHeaders, @SessionHeader or @InvocationHeaders.");
            }
        }
    }
}

