/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.expressionlanguage;

import org.mule.api.annotations.ExpressionEnricher;
import org.mule.api.annotations.ExpressionEvaluator;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

public class ExpressionLanguageAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.EXPRESSION_LANGUAGE;
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        boolean expressionStringFound;
        if (module.getMethodsAnnotatedWith(ExpressionEvaluator.class).size() > 1) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_134, new Object[0]);
        }
        if (module.getMethodsAnnotatedWith(ExpressionEnricher.class).size() > 1) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_135, new Object[0]);
        }
        if (module.getMethodsAnnotatedWith(ExpressionEvaluator.class).size() == 0 && module.getMethodsAnnotatedWith(ExpressionEnricher.class).size() == 0) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_136, new Object[0]);
        }
        for (Method executableElement : module.getMethodsAnnotatedWith(ExpressionEvaluator.class)) {
            if (executableElement.getParameters().size() == 0) {
                gatherer.error((Identifiable)executableElement, (DevkitNotification)Message.DEVKIT_137, new Object[0]);
            }
            if (((Object)executableElement.getReturnType()).toString().equals("void")) {
                gatherer.error((Identifiable)executableElement, (DevkitNotification)Message.DEVKIT_138, new Object[0]);
            }
            expressionStringFound = false;
            for (Parameter parameter : executableElement.getParameters()) {
                if (parameter.hasAnnotation(Payload.class) || parameter.hasAnnotation(OutboundHeaders.class) || parameter.hasAnnotation(InboundHeaders.class) || parameter.hasAnnotation(SessionHeaders.class) || parameter.hasAnnotation(InvocationHeaders.class) || parameter.hasAnnotation(ExceptionPayload.class) || parameter.hasAnnotation(CorrelationId.class) || parameter.hasAnnotation(CorrelationSequence.class)) continue;
                if (((Object)parameter.asTypeMirror()).toString().contains("String")) {
                    if (expressionStringFound) {
                        gatherer.error((Identifiable)executableElement, (DevkitNotification)Message.DEVKIT_139, new Object[0]);
                        continue;
                    }
                    expressionStringFound = true;
                    continue;
                }
                gatherer.error((Identifiable)executableElement, (DevkitNotification)Message.DEVKIT_140, new Object[0]);
            }
        }
        for (Method executableElement : module.getMethodsAnnotatedWith(ExpressionEnricher.class)) {
            if (executableElement.getParameters().size() == 0) {
                gatherer.error((Identifiable)executableElement, (DevkitNotification)Message.DEVKIT_141, new Object[0]);
            }
            if (!((Object)executableElement.getReturnType()).toString().equals("void")) {
                gatherer.error((Identifiable)executableElement, (DevkitNotification)Message.DEVKIT_142, new Object[0]);
            }
            expressionStringFound = false;
            boolean enrichObjectFound = false;
            for (Parameter parameter : executableElement.getParameters()) {
                if (parameter.hasAnnotation(Payload.class) || parameter.hasAnnotation(OutboundHeaders.class) || parameter.hasAnnotation(InboundHeaders.class) || parameter.hasAnnotation(SessionHeaders.class) || parameter.hasAnnotation(InvocationHeaders.class) || parameter.hasAnnotation(ExceptionPayload.class) || parameter.hasAnnotation(CorrelationId.class) || parameter.hasAnnotation(CorrelationSequence.class)) continue;
                if (((Object)parameter.asTypeMirror()).toString().contains("String")) {
                    if (expressionStringFound) {
                        gatherer.error((Identifiable)executableElement, (DevkitNotification)Message.DEVKIT_143, new Object[0]);
                        continue;
                    }
                    expressionStringFound = true;
                    continue;
                }
                if (((Object)parameter.asTypeMirror()).toString().contains("Object")) {
                    if (enrichObjectFound) {
                        gatherer.error((Identifiable)executableElement, (DevkitNotification)Message.DEVKIT_144, new Object[0]);
                        continue;
                    }
                    enrichObjectFound = true;
                    continue;
                }
                gatherer.error((Identifiable)executableElement, (DevkitNotification)Message.DEVKIT_145, new Object[0]);
            }
        }
    }
}

