/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.expressionlanguage;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.TypeKind;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.ExpressionEvaluator;
import org.mule.api.annotations.ExpressionLanguage;
import org.mule.api.annotations.param.CorrelationGroupSize;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.MessageRootId;
import org.mule.api.annotations.param.MessageUniqueId;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.transformer.TransformerException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.expressionlanguage.AbstractExpressionLanguageGenerator;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.expression.ExpressionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEvaluatorGenerator
extends AbstractExpressionLanguageGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.INJECTION_ADAPTER, Product.CONNECTION_IDENTIFIER_ADAPTER, Product.OAUTH_ADAPTER, Product.ABSTRACT_EXPRESSION_EVALUATOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.REGISTRY_BOOTSTRAP_ENTRY);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.EXPRESSION_LANGUAGE && module.getMethodsAnnotatedWith(ExpressionEvaluator.class).size() > 0;
    }

    public void generate(Module module) {
        String name = ((ExpressionLanguage)module.getAnnotation(ExpressionLanguage.class)).name();
        org.mule.devkit.model.Method executableElement = (org.mule.devkit.model.Method)module.getMethodsAnnotatedWith(ExpressionEvaluator.class).get(0);
        TypeReference moduleObject = (TypeReference)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module);
        GeneratedClass evaluatorClass = this.getEvaluatorClass(name, module);
        this.ctx().note("Generating expression evaluator " + evaluatorClass.fullName() + " for language at class " + module.getName());
        GeneratedField moduleField = this.generateModuleField(moduleObject, evaluatorClass);
        GeneratedMethod setMuleContext = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, "setMuleContext");
        GeneratedVariable muleContext = setMuleContext.param((org.mule.devkit.model.code.Type)this.ref(MuleContext.class), "muleContext");
        GeneratedConditional ifModuleIsContextAware = setMuleContext.body()._if(Op._instanceof((GeneratedExpression)moduleField, (org.mule.devkit.model.code.Type)this.ref(MuleContextAware.class)));
        ifModuleIsContextAware._then().add((Statement)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(MuleContextAware.class), (GeneratedExpression)moduleField).invoke("setMuleContext").arg((GeneratedExpression)muleContext));
        GeneratedMethod start = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, "start");
        start._throws(this.ref(MuleException.class));
        GeneratedConditional ifModuleIsStartable = start.body()._if(Op._instanceof((GeneratedExpression)moduleField, (org.mule.devkit.model.code.Type)this.ref(Startable.class)));
        ifModuleIsStartable._then().add((Statement)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Startable.class), (GeneratedExpression)moduleField).invoke("start"));
        GeneratedMethod stop = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, "stop");
        stop._throws(this.ref(MuleException.class));
        GeneratedConditional ifModuleIsStoppable = stop.body()._if(Op._instanceof((GeneratedExpression)moduleField, (org.mule.devkit.model.code.Type)this.ref(Stoppable.class)));
        ifModuleIsStoppable._then().add((Statement)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Stoppable.class), (GeneratedExpression)moduleField).invoke("stop"));
        GeneratedMethod init = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, "initialise");
        init._throws(this.ref(InitialisationException.class));
        GeneratedConditional ifModuleIsInitialisable = init.body()._if(Op._instanceof((GeneratedExpression)moduleField, (org.mule.devkit.model.code.Type)this.ref(Initialisable.class)));
        ifModuleIsInitialisable._then().add((Statement)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Initialisable.class), (GeneratedExpression)moduleField).invoke("initialise"));
        GeneratedMethod dispose = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, "dispose");
        GeneratedConditional ifModuleIsDisposable = dispose.body()._if(Op._instanceof((GeneratedExpression)moduleField, (org.mule.devkit.model.code.Type)this.ref(Disposable.class)));
        ifModuleIsDisposable._then().add((Statement)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Disposable.class), (GeneratedExpression)moduleField).invoke("dispose"));
        this.generateConstructor(moduleObject, evaluatorClass, moduleField);
        this.generateGetName(name, evaluatorClass);
        this.generateSetName(evaluatorClass);
        GeneratedMethod evaluate = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.ref(Object.class), "evaluate");
        GeneratedVariable expression = evaluate.param((org.mule.devkit.model.code.Type)this.ref(String.class), "expression");
        GeneratedVariable message = evaluate.param((org.mule.devkit.model.code.Type)this.ref(MuleMessage.class), "message");
        GeneratedTry tryStatement = evaluate.body()._try();
        GeneratedInvocation newArray = ExpressionFactory._new((TypeReference)this.ref(Class.class).array());
        for (Parameter parameter : executableElement.getParameters()) {
            if (parameter.asTypeMirror().getKind() == TypeKind.BOOLEAN || parameter.asTypeMirror().getKind() == TypeKind.BYTE || parameter.asTypeMirror().getKind() == TypeKind.SHORT || parameter.asTypeMirror().getKind() == TypeKind.CHAR || parameter.asTypeMirror().getKind() == TypeKind.INT || parameter.asTypeMirror().getKind() == TypeKind.FLOAT || parameter.asTypeMirror().getKind() == TypeKind.LONG || parameter.asTypeMirror().getKind() == TypeKind.DOUBLE) {
                newArray.arg((GeneratedExpression)this.ref(parameter.asTypeMirror()).boxify().staticRef("TYPE"));
                continue;
            }
            newArray.arg(this.ref(parameter.asTypeMirror()).boxify().dotclass());
        }
        GeneratedVariable parameterClasses = tryStatement.body().decl((org.mule.devkit.model.code.Type)this.ref(Class.class).array(), "parameterClasses", (GeneratedExpression)newArray);
        GeneratedInvocation getMethod = moduleField.invoke("getClass").invoke("getMethod").arg(executableElement.getName()).arg((GeneratedExpression)parameterClasses);
        GeneratedVariable moduleEvaluate = tryStatement.body().decl((org.mule.devkit.model.code.Type)this.ref(Method.class), "evaluateMethod", (GeneratedExpression)getMethod);
        ArrayList<GeneratedVariable> types = new ArrayList<GeneratedVariable>();
        for (Parameter parameter : executableElement.getParameters()) {
            GeneratedVariable var = tryStatement.body().decl((org.mule.devkit.model.code.Type)this.ref(Type.class), parameter.getName() + "Type", (GeneratedExpression)moduleEvaluate.invoke("getGenericParameterTypes").component(ExpressionFactory.lit((int)types.size())));
            types.add(var);
        }
        int argCount = 0;
        GeneratedInvocation evaluateInvoke = moduleField.invoke(executableElement.getName());
        for (Parameter parameter : executableElement.getParameters()) {
            if (parameter.getAnnotation(Payload.class) != null) {
                evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)message.invoke("getPayload"))));
            } else if (parameter.getAnnotation(ExceptionPayload.class) != null) {
                evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)message.invoke("getExceptionPayload"))));
            } else if (parameter.getAnnotation(CorrelationId.class) != null) {
                evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)message.invoke("getCorrelationId"))));
            } else if (parameter.getAnnotation(CorrelationSequence.class) != null) {
                evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)message.invoke("getCorrelationSequence"))));
            } else if (parameter.getAnnotation(CorrelationGroupSize.class) != null) {
                evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)message.invoke("getCorrelationGroupSize"))));
            } else if (parameter.getAnnotation(MessageUniqueId.class) != null) {
                evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)message.invoke("getUniqueId"))));
            } else if (parameter.getAnnotation(MessageRootId.class) != null) {
                evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)message.invoke("getMessageRootId"))));
            } else if (((Object)parameter.asTypeMirror()).toString().startsWith(MuleMessage.class.getName())) {
                evaluateInvoke.arg((GeneratedExpression)message);
            } else if (parameter.getAnnotation(InboundHeaders.class) != null) {
                InboundHeaders inboundHeaders = (InboundHeaders)parameter.getAnnotation(InboundHeaders.class);
                if (parameter.asType().isArrayOrList()) {
                    evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("INBOUND:" + inboundHeaders.value()).arg((GeneratedExpression)message).arg(this.ref(List.class).dotclass()))));
                } else if (parameter.asType().isMap()) {
                    evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("INBOUND:" + inboundHeaders.value()).arg((GeneratedExpression)message).arg(this.ref(Map.class).dotclass()))));
                } else {
                    evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("INBOUND:" + inboundHeaders.value()).arg((GeneratedExpression)message))));
                }
            } else if (parameter.getAnnotation(SessionHeaders.class) != null) {
                SessionHeaders sessionHeaders = (SessionHeaders)parameter.getAnnotation(SessionHeaders.class);
                if (parameter.asType().isArrayOrList()) {
                    evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("SESSION:" + sessionHeaders.value()).arg((GeneratedExpression)message).arg(this.ref(List.class).dotclass()))));
                } else if (parameter.asType().isMap()) {
                    evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("SESSION:" + sessionHeaders.value()).arg((GeneratedExpression)message).arg(this.ref(Map.class).dotclass()))));
                } else {
                    evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("SESSION:" + sessionHeaders.value()).arg((GeneratedExpression)message))));
                }
            } else if (parameter.getAnnotation(OutboundHeaders.class) != null) {
                evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("OUTBOUND:*").arg((GeneratedExpression)message).arg(this.ref(Map.class).dotclass()))));
            } else if (parameter.getAnnotation(InvocationHeaders.class) != null) {
                InvocationHeaders invocationHeaders = (InvocationHeaders)parameter.getAnnotation(InvocationHeaders.class);
                if (parameter.asType().isArrayOrList()) {
                    evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("INVOCATION:" + invocationHeaders.value()).arg((GeneratedExpression)message).arg(this.ref(List.class).dotclass()))));
                } else if (parameter.asType().isMap()) {
                    evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("INVOCATION:" + invocationHeaders.value()).arg((GeneratedExpression)message).arg(this.ref(Map.class).dotclass()))));
                } else {
                    evaluateInvoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(parameter.asTypeMirror()).boxify(), (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)message).arg((GeneratedExpression)types.get(argCount)).arg((GeneratedExpression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("INVOCATION:" + invocationHeaders.value()).arg((GeneratedExpression)message))));
                }
            } else if (((Object)parameter.asTypeMirror()).toString().contains("String")) {
                evaluateInvoke.arg((GeneratedExpression)expression);
            }
            ++argCount;
        }
        tryStatement.body()._return((GeneratedExpression)evaluateInvoke);
        this.catchAndRethrowAsRuntimeException(tryStatement, NoSuchMethodException.class);
        this.catchAndRethrowAsRuntimeException(tryStatement, TransformerException.class);
    }

    private void catchAndRethrowAsRuntimeException(GeneratedTry tryStatement, Class clazz) {
        GeneratedCatchBlock catchBlock = tryStatement._catch(this.ref(clazz));
        GeneratedVariable e = catchBlock.param("e");
        catchBlock.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)e));
    }

    private GeneratedField generateModuleField(TypeReference typeElement, GeneratedClass evaluatorClass) {
        return evaluatorClass.field(4, (org.mule.devkit.model.code.Type)typeElement, "module", ExpressionFactory._null());
    }

    private void generateConstructor(TypeReference typeElement, GeneratedClass evaluatorClass, GeneratedField module) {
        GeneratedMethod constructor = evaluatorClass.constructor(1);
        constructor.body().assign((AssignmentTarget)module, (GeneratedExpression)ExpressionFactory._new((TypeReference)typeElement));
    }

    private void generateGetName(String name, GeneratedClass evaluatorClass) {
        GeneratedMethod getName = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.ref(String.class), "getName");
        getName.body()._return(ExpressionFactory.lit((String)name));
    }

    private void generateSetName(GeneratedClass evaluatorClass) {
        GeneratedMethod setName = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, "setName");
        setName.param((org.mule.devkit.model.code.Type)this.ref(String.class), "name");
        setName.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnsupportedOperationException.class)));
    }

    private GeneratedClass getEvaluatorClass(String name, Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".expressions");
        GeneratedClass evaluator = pkg._class(NameUtils.camel((String)name) + "ExpressionEvaluator", ExpressionEvaluatorSupport.class, new Class[]{org.mule.api.expression.ExpressionEvaluator.class});
        evaluator._implements(this.ref(MuleContextAware.class));
        evaluator._implements(this.ref(Startable.class));
        evaluator._implements(this.ref(Stoppable.class));
        evaluator._implements(this.ref(Initialisable.class));
        evaluator._implements(this.ref(Disposable.class));
        this.ctx().registerProduct(Product.REGISTRY_BOOTSTRAP_ENTRY, (Identifiable)module, evaluator.name(), (Object)evaluator);
        return evaluator;
    }
}

