/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.devkit.generation.expressionlanguage;

import org.mule.api.annotations.ExpressionEnricher;
import org.mule.api.annotations.ExpressionEvaluator;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.*;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

public class ExpressionLanguageAnnotationVerifier implements ModuleAnnotationVerifier {
    @Override
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.EXPRESSION_LANGUAGE;
    }

    @Override
    public void verify(Module module,NotificationGatherer gatherer) throws AnnotationVerificationException {
        if (module.getMethodsAnnotatedWith(ExpressionEvaluator.class).size() > 1) {
            gatherer.error(module, Message.EXPRESSIONLANGUAGE_EXPRESSIONEVALUATOR_INCORRECT_COUNT);
        }
        if (module.getMethodsAnnotatedWith(ExpressionEnricher.class).size() > 1) {
            gatherer.error(module, Message.EXPRESSIONLANGUAGE_EXPRESSIONENRICHER_INCORRECT_COUNT);
        }
        if (module.getMethodsAnnotatedWith(ExpressionEvaluator.class).size() == 0 &&
                module.getMethodsAnnotatedWith(ExpressionEnricher.class).size() == 0) {
            gatherer.error(module, Message.EXPRESSIONLANGUAGE_REQUIRES_ENRICHER_OR_EVALUATOR_OR_BOTH);
        }
        for (Method<? extends Type> executableElement : module.getMethodsAnnotatedWith(ExpressionEvaluator.class)) {
            if (executableElement.getParameters().size() == 0) {
                gatherer.error(executableElement, Message.EXPRESSIONEVALUATOR_REQUIRES_STRING);
            }

            if (executableElement.getReturnType().toString().equals("void")) {
                gatherer.error(executableElement, Message.EXPRESSIONEVALUATOR_CANNOT_RETURN_VOID);
            }

            boolean expressionStringFound = false;
            for (Parameter parameter : executableElement.getParameters()) {
                if (!parameter.hasAnnotation(Payload.class) &&
                        !parameter.hasAnnotation(OutboundHeaders.class) &&
                        !parameter.hasAnnotation(InboundHeaders.class) &&
                        !parameter.hasAnnotation(SessionHeaders.class) &&
                        !parameter.hasAnnotation(InvocationHeaders.class) &&
                        !parameter.hasAnnotation(ExceptionPayload.class) &&
                        !parameter.hasAnnotation(CorrelationId.class) &&
                        !parameter.hasAnnotation(CorrelationSequence.class) ) {
                    if (parameter.asTypeMirror().toString().contains("String")) {
                        if (expressionStringFound) {
                            gatherer.error(executableElement, Message.EXPRESSIONEVALUATOR_REQUIRES_ANNOTATIONS);
                            continue;
                        }
                        expressionStringFound = true;
                    } else {
                        gatherer.error(executableElement, Message.EXPRESSIONEVALUATOR_REQUIRES_ANNOTATIONS);
                    }
                }
            }
        }

        for (Method<? extends Type> executableElement : module.getMethodsAnnotatedWith(ExpressionEnricher.class)) {
            if (executableElement.getParameters().size() == 0) {
                gatherer.error(executableElement, Message.EXPRESSIONENRICHER_REQUIRES_STRING);
            }

            if (!executableElement.getReturnType().toString().equals("void")) {
                gatherer.error(executableElement, Message.EXPRESSIONENRICHER_MUST_RETURN_VOID);
            }

            boolean expressionStringFound = false;
            boolean enrichObjectFound = false;
            for (Parameter parameter : executableElement.getParameters()) {
                if (!parameter.hasAnnotation(Payload.class) &&
                        !parameter.hasAnnotation(OutboundHeaders.class) &&
                        !parameter.hasAnnotation(InboundHeaders.class) &&
                        !parameter.hasAnnotation(SessionHeaders.class) &&
                        !parameter.hasAnnotation(InvocationHeaders.class) &&
                        !parameter.hasAnnotation(ExceptionPayload.class) &&
                        !parameter.hasAnnotation(CorrelationId.class) &&
                        !parameter.hasAnnotation(CorrelationSequence.class) ) {
                    if (parameter.asTypeMirror().toString().contains("String")) {
                        if (expressionStringFound) {
                            gatherer.error(executableElement, Message.EXPRESSIONENRICHER_WRONG_ARGUMENTS);
                            continue;
                        }
                        expressionStringFound = true;
                    } else if (parameter.asTypeMirror().toString().contains("Object")) {
                        if (enrichObjectFound) {
                            gatherer.error(executableElement, Message.EXPRESSIONENRICHER_WRONG_ARGUMENTS);
                            continue;
                        }
                        enrichObjectFound = true;
                    } else {
                        gatherer.error(executableElement, Message.EXPRESSIONENRICHER_WRONG_ARGUMENTS);
                    }
                }
            }

        }
    }
}
