/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.javadoc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.PostProcessor;
import org.mule.devkit.generation.api.PostProcessorException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.util.IOUtils;
import org.springframework.beans.factory.xml.PluggableSchemaResolver;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamplesPostProcessor
implements PostProcessor {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private Map<String, String> examplesFilesByPath = new HashMap<String, String>();

    public void postProcess(Context context) throws PostProcessorException {
        List modules = context.getModulesByProduct(Product.LIFECYCLE_ADAPTER);
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            ArrayList methodsToCheck = new ArrayList();
            methodsToCheck.addAll(module.getProcessorMethods());
            methodsToCheck.addAll(module.getSourceMethods());
            methodsToCheck.addAll(module.getTransformerMethods());
            File schema = this.getSchema(context, module);
            for (Method methodToCheck : methodsToCheck) {
                String example = this.getExample((Method<Type>)methodToCheck);
                context.note("Validating example for method: " + methodToCheck.getName());
                this.validateExampleAgainstSchema(module, methodToCheck, schema, example);
            }
        }
    }

    private File getSchema(Context context, Module module) {
        String directory = context.getMavenInformation().getOutputDirectory();
        String schemaFileName = context.getSchemaModel().getSchemaLocationByNamespace(module.getXmlNamespace()).getFileName();
        return new File(directory, schemaFileName);
    }

    private String getExample(Method<Type> method) throws PostProcessorException {
        String string;
        FileInputStream fileInputStream = null;
        try {
            String sampleTag = method.getJavaDocTagContent("sample.xml");
            String[] split = sampleTag.split(" ");
            String pathToExamplesFile = split[0];
            String exampleName = split[1];
            if (!this.examplesFilesByPath.containsKey(pathToExamplesFile)) {
                File examplesFile = this.getExamplesFile(method, pathToExamplesFile);
                fileInputStream = new FileInputStream(examplesFile);
                String examplesFileContent = IOUtils.toString((InputStream)fileInputStream);
                this.examplesFilesByPath.put(pathToExamplesFile, examplesFileContent);
            }
            String examplesFileContents = this.examplesFilesByPath.get(pathToExamplesFile);
            string = this.extractExampleFromFile(examplesFileContents, exampleName);
        }
        catch (IOException e) {
            try {
                throw new PostProcessorException(method, "Error extracting examples", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return string;
    }

    private String extractExampleFromFile(String examplesFileContent, String exampleName) {
        String beginTag = String.format("<!-- BEGIN_INCLUDE(%s) -->", exampleName);
        String endTag = String.format("<!-- END_INCLUDE(%s) -->", exampleName);
        String example = examplesFileContent.substring(examplesFileContent.indexOf(beginTag) + beginTag.length(), examplesFileContent.indexOf(endTag));
        return StringUtils.trim((String)example);
    }

    private File getExamplesFile(Method<Type> method, String pathToExamplesFile) {
        String sourcePath = ((Type)method.parent()).getPathToSourceFile();
        for (int packageCount = StringUtils.countMatches((String)((Type)method.parent()).getQualifiedName().toString(), (String)".") + 1; packageCount > 0; --packageCount) {
            sourcePath = sourcePath.substring(0, sourcePath.lastIndexOf("/"));
        }
        return new File(sourcePath, pathToExamplesFile);
    }

    protected void validateExampleAgainstSchema(Module module, Method method, File schema, String example) throws PostProcessorException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, schema);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(this.createErrorHandler());
            documentBuilder.setEntityResolver((EntityResolver)new PluggableSchemaResolver(this.getClass().getClassLoader()));
            String exampleWithNamespace = this.addNamespaceToExample(module, example);
            documentBuilder.parse(IOUtils.toInputStream((String)exampleWithNamespace));
        }
        catch (SAXException e) {
            throw new PostProcessorException((Identifiable)method, "Error validating example: " + e.getMessage() + " Failing example: " + example, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new PostProcessorException((Identifiable)method, "Error validating example: " + e.getMessage() + " Failing example: " + example, (Throwable)e);
        }
        catch (IOException e) {
            throw new PostProcessorException((Identifiable)method, "Error validating example: " + e.getMessage() + " Failing example: " + example, (Throwable)e);
        }
        catch (TransformerException e) {
            throw new PostProcessorException((Identifiable)method, "Error validating example: " + e.getMessage() + " Failing example: " + example, (Throwable)e);
        }
    }

    private ErrorHandler createErrorHandler() {
        return new ErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
            }

            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        };
    }

    private String addNamespaceToExample(Module module, String example) throws SAXException, IOException, ParserConfigurationException, TransformerException {
        Element node = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(IOUtils.toInputStream((String)example)).getDocumentElement();
        node.setAttribute("xmlns:" + module.getModuleName(), module.getXmlNamespace());
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        StringWriter buffer = new StringWriter();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(node), new StreamResult(buffer));
        return buffer.toString();
    }
}

