/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.license;

import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Modifier;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

import java.util.Arrays;
import java.util.List;

/**
 * <p>Adapter for license checking</p>
 */
public class CheckLicenseAdapterGenerator extends AbstractLicenseAdapterGenerator implements ModuleGenerator {

    private final static List<Product> CONSUMES = Arrays.asList(new Product[]{Product.CAPABILITIES_ADAPTER,
            Product.LIFECYCLE_ADAPTER,
            Product.INJECTION_ADAPTER,
            Product.CONNECTION_IDENTIFIER_ADAPTER,
            Product.OAUTH_ADAPTER,
            Product.ABSTRACT_EXPRESSION_EVALUATOR});
    private final static List<Product> PRODUCES = Arrays.asList(new Product[]{Product.LICENSE_CHECKER});

    protected void doGenerate(Module typeElement) throws GenerationException {
        GeneratedClass licenseCheckerAdapter = getLicenseCheckerAdapter(typeElement);
        GeneratedMethod initialise = licenseCheckerAdapter.method(Modifier.PUBLIC, context.getCodeModel().VOID, "initialise");
        initialise._throws(ref(InitialisationException.class));
        initialise.annotate(ref(Override.class));
        if (ref(Initialisable.class).isAssignableFrom(licenseCheckerAdapter._extends())) {
            initialise.body().invoke(ExpressionFactory._super(), Initialisable.PHASE_NAME);
        }

        new LicenseCheckerGenerator(context, typeElement).addTo(licenseCheckerAdapter).into(initialise);
    }

    private GeneratedClass getLicenseCheckerAdapter(Module typeElement) {

        GeneratedPackage pkg = ctx().getCodeModel()._package(typeElement.getPackage().getName() + ".adapters");
        TypeReference previous = ctx().<GeneratedClass>getProduct(Product.PROCESS_ADAPTER, typeElement).topLevelClass();
        GeneratedClass clazz = pkg._class(typeElement.getClassName() + "LicenseChecker", previous);
        clazz._implements(Initialisable.class);
        return clazz;
    }

    @Override
    public boolean shouldGenerate(Module typeElement) {
        return LicenseCheckerGenerator.requiresLicense(typeElement);
    }

    @Override
    public void generate(Module module) throws GenerationException {
        doGenerate(module);
    }

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }
}
