/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.license;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.license.AbstractLicenseAdapterGenerator;
import org.mule.devkit.generation.license.LicenseCheckerGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.module.Module;

public class CheckLicenseAdapterGenerator
extends AbstractLicenseAdapterGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.INJECTION_ADAPTER, Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, Product.OAUTH_ADAPTER, Product.ABSTRACT_EXPRESSION_EVALUATOR, Product.PROCESS_ADAPTER);
    private static final List<Product> PRODUCES = Collections.EMPTY_LIST;

    protected void doGenerate(Module typeElement) throws GenerationException {
        GeneratedClass licenseCheckerAdapter = this.getLicenseCheckerAdapter(typeElement);
        GeneratedMethod initialise = licenseCheckerAdapter.method(1, (Type)this.context.getCodeModel().VOID, "initialise");
        initialise._throws(this.ref(InitialisationException.class));
        initialise.annotate(this.ref(Override.class));
        if (this.ref(Initialisable.class).isAssignableFrom(licenseCheckerAdapter._extends())) {
            initialise.body().invoke(ExpressionFactory._super(), "initialise");
        }
        new LicenseCheckerGenerator(this.context, typeElement).addTo(licenseCheckerAdapter).into(initialise);
    }

    private GeneratedClass getLicenseCheckerAdapter(Module typeElement) {
        GeneratedClass clazz = (GeneratedClass)this.ctx().getProduct(Product.PROCESS_ADAPTER, (Identifiable)typeElement);
        clazz._implements(Initialisable.class);
        return clazz;
    }

    public boolean shouldGenerate(Module typeElement) {
        return LicenseCheckerGenerator.requiresLicense(typeElement);
    }

    public void generate(Module module) throws GenerationException {
        this.doGenerate(module);
    }

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }
}

