/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth;

import java.util.Arrays;
import java.util.List;
import oauth.signpost.OAuthConsumer;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.Capabilities;
import org.mule.api.Capability;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.config.MuleProperties;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.oauth.OAuthManager;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.store.ObjectStore;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedFieldReference;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthCallbackParameterField;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.util.StringUtils;

public class OAuthManagerGenerator
extends AbstractOAuthAdapterGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.OAUTH_ADAPTER, Product.INJECTION_ADAPTER, Product.HTTP_CALLBACK_ADAPTER, Product.OAUTH_ADAPTER, Product.MANAGED_ACCESS_TOKEN_PROCESS_TEMPLATE, Product.METADATA_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.OAUTH_MANAGER);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule && ((OAuthModule)module).getUserIdentifierMethod() != null;
    }

    public void generate(Module module) throws GenerationException {
        OAuthModule oauthModule = (OAuthModule)module;
        GeneratedClass oauthManagerClass = this.getOAuthManagerClass(oauthModule);
        GeneratedClass oauthClientFactoryClass = this.getOAuthClientFactoryClass(module);
        GeneratedField oauthManagerInFactory = oauthClientFactoryClass.field(4, (Type)oauthManagerClass, "oauthManager");
        GeneratedField logger = this.generateLoggerField(oauthManagerClass);
        this.generateOAuthClientFactoryConstructor(oauthManagerClass, oauthClientFactoryClass, oauthManagerInFactory);
        this.generateMakeObjectMethod(module, oauthClientFactoryClass, oauthManagerInFactory);
        this.generateDestroyObjectMethod(module, oauthClientFactoryClass);
        this.generateValidateObjectMethod(oauthClientFactoryClass);
        this.generateActivateObjectMethod(oauthClientFactoryClass);
        this.generatePassivateObjectMethod(module, oauthClientFactoryClass, oauthManagerInFactory);
        GeneratedField defaultUnauthorizedConnector = this.generateDefaultUnauthorizedConnectorField(module, oauthManagerClass);
        for (Field field : module.getConfigurableFields()) {
            GeneratedField configField = oauthManagerClass.field(4, this.ref(field.asTypeMirror()), field.getName());
            oauthManagerClass.setter(configField);
            oauthManagerClass.getter(configField);
        }
        GeneratedField muleContext = this.generateMuleContextField(oauthManagerClass, defaultUnauthorizedConnector);
        GeneratedField flowConstruct = this.generateFlowConstructField(oauthManagerClass, defaultUnauthorizedConnector);
        GeneratedField accessTokenObjectStore = oauthManagerClass.field(4, (Type)this.ref(ObjectStore.class), "accessTokenObjectStore");
        oauthManagerClass.getter(accessTokenObjectStore);
        oauthManagerClass.setter(accessTokenObjectStore);
        GeneratedField authorizationUrl = this.generateAuthorizationUrlField(oauthManagerClass);
        GeneratedField accessTokenUrl = this.generateAccessTokenUrlField(oauthManagerClass);
        if (((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A) {
            GeneratedField requestTokenUrl = this.generateRequestTokenUrlField(oauthManagerClass);
        }
        GeneratedField accessTokenPool = this.generateFieldForAccessTokenPool(oauthManagerClass);
        this.generateInitialiseMethod(oauthManagerClass, accessTokenPool, accessTokenObjectStore, oauthClientFactoryClass, defaultUnauthorizedConnector, oauthModule);
        this.generateStartMethod(oauthManagerClass, defaultUnauthorizedConnector);
        this.generateStopMethod(oauthManagerClass, defaultUnauthorizedConnector);
        this.generateDisposeMethod(oauthManagerClass, defaultUnauthorizedConnector);
        this.generateCreateAccessTokenMethod(module, oauthManagerClass);
        this.generateAcquireAccessTokenMethod(module, oauthManagerClass, accessTokenPool);
        this.generateReleaseAccessTokenMethod(module, oauthManagerClass, accessTokenPool);
        this.generateDestroyAccessTokenMethod(module, oauthManagerClass, accessTokenPool);
        this.generateIsCapableOfMethod(module, oauthManagerClass);
        this.generateGetProcessTemplateMethod(oauthModule, oauthManagerClass, ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass());
        this.generateMetadataConstantsAndGetters(module, oauthManagerClass);
        if (oauthModule.getOAuthVersion() == OAuthVersion.V2) {
            this.generateOAuth2AuthorizeMethod(oauthManagerClass, oauthModule, logger, authorizationUrl);
        } else if (oauthModule.getOAuthVersion() == OAuthVersion.V10A) {
            this.consumerField(oauthManagerClass);
            this.generateCreateConsumerMethod(oauthManagerClass, (OAuth)module.getAnnotation(OAuth.class), module);
            this.generateOAuth1AuthorizeMethod(oauthManagerClass, null, null, (Module)oauthModule, logger);
        }
    }

    private GeneratedField consumerField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(OAuthConsumer.class).name("consumer").build();
    }

    private void generateStartMethod(GeneratedClass oauthManagerClass, GeneratedField defaultUnauthorizedConnector) {
        GeneratedMethod start = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "start");
        start._throws(this.ref(MuleException.class));
        start.body()._if(Op._instanceof((GeneratedExpression)defaultUnauthorizedConnector, (Type)this.ref(Startable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)defaultUnauthorizedConnector).invoke("start"));
    }

    private void generateStopMethod(GeneratedClass oauthManagerClass, GeneratedField defaultUnauthorizedConnector) {
        GeneratedMethod stop = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "stop");
        stop._throws(this.ref(MuleException.class));
        stop.body()._if(Op._instanceof((GeneratedExpression)defaultUnauthorizedConnector, (Type)this.ref(Stoppable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)defaultUnauthorizedConnector).invoke("stop"));
    }

    private void generateDisposeMethod(GeneratedClass oauthManagerClass, GeneratedField defaultUnauthorizedConnector) {
        GeneratedMethod dispose = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "dispose");
        dispose.body()._if(Op._instanceof((GeneratedExpression)defaultUnauthorizedConnector, (Type)this.ref(Disposable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)defaultUnauthorizedConnector).invoke("dispose"));
    }

    public GeneratedField generateFlowConstructField(GeneratedClass oauthManagerClass, GeneratedField defaultUnauthorizedConnector) {
        GeneratedField flowConstruct = oauthManagerClass.field(2, (Type)this.ctx().getCodeModel().ref(FlowConstruct.class), "flowConstruct");
        flowConstruct.javadoc().add((Object)"Flow Construct");
        oauthManagerClass.getter(flowConstruct);
        GeneratedMethod setFlowConstruct = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setFlowConstruct");
        GeneratedVariable newFlowConstruct = setFlowConstruct.param((Type)this.ref(FlowConstruct.class), "flowConstruct");
        setFlowConstruct.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)flowConstruct), (GeneratedExpression)newFlowConstruct);
        setFlowConstruct.body()._if(Op._instanceof((GeneratedExpression)defaultUnauthorizedConnector, (Type)this.ref(FlowConstructAware.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(FlowConstructAware.class), (GeneratedExpression)defaultUnauthorizedConnector).invoke("setFlowConstruct").arg((GeneratedExpression)newFlowConstruct));
        return flowConstruct;
    }

    public GeneratedField generateMuleContextField(GeneratedClass oauthManagerClass, GeneratedField defaultUnauthorizedConnector) {
        GeneratedField muleContext = oauthManagerClass.field(2, (Type)this.ctx().getCodeModel().ref(MuleContext.class), "muleContext");
        muleContext.javadoc().add((Object)"muleContext");
        oauthManagerClass.getter(muleContext);
        GeneratedMethod setMuleContext = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setMuleContext");
        GeneratedVariable newMuleContext = setMuleContext.param((Type)this.ref(MuleContext.class), "muleContext");
        setMuleContext.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)muleContext), (GeneratedExpression)newMuleContext);
        setMuleContext.body()._if(Op._instanceof((GeneratedExpression)defaultUnauthorizedConnector, (Type)this.ref(MuleContextAware.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(MuleContextAware.class), (GeneratedExpression)defaultUnauthorizedConnector).invoke("setMuleContext").arg((GeneratedExpression)newMuleContext));
        return muleContext;
    }

    private GeneratedField generateDefaultUnauthorizedConnectorField(Module module, GeneratedClass oauthManagerClass) {
        GeneratedClass oauthAdapterClass = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedField defaultUnauthorizedConnector = oauthManagerClass.field(4, (Type)oauthAdapterClass, "defaultUnauthorizedConnector");
        oauthManagerClass.getter(defaultUnauthorizedConnector);
        return defaultUnauthorizedConnector;
    }

    private void generateOAuthClientFactoryConstructor(GeneratedClass oauthManagerClass, GeneratedClass oauthClientFactoryClass, GeneratedField oauthManagerInFactory) {
        GeneratedMethod oauthClientFactoryConstructor = oauthClientFactoryClass.constructor(1);
        GeneratedVariable constructorOAuthManager = oauthClientFactoryConstructor.param((Type)oauthManagerClass, "oauthManager");
        oauthClientFactoryConstructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)oauthManagerInFactory), (GeneratedExpression)constructorOAuthManager);
    }

    private GeneratedClass getOAuthManagerClass(OAuthModule module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass classToExtend = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
        TypeReference previous = (TypeReference)this.ctx().getProduct(Product.HTTP_CALLBACK_ADAPTER, (Identifiable)module);
        GeneratedClass oauthManagerClass = pkg._class(module.getClassName() + "OAuthManager", previous);
        oauthManagerClass._implements(this.ref(Initialisable.class));
        oauthManagerClass._implements(this.ref(Capabilities.class));
        oauthManagerClass._implements(this.ref(MuleContextAware.class));
        oauthManagerClass._implements(this.ref(OAuthManager.class).narrow((TypeReference)classToExtend));
        oauthManagerClass._implements(this.ref(ProcessAdapter.class).narrow((TypeReference)classToExtend));
        oauthManagerClass._implements(this.ref(MetadataAware.class));
        this.ctx().registerProduct(Product.OAUTH_MANAGER, (Identifiable)module, (Object)oauthManagerClass);
        oauthManagerClass.javadoc().add((Object)("A {@code " + oauthManagerClass.name() + "} is a wrapper around "));
        oauthManagerClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        oauthManagerClass.javadoc().add((Object)" that adds access token management capabilities to the pojo.");
        return oauthManagerClass;
    }

    private GeneratedField generateFieldForAccessTokenPool(GeneratedClass oauthManagerClass) {
        GeneratedField accessTokenPool = oauthManagerClass.field(4, (Type)this.ref(GenericKeyedObjectPool.class), "accessTokenPool");
        accessTokenPool.javadoc().add((Object)"Access Token Pool");
        return accessTokenPool;
    }

    private void generateInitialiseMethod(GeneratedClass oauthManagerClass, GeneratedField accessTokenPool, GeneratedField accessTokenObjectStore, GeneratedClass oauthClientFactoryClass, GeneratedField defaultUnauthorizedConnector, OAuthModule module) {
        GeneratedMethod initialisableMethod = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "initialise");
        initialisableMethod._throws(this.ref(InitialisationException.class));
        GeneratedVariable config = initialisableMethod.body().decl((Type)this.ref(GenericKeyedObjectPool.Config.class), "config", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(GenericKeyedObjectPool.Config.class)));
        if (module.getOAuthVersion() == OAuthVersion.V10A) {
            initialisableMethod.body().add((Statement)ExpressionFactory.invoke((String)"createConsumer"));
        }
        GeneratedConditional ifNotNull = initialisableMethod.body()._if(accessTokenObjectStore.isNull());
        ifNotNull._then().assign((AssignmentTarget)accessTokenObjectStore, (GeneratedExpression)oauthManagerClass.muleContextField().invoke("getRegistry").invoke("lookupObject").arg((GeneratedExpression)this.ref(MuleProperties.class).staticRef("DEFAULT_USER_OBJECT_STORE_NAME")));
        ifNotNull._then()._if(accessTokenObjectStore.isNull())._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(InitialisationException.class)).arg((GeneratedExpression)this.ref(CoreMessages.class).staticInvoke("createStaticMessage").arg("There is no default user object store on this Mule instance.")).arg(ExpressionFactory._this()));
        GeneratedInvocation newObjectFactory = ExpressionFactory._new((TypeReference)oauthClientFactoryClass).arg(ExpressionFactory._this());
        initialisableMethod.body().assign((AssignmentTarget)accessTokenPool, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(GenericKeyedObjectPool.class)).arg((GeneratedExpression)newObjectFactory).arg((GeneratedExpression)config));
        initialisableMethod.body().assign((AssignmentTarget)defaultUnauthorizedConnector, (GeneratedExpression)ExpressionFactory._new((Type)defaultUnauthorizedConnector.type()));
        initialisableMethod.body()._if(Op._instanceof((GeneratedExpression)defaultUnauthorizedConnector, (Type)this.ref(Initialisable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Initialisable.class), (GeneratedExpression)defaultUnauthorizedConnector).invoke("initialise"));
    }

    private GeneratedClass getOAuthClientFactoryClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass objectFactory = pkg._class(1, module.getClassName() + "OAuthClientFactory");
        objectFactory._implements(KeyedPoolableObjectFactory.class);
        return objectFactory;
    }

    private void generateMakeObjectMethod(Module module, GeneratedClass oauthClientFactoryClass, GeneratedField oauthManagerInFactory) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass stateClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_STATE, (Identifiable)module);
        GeneratedMethod makeObject = oauthClientFactoryClass.method(1, Object.class, "makeObject");
        makeObject._throws(this.ref(Exception.class));
        GeneratedVariable key = makeObject.param(Object.class, "key");
        GeneratedConditional ifNotKey = makeObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)key, (Type)this.ref(String.class))));
        ifNotKey._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid key type"));
        GeneratedVariable state = makeObject.body().decl((Type)stateClass, "state", ExpressionFactory._null());
        makeObject.body()._if(Op.not((GeneratedExpression)oauthManagerInFactory.invoke("getAccessTokenObjectStore").invoke("contains").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)key))))._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg(Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"There is no access token stored under the key "), (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)key)), (GeneratedExpression)ExpressionFactory.lit((String)". You need to call the <authorize> message processor. The key will be given to you via a flow variable after the OAuth dance is completed. You can extract it using flowVars['tokenId']."))));
        makeObject.body().assign((AssignmentTarget)state, (GeneratedExpression)ExpressionFactory.cast((Type)stateClass, (GeneratedExpression)oauthManagerInFactory.invoke("getAccessTokenObjectStore").invoke("retrieve").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)key))));
        GeneratedVariable connector = makeObject.body().decl((Type)connectorClass, "connector", (GeneratedExpression)ExpressionFactory._new((TypeReference)connectorClass));
        for (Field field : module.getConfigurableFields()) {
            makeObject.body().add((Statement)connector.invoke("set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName())).arg((GeneratedExpression)oauthManagerInFactory.invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName()))));
        }
        makeObject.body().add((Statement)connector.invoke("setAccessToken").arg((GeneratedExpression)state.invoke("getAccessToken")));
        makeObject.body().add((Statement)connector.invoke("setAuthorizationUrl").arg((GeneratedExpression)state.invoke("getAuthorizationUrl")));
        makeObject.body().add((Statement)connector.invoke("setAccessTokenUrl").arg((GeneratedExpression)state.invoke("getAccessTokenUrl")));
        if (((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A) {
            makeObject.body().add((Statement)connector.invoke("setAccessTokenSecret").arg((GeneratedExpression)state.invoke("getAccessTokenSecret")));
            makeObject.body().add((Statement)connector.invoke("setRequestTokenUrl").arg((GeneratedExpression)state.invoke("getRequestTokenUrl")));
        }
        if (((OAuthModule)module).getOAuthVersion() == OAuthVersion.V2) {
            makeObject.body().add((Statement)connector.invoke("setRefreshToken").arg((GeneratedExpression)state.invoke("getRefreshToken")));
        }
        for (Field field : ((OAuthModule)module).getCallbackParameters()) {
            makeObject.body().add((Statement)connector.invoke("set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName())).arg((GeneratedExpression)state.invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName()))));
        }
        makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(Initialisable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Initialisable.class), (GeneratedExpression)connector).invoke("initialise"));
        makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(MuleContextAware.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(MuleContextAware.class), (GeneratedExpression)connector).invoke("setMuleContext").arg((GeneratedExpression)oauthManagerInFactory.invoke("getMuleContext")));
        makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(Startable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)connector).invoke("start"));
        if (((OAuthModule)module).getPostAuthorizationMethod() != null) {
            makeObject.body().add((Statement)connector.invoke(((OAuthModule)module).getPostAuthorizationMethod().getName()));
        }
        makeObject.body()._return((GeneratedExpression)connector);
    }

    private void generateDestroyObjectMethod(Module module, GeneratedClass oauthClientFactoryClass) {
        GeneratedClass oauthAdapterClass = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedMethod destroyObject = oauthClientFactoryClass.method(1, (Type)this.ctx().getCodeModel().VOID, "destroyObject");
        destroyObject._throws(this.ref(Exception.class));
        GeneratedVariable key = destroyObject.param(Object.class, "key");
        GeneratedVariable obj = destroyObject.param(Object.class, "obj");
        GeneratedConditional ifNotKey = destroyObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)key, (Type)this.ref(String.class))));
        ifNotKey._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid key type"));
        GeneratedConditional ifNotObj = destroyObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)obj, (Type)oauthAdapterClass)));
        ifNotObj._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid connector type"));
        GeneratedCast casterConnector = ExpressionFactory.cast((Type)oauthAdapterClass, (GeneratedExpression)obj);
        GeneratedTry tryDisconnect = destroyObject.body()._try();
        GeneratedCatchBlock catchAndRethrow = tryDisconnect._catch(this.ref(Exception.class));
        GeneratedVariable e = catchAndRethrow.param("e");
        catchAndRethrow.body()._throw((GeneratedExpression)e);
        tryDisconnect._finally()._if(Op._instanceof((GeneratedExpression)casterConnector, (Type)this.ref(Stoppable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)obj).invoke("stop"));
        tryDisconnect._finally()._if(Op._instanceof((GeneratedExpression)casterConnector, (Type)this.ref(Disposable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)obj).invoke("dispose"));
    }

    private void generateValidateObjectMethod(GeneratedClass oauthClientFactoryClass) {
        GeneratedMethod validateObject = oauthClientFactoryClass.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "validateObject");
        validateObject.param(Object.class, "key");
        GeneratedVariable obj = validateObject.param(Object.class, "obj");
        validateObject.body()._return(ExpressionFactory.TRUE);
    }

    private void generateActivateObjectMethod(GeneratedClass oauthClientFactoryClass) {
        GeneratedMethod activateObject = oauthClientFactoryClass.method(1, (Type)this.ctx().getCodeModel().VOID, "activateObject");
        activateObject._throws(this.ref(Exception.class));
        GeneratedVariable key = activateObject.param(Object.class, "key");
        GeneratedVariable obj = activateObject.param(Object.class, "obj");
    }

    private void generatePassivateObjectMethod(Module module, GeneratedClass oauthClientFactoryClass, GeneratedField oauthManager) {
        GeneratedMethod passivateObject = oauthClientFactoryClass.method(1, (Type)this.ctx().getCodeModel().VOID, "passivateObject");
        passivateObject._throws(this.ref(Exception.class));
        GeneratedVariable key = passivateObject.param(Object.class, "key");
        GeneratedVariable obj = passivateObject.param(Object.class, "obj");
        GeneratedConditional ifNotKey = passivateObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)key, (Type)this.ref(String.class))));
        ifNotKey._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid key type"));
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass stateClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_STATE, (Identifiable)module);
        GeneratedConditional ifNotObj = passivateObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)obj, (Type)connectorClass)));
        ifNotObj._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid connector type"));
        GeneratedVariable state = passivateObject.body().decl((Type)stateClass, "state", ExpressionFactory._null());
        GeneratedConditional ifStateExists = passivateObject.body()._if((GeneratedExpression)oauthManager.invoke("getAccessTokenObjectStore").invoke("contains").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)key)));
        ifStateExists._then().assign((AssignmentTarget)state, (GeneratedExpression)ExpressionFactory.cast((Type)stateClass, (GeneratedExpression)oauthManager.invoke("getAccessTokenObjectStore").invoke("retrieve").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)key))));
        ifStateExists._then().add((Statement)oauthManager.invoke("getAccessTokenObjectStore").invoke("remove").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)key)));
        passivateObject.body()._if(state.isNull())._then().assign((AssignmentTarget)state, (GeneratedExpression)ExpressionFactory._new((TypeReference)stateClass));
        passivateObject.body().add((Statement)state.invoke("setAccessToken").arg((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj).invoke("getAccessToken")));
        passivateObject.body().add((Statement)state.invoke("setAccessTokenUrl").arg((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj).invoke("getAccessTokenUrl")));
        passivateObject.body().add((Statement)state.invoke("setAuthorizationUrl").arg((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj).invoke("getAuthorizationUrl")));
        if (((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A) {
            passivateObject.body().add((Statement)state.invoke("setAccessTokenSecret").arg((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj).invoke("getAccessTokenSecret")));
            passivateObject.body().add((Statement)state.invoke("setRequestTokenUrl").arg((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj).invoke("getRequestTokenUrl")));
        }
        if (((OAuthModule)module).getOAuthVersion() == OAuthVersion.V2) {
            passivateObject.body().add((Statement)state.invoke("setRefreshToken").arg((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj).invoke("getRefreshToken")));
        }
        for (OAuthCallbackParameterField field : ((OAuthModule)module).getCallbackParameters()) {
            passivateObject.body().add((Statement)state.invoke("set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName())).arg((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj).invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName()))));
        }
        passivateObject.body().add((Statement)oauthManager.invoke("getAccessTokenObjectStore").invoke("store").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)key)).arg((GeneratedExpression)state));
    }

    private void generateAcquireAccessTokenMethod(Module module, GeneratedClass oauthManagerClass, GeneratedField accessTokenPool) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedMethod acquireAccessTokenMethod = oauthManagerClass.method(1, (Type)connectorClass, "acquireAccessToken");
        GeneratedVariable userId = acquireAccessTokenMethod.param((Type)this.ref(String.class), "userId");
        acquireAccessTokenMethod._throws(this.ref(Exception.class));
        acquireAccessTokenMethod.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)accessTokenPool.invoke("borrowObject").arg((GeneratedExpression)userId)));
    }

    private void generateCreateAccessTokenMethod(Module module, GeneratedClass oauthManagerClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedMethod acquireAccessTokenMethod = oauthManagerClass.method(1, (Type)connectorClass, "createAccessToken");
        GeneratedVariable verifier = acquireAccessTokenMethod.param((Type)this.ref(String.class), "verifier");
        acquireAccessTokenMethod._throws(this.ref(Exception.class));
        GeneratedVariable connector = acquireAccessTokenMethod.body().decl((Type)connectorClass, "connector", (GeneratedExpression)ExpressionFactory._new((TypeReference)connectorClass));
        acquireAccessTokenMethod.body().add((Statement)connector.invoke("setOauthVerifier").arg((GeneratedExpression)verifier));
        acquireAccessTokenMethod.body().add((Statement)connector.invoke("setAuthorizationUrl").arg((GeneratedExpression)ExpressionFactory.invoke((String)"getAuthorizationUrl")));
        acquireAccessTokenMethod.body().add((Statement)connector.invoke("setAccessTokenUrl").arg((GeneratedExpression)ExpressionFactory.invoke((String)"getAccessTokenUrl")));
        if (((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A) {
            acquireAccessTokenMethod.body().add((Statement)connector.invoke("setRequestTokenUrl").arg((GeneratedExpression)ExpressionFactory.invoke((String)"getRequestTokenUrl")));
        }
        for (Field field : module.getConfigurableFields()) {
            acquireAccessTokenMethod.body().add((Statement)connector.invoke(field.getSetter().getName()).arg((GeneratedExpression)ExpressionFactory.invoke((String)field.getGetter().getName())));
        }
        acquireAccessTokenMethod.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(MuleContextAware.class)))._then().add((Statement)connector.invoke("setMuleContext").arg((GeneratedExpression)ExpressionFactory.ref((String)"muleContext")));
        acquireAccessTokenMethod.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(Initialisable.class)))._then().add((Statement)connector.invoke("initialise"));
        acquireAccessTokenMethod.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(Startable.class)))._then().add((Statement)connector.invoke("start"));
        acquireAccessTokenMethod.body()._return((GeneratedExpression)connector);
    }

    private void generateReleaseAccessTokenMethod(Module module, GeneratedClass oauthManagerClass, GeneratedField accessTokenPool) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedMethod releaseAccessToken = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "releaseAccessToken");
        GeneratedVariable userId = releaseAccessToken.param((Type)this.ref(String.class), "userId");
        releaseAccessToken._throws(this.ref(Exception.class));
        GeneratedVariable connector = releaseAccessToken.param((Type)connectorClass, "connector");
        releaseAccessToken.body().add((Statement)accessTokenPool.invoke("returnObject").arg((GeneratedExpression)userId).arg((GeneratedExpression)connector));
    }

    private void generateDestroyAccessTokenMethod(Module module, GeneratedClass oauthManagerClass, GeneratedField accessTokenPool) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedMethod destroyConnector = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "destroyAccessToken");
        GeneratedVariable userId = destroyConnector.param((Type)this.ref(String.class), "userId");
        destroyConnector._throws(this.ref(Exception.class));
        GeneratedVariable connector = destroyConnector.param((Type)connectorClass, "connector");
        destroyConnector.body().add((Statement)accessTokenPool.invoke("invalidateObject").arg((GeneratedExpression)userId).arg((GeneratedExpression)connector));
    }

    protected void generateIsCapableOfMethod(Module module, GeneratedClass capabilitiesAdapter) {
        GeneratedMethod isCapableOf = capabilitiesAdapter.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isCapableOf");
        GeneratedVariable capability = isCapableOf.param((Type)this.ref(Capability.class), "capability");
        isCapableOf.javadoc().add((Object)"Returns true if this module implements such capability");
        this.addCapability(isCapableOf, capability, this.ref(Capability.class).staticRef("LIFECYCLE_CAPABLE"));
        if (module instanceof OAuthModule && ((OAuthModule)module).getOAuthVersion() == OAuthVersion.V2) {
            this.addCapability(isCapableOf, capability, this.ref(Capability.class).staticRef("OAUTH2_CAPABLE"));
        }
        if (module instanceof OAuthModule && ((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A) {
            this.addCapability(isCapableOf, capability, this.ref(Capability.class).staticRef("OAUTH1_CAPABLE"));
        }
        if (module instanceof OAuthModule && ((OAuthModule)module).getUserIdentifierMethod() != null) {
            this.addCapability(isCapableOf, capability, this.ref(Capability.class).staticRef("OAUTH_ACCESS_TOKEN_MANAGEMENT_CAPABLE"));
        }
        isCapableOf.body()._return(ExpressionFactory.FALSE);
    }

    private void addCapability(GeneratedMethod capableOf, GeneratedVariable capability, GeneratedFieldReference capabilityToCheckFor) {
        GeneratedConditional isCapable = capableOf.body()._if(Op.eq((GeneratedExpression)capability, (GeneratedExpression)capabilityToCheckFor));
        isCapable._then()._return(ExpressionFactory.TRUE);
    }

    protected void generateMetadataConstantsAndGetters(Module module, GeneratedClass generatedClass) {
        String connectorName = module.getFriendlyName();
        if (StringUtils.isEmpty((String)connectorName)) {
            connectorName = module.getModuleName();
        }
        GeneratedField moduleName = FieldBuilder.newConstantFieldBuilder((GeneratedClass)generatedClass).type(String.class).name("MODULE_NAME").initialValue(connectorName).build();
        GeneratedField moduleVersion = FieldBuilder.newConstantFieldBuilder((GeneratedClass)generatedClass).type(String.class).name("MODULE_VERSION").initialValue(this.ctx().getMavenInformation().getVersion()).build();
        GeneratedField devkitVersion = FieldBuilder.newConstantFieldBuilder((GeneratedClass)generatedClass).type(String.class).name("DEVKIT_VERSION").initialValue(this.ctx().getManifest().getProductVersion()).build();
        GeneratedField devkitBuild = FieldBuilder.newConstantFieldBuilder((GeneratedClass)generatedClass).type(String.class).name("DEVKIT_BUILD").initialValue(this.ctx().getManifest().getBuildNumber()).build();
        this.generateGetter(generatedClass, moduleName, "getModuleName");
        this.generateGetter(generatedClass, moduleVersion, "getModuleVersion");
        this.generateGetter(generatedClass, devkitVersion, "getDevkitVersion");
        this.generateGetter(generatedClass, devkitBuild, "getDevkitBuild");
    }

    private void generateGetter(GeneratedClass metadataAdapter, GeneratedField field, String getterMethodName) {
        GeneratedMethod getter = metadataAdapter.method(1, (Type)this.ref(String.class), getterMethodName);
        getter.body()._return((GeneratedExpression)field);
    }

    private void generateGetProcessTemplateMethod(OAuthModule module, GeneratedClass oauthAdapterClass, GeneratedClass capabilitiesAdapterClass) {
        GeneratedClass managedOAuthProcessTemplateClass = (GeneratedClass)this.ctx().getProduct(Product.MANAGED_ACCESS_TOKEN_PROCESS_TEMPLATE);
        GeneratedMethod getProcessTemplate = oauthAdapterClass.method(1, (Type)this.ref(ProcessTemplate.class), "getProcessTemplate");
        getProcessTemplate.annotate(this.ref(Override.class));
        TypeVariable p = getProcessTemplate.generify("P");
        getProcessTemplate.type((Type)this.ref(ProcessTemplate.class).narrow((TypeReference)p).narrow((TypeReference)capabilitiesAdapterClass));
        GeneratedInvocation newProcessTemplate = ExpressionFactory._new((TypeReference)managedOAuthProcessTemplateClass).arg(ExpressionFactory._this());
        newProcessTemplate.arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"));
        getProcessTemplate.body()._return((GeneratedExpression)newProcessTemplate);
    }
}

