/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth.process;

import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.oauth.OAuth2Adapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;

public class RefreshTokenProcessInterceptorGenerator
extends AbstractOAuthAdapterGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CONNECTION_KEY, Product.OAUTH_ADAPTER, Product.ABSTRACT_EXPRESSION_EVALUATOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.REFRESH_TOKEN_PROCESS_INTERCEPTOR);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule && ((OAuthModule)module).getUserIdentifierMethod() != null;
    }

    public void generate(Module module) throws GenerationException {
        OAuthModule oauthModule = (OAuthModule)module;
        GeneratedClass oauthAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module);
        GeneratedClass refreshTokenProcessInterceptorClass = this.getRefreshTokenProcessInterceptorClass(oauthModule);
        TypeVariable t = refreshTokenProcessInterceptorClass.generify("T");
        refreshTokenProcessInterceptorClass._implements(this.ref(ProcessInterceptor.class).narrow((TypeReference)t).narrow((TypeReference)oauthAdapterClass));
        GeneratedField logger = this.generateLoggerField(refreshTokenProcessInterceptorClass);
        GeneratedField next = refreshTokenProcessInterceptorClass.field(12, (Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)t).narrow((TypeReference)oauthAdapterClass), "next");
        this.generateConstructor(refreshTokenProcessInterceptorClass, oauthModule, next);
        this.generateExecuteMethod(oauthModule, oauthAdapterClass, refreshTokenProcessInterceptorClass, t, logger, next);
    }

    private GeneratedClass getRefreshTokenProcessInterceptorClass(OAuthModule type) {
        GeneratedClass abstractExpressionEvaluatorClass = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_EXPRESSION_EVALUATOR);
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(type.getPackage().getName() + ".oauth");
        GeneratedClass clazz = pkg._class(1, "RefreshTokenProcessInterceptor");
        clazz._extends((TypeReference)abstractExpressionEvaluatorClass);
        this.ctx().registerProduct(Product.REFRESH_TOKEN_PROCESS_INTERCEPTOR, (Object)clazz);
        return clazz;
    }

    private void generateConstructor(GeneratedClass refreshTokenProcessInterceptorClass, OAuthModule module, GeneratedField nextField) {
        GeneratedClass oauthAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module);
        GeneratedMethod constructor = refreshTokenProcessInterceptorClass.constructor(1);
        GeneratedVariable next = constructor.param((Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)refreshTokenProcessInterceptorClass.typeParams()[0]).narrow((TypeReference)oauthAdapterClass), "next");
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)nextField), (GeneratedExpression)next);
    }

    private void generateExecuteMethod(OAuthModule oauthModule, GeneratedClass oauthAdapterClass, GeneratedClass refreshTokenProcessInterceptorClass, TypeVariable t, GeneratedField logger, GeneratedField next) {
        GeneratedMethod execute = refreshTokenProcessInterceptorClass.method(1, (Type)t, "execute");
        execute._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = execute.param((Type)this.ref(ProcessCallback.class).narrow((TypeReference)t).narrow((TypeReference)oauthAdapterClass), "processCallback");
        GeneratedVariable object = execute.param((Type)oauthAdapterClass, "object");
        GeneratedVariable messageProcessor = execute.param((Type)this.ref(MessageProcessor.class), "messageProcessor");
        GeneratedVariable event = execute.param((Type)this.ref(MuleEvent.class), "event");
        GeneratedVariable result = execute.body().decl((Type)t, "result", ExpressionFactory._null());
        GeneratedVariable cause = execute.body().decl((Type)this.ref(Exception.class), "cause", ExpressionFactory._null());
        GeneratedTry attempt = execute.body()._try();
        attempt.body().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._this().ref((GeneratedVariable)next).invoke("execute").arg((GeneratedExpression)processCallback).arg((GeneratedExpression)object).arg((GeneratedExpression)messageProcessor).arg((GeneratedExpression)event));
        attempt.body()._return((GeneratedExpression)result);
        GeneratedCatchBlock catchException = attempt._catch(this.ref(Exception.class));
        GeneratedVariable e = catchException.param("e");
        GeneratedConditional ifManagedExceptions = catchException.body()._if(processCallback.invoke("getManagedExceptions").isNotNull());
        GeneratedForEach forEachException = ifManagedExceptions._then().forEach((Type)this.ref(Class.class), "exceptionClass", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(this.ref(Class.class)), (GeneratedExpression)processCallback.invoke("getManagedExceptions")));
        GeneratedConditional ifIsManaged = forEachException.body()._if((GeneratedExpression)forEachException.var().invoke("isInstance").arg((GeneratedExpression)e));
        GeneratedConditional ifRefreshToken = ifIsManaged._then()._if(ExpressionFactory.cast((Type)this.ref(OAuth2Adapter.class), (GeneratedExpression)object).invoke("getRefreshToken").isNotNull());
        ifRefreshToken._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().invoke((GeneratedExpression)logger, "debug").arg("A managed exception has been thrown. Attempting to refresh access token.");
        GeneratedTry refreshAccessTokenAttempt = ifRefreshToken._then()._try();
        refreshAccessTokenAttempt.body().invoke((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(OAuth2Adapter.class), (GeneratedExpression)object), "refreshAccessToken").arg((GeneratedExpression)ExpressionFactory.cast((Type)oauthAdapterClass, (GeneratedExpression)object).invoke("getAccessTokenUrl"));
        GeneratedCatchBlock catchExceptionOnRefreshToken = refreshAccessTokenAttempt._catch(this.ref(Exception.class));
        GeneratedVariable newException = catchExceptionOnRefreshToken.param("newException");
        catchExceptionOnRefreshToken.body()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().invoke((GeneratedExpression)logger, "debug").arg("Another exception was thrown while attempting to refresh the access token. Throwing original exception back up");
        catchExceptionOnRefreshToken.body()._throw((GeneratedExpression)e);
        ifRefreshToken._then().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._this().ref((GeneratedVariable)next).invoke("execute").arg((GeneratedExpression)processCallback).arg((GeneratedExpression)object).arg((GeneratedExpression)messageProcessor).arg((GeneratedExpression)event));
        ifRefreshToken._then()._return((GeneratedExpression)result);
        catchException.body()._throw((GeneratedExpression)e);
    }
}

