/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth.process;

import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.oauth.OAuthAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;

@JustOnce
public class OAuthProcessTemplateGenerator
extends AbstractOAuthAdapterGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.OAUTH_PROCESS_TEMPLATE);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass processTemplateClass = this.getOAuthProcessTemplateClass(module);
        GeneratedField object = this.generateObjectField(processTemplateClass, module);
        this.generateConstructor(processTemplateClass, object, module);
        this.generateExecuteMethod(module, processTemplateClass, object);
    }

    private void generateExecuteMethod(Module module, GeneratedClass processTemplate, GeneratedField object) {
        GeneratedClass capabilitiesAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module);
        GeneratedMethod execute = processTemplate.method(1, (Type)processTemplate.typeParams()[0], "execute");
        execute._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = execute.param((Type)this.ref(ProcessCallback.class).narrow((TypeReference)processTemplate.typeParams()[0]).narrow((TypeReference)capabilitiesAdapterClass), "processCallback");
        execute.param((Type)this.ref(MessageProcessor.class), "messageProcessor");
        execute.param((Type)this.ref(MuleEvent.class), "event");
        execute.body()._if((GeneratedExpression)processCallback.invoke("isProtected"))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(OAuthAdapter.class), (GeneratedExpression)object).invoke("hasBeenAuthorized"));
        execute.body()._return((GeneratedExpression)processCallback.invoke("process").arg((GeneratedExpression)object));
    }

    private void generateConstructor(GeneratedClass processTemplate, GeneratedField object, Module module) {
        GeneratedClass capabilitiesAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module);
        GeneratedMethod constructor = processTemplate.constructor(1);
        GeneratedVariable newObject = constructor.param((Type)capabilitiesAdapterClass, "object");
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)object), (GeneratedExpression)newObject);
    }

    private GeneratedField generateObjectField(GeneratedClass processTemplate, Module module) {
        GeneratedClass capabilitiesAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module);
        return processTemplate.field(12, (Type)capabilitiesAdapterClass, "object");
    }

    private GeneratedClass getOAuthProcessTemplateClass(Module module) {
        GeneratedClass capabilitiesAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module);
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass processTemplateClass = pkg._class(1, "OAuthProcessTemplate");
        TypeVariable payload = processTemplateClass.generify("P");
        processTemplateClass._implements(this.ref(ProcessTemplate.class).narrow((TypeReference)payload).narrow((TypeReference)capabilitiesAdapterClass));
        this.ctx().registerProduct(Product.OAUTH_PROCESS_TEMPLATE, (Object)processTemplateClass);
        return processTemplateClass;
    }
}

