/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth;

import oauth.signpost.OAuthConsumer;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.exception.OAuthNotAuthorizedException;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.oauth.OAuth1Adapter;
import org.mule.api.oauth.UnableToAcquireAccessTokenException;
import org.mule.api.process.ProcessTemplate;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;

public class OAuth1ClientAdapterGenerator
extends AbstractOAuthAdapterGenerator {
    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule && ((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass oauthAdapter = this.getOAuthAdapterClass(module, "OAuth1Adapter", OAuth1Adapter.class);
        OAuthModule oAuthModule = (OAuthModule)module;
        OAuth oauth = (OAuth)module.getAnnotation(OAuth.class);
        this.muleContextField(oauthAdapter);
        GeneratedField logger = this.generateLoggerField(oauthAdapter);
        GeneratedField requestToken = this.requestTokenField(oauthAdapter);
        GeneratedField requestTokenSecret = this.requestTokenSecretField(oauthAdapter);
        GeneratedField oauthVerifier = this.authorizationCodeField(oauthAdapter);
        GeneratedField saveAccessTokenCallback = this.saveAccessTokenCallbackField(oauthAdapter);
        GeneratedField restoreAccessTokenCallback = this.restoreAccessTokenCallbackField(oauthAdapter);
        this.consumerField(oauthAdapter);
        GeneratedField authorizationUrl = this.generateAuthorizationUrlField(oauthAdapter);
        GeneratedField accessTokenUrl = this.generateAccessTokenUrlField(oauthAdapter);
        GeneratedField requestTokenUrl = this.generateRequestTokenUrlField(oauthAdapter);
        GeneratedMethod createConsumer = this.generateCreateConsumerMethod(oauthAdapter, oauth, module);
        this.generateGetConsumerMethod(oauthAdapter);
        this.generateInitialiseMethod(oauthAdapter, createConsumer);
        this.generateOAuth1AuthorizeMethod(oauthAdapter, requestToken, requestTokenSecret, module, logger);
        this.generateRestoreAccessTokenMethod(oAuthModule, oauthAdapter, restoreAccessTokenCallback, logger);
        this.generateFetchAccessTokenMethod(oauthAdapter, requestToken, requestTokenSecret, saveAccessTokenCallback, oauthVerifier, oAuthModule, oauth, logger);
        this.generateHasBeenAuthorizedMethod(oAuthModule, oauthAdapter);
        this.generateGetProcessTemplateMethod(oAuthModule, oauthAdapter, (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module));
        this.generateResetMethod(oAuthModule, oauthAdapter);
    }

    private GeneratedField requestTokenField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name("requestToken").build();
    }

    private GeneratedField requestTokenSecretField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name("requestTokenSecret").build();
    }

    private GeneratedField consumerField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(OAuthConsumer.class).name("consumer").build();
    }

    private void generateGetConsumerMethod(GeneratedClass oauthAdapter) {
        GeneratedMethod getConsumer = oauthAdapter.method(1, (Type)this.ref(OAuthConsumer.class), "getConsumer");
        getConsumer.body()._return((GeneratedExpression)oauthAdapter.fields().get("consumer"));
    }

    private void generateInitialiseMethod(GeneratedClass oauthAdapter, GeneratedMethod createConsumer) {
        GeneratedMethod initialise = this.generateInitialiseMethod(oauthAdapter);
        initialise._throws(this.ref(InitialisationException.class));
        initialise.body().invoke(createConsumer);
    }

    private void generateRestoreAccessTokenMethod(OAuthModule module, GeneratedClass oauthAdapter, GeneratedField restoreAccessTokenCallbackField, GeneratedField logger) {
        GeneratedMethod restoreAccessTokenMethod = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "restoreAccessToken");
        GeneratedConditional ifRestoreCallbackNotNull = restoreAccessTokenMethod.body()._if(restoreAccessTokenCallbackField.isNotNull());
        GeneratedConditional ifDebugEnabled = ifRestoreCallbackNotNull._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
        GeneratedVariable messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Attempting to restore access token..."));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        GeneratedTry tryToRestore = ifRestoreCallbackNotNull._then()._try();
        tryToRestore.body().add((Statement)restoreAccessTokenCallbackField.invoke("restoreAccessToken"));
        tryToRestore.body().invoke(module.getAccessTokenField().getSetter().getName()).arg((GeneratedExpression)restoreAccessTokenCallbackField.invoke("getAccessToken"));
        tryToRestore.body().invoke(module.getAccessTokenSecretField().getSetter().getName()).arg((GeneratedExpression)restoreAccessTokenCallbackField.invoke("getAccessTokenSecret"));
        GeneratedField consumer = (GeneratedField)oauthAdapter.fields().get("consumer");
        tryToRestore.body().add((Statement)consumer.invoke("setTokenWithSecret").arg((GeneratedExpression)restoreAccessTokenCallbackField.invoke("getAccessToken")).arg((GeneratedExpression)restoreAccessTokenCallbackField.invoke("getAccessTokenSecret")));
        ifDebugEnabled = tryToRestore.body()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Access token and secret has been restored successfully "));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessToken = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)restoreAccessTokenCallbackField.invoke("getAccessToken")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessTokenSecret = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)restoreAccessTokenCallbackField.invoke("getAccessTokenSecret")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        tryToRestore.body()._return(ExpressionFactory.TRUE);
        GeneratedCatchBlock logIfCannotRestore = tryToRestore._catch(this.ref(Exception.class));
        GeneratedVariable e = logIfCannotRestore.param("e");
        logIfCannotRestore.body().add((Statement)logger.invoke("error").arg("Cannot restore access token, an unexpected error occurred").arg((GeneratedExpression)e));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        restoreAccessTokenMethod.body()._return(ExpressionFactory.FALSE);
    }

    private void generateFetchAccessTokenMethod(GeneratedClass oauthAdapter, GeneratedField requestToken, GeneratedField requestTokenSecret, GeneratedField saveAccessTokenCallback, GeneratedField oauthVerifier, OAuthModule module, OAuth oauth, GeneratedField logger) {
        GeneratedMethod fetchAccessToken = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "fetchAccessToken");
        GeneratedVariable requestTokenUrl = fetchAccessToken.param((Type)this.ref(String.class), "requestTokenUrl");
        GeneratedVariable accessTokenUrl = fetchAccessToken.param((Type)this.ref(String.class), "accessTokenUrl");
        GeneratedVariable authorizationUrl = fetchAccessToken.param((Type)this.ref(String.class), "authorizationUrl");
        GeneratedVariable redirectUri = fetchAccessToken.param((Type)this.ref(String.class), "redirectUri");
        fetchAccessToken._throws(this.ref(UnableToAcquireAccessTokenException.class));
        fetchAccessToken.body().invoke("restoreAccessToken");
        GeneratedConditional ifAccessTokenNullOrSecretNull = fetchAccessToken.body()._if(Op.cor((GeneratedExpression)ExpressionFactory.invoke((String)module.getAccessTokenField().getGetter().getName()).isNull(), (GeneratedExpression)ExpressionFactory.invoke((String)module.getAccessTokenSecretField().getGetter().getName()).isNull()));
        GeneratedVariable provider = this.generateProvider(requestTokenUrl, accessTokenUrl, authorizationUrl, ifAccessTokenNullOrSecretNull._then(), (Module)module);
        GeneratedField consumer = (GeneratedField)oauthAdapter.fields().get("consumer");
        ifAccessTokenNullOrSecretNull._then().invoke((GeneratedExpression)consumer, "setTokenWithSecret").arg((GeneratedExpression)requestToken).arg((GeneratedExpression)requestTokenSecret);
        GeneratedTry tryRetrieveAccessToken = ifAccessTokenNullOrSecretNull._then()._try();
        GeneratedConditional ifDebugEnabled = tryRetrieveAccessToken.body()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
        GeneratedVariable messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Retrieving access token..."));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        tryRetrieveAccessToken.body().invoke((GeneratedExpression)provider, "retrieveAccessToken").arg((GeneratedExpression)consumer).arg((GeneratedExpression)oauthVerifier);
        this.generateCatchAndReThrow(tryRetrieveAccessToken, OAuthMessageSignerException.class, UnableToAcquireAccessTokenException.class);
        this.generateCatchAndReThrow(tryRetrieveAccessToken, OAuthNotAuthorizedException.class, UnableToAcquireAccessTokenException.class);
        this.generateCatchAndReThrow(tryRetrieveAccessToken, OAuthExpectationFailedException.class, UnableToAcquireAccessTokenException.class);
        this.generateCatchAndReThrow(tryRetrieveAccessToken, OAuthCommunicationException.class, UnableToAcquireAccessTokenException.class);
        ifAccessTokenNullOrSecretNull._then().invoke(module.getAccessTokenField().getSetter().getName()).arg((GeneratedExpression)consumer.invoke("getToken"));
        ifAccessTokenNullOrSecretNull._then().invoke(module.getAccessTokenSecretField().getSetter().getName()).arg((GeneratedExpression)consumer.invoke("getTokenSecret"));
        ifDebugEnabled = ifAccessTokenNullOrSecretNull._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Access token retrieved successfully "));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessToken = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)ExpressionFactory.invoke((String)module.getAccessTokenField().getGetter().getName())));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessTokenSecret = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)ExpressionFactory.invoke((String)module.getAccessTokenSecretField().getGetter().getName())));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        GeneratedConditional ifSaveCallbackNotNull = ifAccessTokenNullOrSecretNull._then()._if(saveAccessTokenCallback.isNotNull());
        GeneratedInvocation saveAccessToken = saveAccessTokenCallback.invoke("saveAccessToken").arg((GeneratedExpression)ExpressionFactory.invoke((String)module.getAccessTokenField().getGetter().getName())).arg((GeneratedExpression)ExpressionFactory.invoke((String)module.getAccessTokenSecretField().getGetter().getName()));
        GeneratedTry tryToSave = ifSaveCallbackNotNull._then()._try();
        ifDebugEnabled = ifSaveCallbackNotNull._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Attempting to save access token..."));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessToken = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)ExpressionFactory.invoke((String)module.getAccessTokenField().getGetter().getName())));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessTokenSecret = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)ExpressionFactory.invoke((String)module.getAccessTokenSecretField().getGetter().getName())));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        tryToSave.body().add((Statement)saveAccessToken);
        GeneratedCatchBlock logIfCannotSave = tryToSave._catch(this.ref(Exception.class));
        GeneratedVariable e2 = logIfCannotSave.param("e");
        logIfCannotSave.body().add((Statement)logger.invoke("error").arg("Cannot save access token, an unexpected error occurred").arg((GeneratedExpression)e2));
    }

    private void generateResetMethod(OAuthModule module, GeneratedClass oauthAdapter) {
        GeneratedMethod reset = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "reset");
        reset.body().invoke(module.getAccessTokenField().getSetter().getName()).arg(ExpressionFactory._null());
        reset.body().invoke(module.getAccessTokenSecretField().getSetter().getName()).arg(ExpressionFactory._null());
        GeneratedField consumer = (GeneratedField)oauthAdapter.fields().get("consumer");
        reset.body().add((Statement)consumer.invoke("setTokenWithSecret").arg(ExpressionFactory._null()).arg(ExpressionFactory._null()));
    }

    protected void generateGetProcessTemplateMethod(OAuthModule module, GeneratedClass oauthAdapterClass, GeneratedClass capabilitiesAdapterClass) {
        GeneratedClass oauthProcessTemplateClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_PROCESS_TEMPLATE);
        GeneratedMethod getProcessTemplate = oauthAdapterClass.method(1, (Type)this.ref(ProcessTemplate.class), "getProcessTemplate");
        getProcessTemplate.annotate(this.ref(Override.class));
        TypeVariable p = getProcessTemplate.generify("P");
        getProcessTemplate.type((Type)this.ref(ProcessTemplate.class).narrow((TypeReference)p).narrow((TypeReference)capabilitiesAdapterClass));
        GeneratedInvocation newProcessTemplate = ExpressionFactory._new((TypeReference)oauthProcessTemplateClass).arg(ExpressionFactory._this());
        getProcessTemplate.body()._return((GeneratedExpression)newProcessTemplate);
    }
}

