/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth.process;

import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.oauth.OAuthManager;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessInterceptor;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;

@JustOnce
public class ManagedAccessTokenProcessTemplateGenerator
extends AbstractOAuthAdapterGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.OAUTH_ADAPTER, Product.PROCESS_CALLBACK_PROCESS_INTERCEPTOR, Product.MANAGED_ACCESS_TOKEN_PROCESS_INTERCEPTOR, Product.REFRESH_TOKEN_PROCESS_INTERCEPTOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.MANAGED_ACCESS_TOKEN_PROCESS_TEMPLATE);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule && ((OAuthModule)module).getUserIdentifierMethod() != null;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass processTemplateClass = this.getManagedAccessTokenProcessTemplateClass(module);
        GeneratedClass connectionIdentifierAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module);
        GeneratedField processInterceptor = processTemplateClass.field(12, (Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass), "processInterceptor");
        this.generateInterceptorConstructor(connectionIdentifierAdapterClass, processTemplateClass, processInterceptor);
        this.generateExecuteMethod(processTemplateClass, connectionIdentifierAdapterClass, processInterceptor);
        this.generateExecuteMethodForMessage(processTemplateClass, connectionIdentifierAdapterClass, processInterceptor);
    }

    private void generateExecuteMethod(GeneratedClass processTemplateClass, GeneratedClass connectionIdentifierAdapterClass, GeneratedField processInterceptor) {
        GeneratedMethod executeMethod = processTemplateClass.method(1, (Type)this.ref(Object.class), "execute");
        executeMethod.type((Type)processTemplateClass.typeParams()[0]);
        executeMethod._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = executeMethod.param((Type)this.ref(ProcessCallback.class).narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass), "processCallback");
        GeneratedVariable messageProcessor = executeMethod.param((Type)this.ref(MessageProcessor.class), "messageProcessor");
        GeneratedVariable event = executeMethod.param((Type)this.ref(MuleEvent.class), "event");
        executeMethod.body()._return((GeneratedExpression)processInterceptor.invoke("execute").arg((GeneratedExpression)processCallback).arg(ExpressionFactory._null()).arg((GeneratedExpression)messageProcessor).arg((GeneratedExpression)event));
    }

    private void generateExecuteMethodForMessage(GeneratedClass processTemplateClass, GeneratedClass connectionIdentifierAdapterClass, GeneratedField processInterceptor) {
        GeneratedMethod executeMethod = processTemplateClass.method(1, (Type)this.ref(Object.class), "execute");
        executeMethod.type((Type)processTemplateClass.typeParams()[0]);
        executeMethod._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = executeMethod.param((Type)this.ref(ProcessCallback.class).narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass), "processCallback");
        GeneratedVariable filter = executeMethod.param((Type)this.ref(Filter.class), "filter");
        GeneratedVariable message = executeMethod.param((Type)this.ref(MuleMessage.class), "message");
        executeMethod.body()._return((GeneratedExpression)processInterceptor.invoke("execute").arg((GeneratedExpression)processCallback).arg(ExpressionFactory._null()).arg((GeneratedExpression)filter).arg((GeneratedExpression)message));
    }

    private GeneratedClass getManagedAccessTokenProcessTemplateClass(Module module) {
        GeneratedClass capabilitiesAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module);
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass processTemplateClass = pkg._class(1, "ManagedAccessTokenProcessTemplate");
        TypeVariable payload = processTemplateClass.generify("P");
        processTemplateClass._implements(this.ref(ProcessTemplate.class).narrow((TypeReference)payload).narrow((TypeReference)capabilitiesAdapterClass));
        this.ctx().registerProduct(Product.MANAGED_ACCESS_TOKEN_PROCESS_TEMPLATE, (Object)processTemplateClass);
        return processTemplateClass;
    }

    private void generateInterceptorConstructor(GeneratedClass connectionIdentifierAdapterClass, GeneratedClass processTemplateClass, GeneratedField processInterceptor) {
        GeneratedClass processCallbackProcessInterceptorClass = (GeneratedClass)this.ctx().getProduct(Product.PROCESS_CALLBACK_PROCESS_INTERCEPTOR);
        GeneratedClass refreshTokenProcessInterceptorClass = (GeneratedClass)this.ctx().getProduct(Product.REFRESH_TOKEN_PROCESS_INTERCEPTOR);
        GeneratedClass managedAccessTokenProcessInterceptorClass = (GeneratedClass)this.ctx().getProduct(Product.MANAGED_ACCESS_TOKEN_PROCESS_INTERCEPTOR);
        GeneratedMethod constructor = processTemplateClass.constructor(1);
        GeneratedVariable oauthManager = constructor.param((Type)this.ref(OAuthManager.class).narrow((TypeReference)connectionIdentifierAdapterClass), "oauthManager");
        GeneratedVariable muleContext = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable processCallbackProcessInterceptor = constructor.body().decl((Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass), "processCallbackProcessInterceptor", (GeneratedExpression)ExpressionFactory._new((TypeReference)processCallbackProcessInterceptorClass.narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass)));
        GeneratedVariable refreshTokenProcessInterceptor = constructor.body().decl((Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass), "refreshTokenProcessInterceptor", (GeneratedExpression)ExpressionFactory._new((TypeReference)refreshTokenProcessInterceptorClass.narrow((TypeReference)processTemplateClass.typeParams()[0])).arg((GeneratedExpression)processCallbackProcessInterceptor));
        GeneratedVariable managedAccessTokenProcessInterceptor = constructor.body().decl((Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass), "managedAccessTokenProcessInterceptor", (GeneratedExpression)ExpressionFactory._new((TypeReference)managedAccessTokenProcessInterceptorClass.narrow((TypeReference)processTemplateClass.typeParams()[0])).arg((GeneratedExpression)refreshTokenProcessInterceptor).arg((GeneratedExpression)oauthManager).arg((GeneratedExpression)muleContext));
        constructor.body().assign((AssignmentTarget)processInterceptor, (GeneratedExpression)managedAccessTokenProcessInterceptor);
    }
}

