/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

@JustOnce
public class UnableToAcquireAccessTokenExceptionGenerator
implements ModuleGenerator {
    protected Context context;

    public List<Product> consumes() {
        return new ArrayList<Product>();
    }

    public List<Product> produces() {
        return Arrays.asList(Product.UNABLE_TO_ACQUIRE_ACCESS_TOKEN_EXCEPTION);
    }

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass clazz = pkg._class("UnableToAcquireAccessTokenException");
        this.ctx().registerProduct(Product.UNABLE_TO_ACQUIRE_ACCESS_TOKEN_EXCEPTION, (Object)clazz);
        clazz.javadoc().append((Object)"Exception thrown when the access token needed for accessing a protected resource cannot be acquired");
        clazz._extends(this.ref(Exception.class));
        GeneratedMethod unableToAcquireAccessTokenExceptionGeneratorzedException = clazz.constructor(1);
        unableToAcquireAccessTokenExceptionGeneratorzedException.param((Type)this.ref(Throwable.class), "throwable");
        unableToAcquireAccessTokenExceptionGeneratorzedException.body().directStatement("super(throwable);");
        GeneratedClass requestException = pkg._class("UnableToAcquireRequestTokenException");
        this.ctx().registerProduct(Product.UNABLE_TO_ACQUIRE_REQUEST_TOKEN_EXCEPTION, (Object)requestException);
        requestException.javadoc().append((Object)"Exception thrown when the request token needed for building the authorization URL cannot be acquired");
        requestException._extends(this.ref(Exception.class));
        GeneratedMethod unableToAcquireRequestTokenExceptionGeneratorzedException = requestException.constructor(1);
        unableToAcquireRequestTokenExceptionGeneratorzedException.param((Type)this.ref(Throwable.class), "throwable");
        unableToAcquireRequestTokenExceptionGeneratorzedException.body().directStatement("super(throwable);");
    }

    protected TypeReference ref(Class<?> clazz) {
        return this.ctx().getCodeModel().ref(clazz);
    }

    protected Type ref(TypeMirror typeMirror) {
        return this.ctx().getCodeModel().ref(typeMirror);
    }

    protected Type ref(Module module) {
        return this.ctx().getCodeModel().ref(module.asTypeMirror());
    }

    public Context ctx() {
        return this.context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }
}

