/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth.process;

import java.util.Arrays;
import java.util.List;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;

@JustOnce
public class DefaultSaveAccessTokenCallbackGenerator
extends AbstractOAuthAdapterGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.OAUTH_INTERFACES);
    private static final List<Product> PRODUCES = Arrays.asList(Product.DEFAULT_SAVE_ACCESS_TOKEN_CALLBACK);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule && ((OAuthModule)module).getUserIdentifierMethod() == null;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass callbackClass = this.getDefaultSaveAccessTokenCallbackClass(module);
        GeneratedField messageProcessor = this.generateFieldForMessageProcessor(callbackClass, "messageProcessor");
        GeneratedField logger = this.generateLoggerField(callbackClass);
        GeneratedField hasBeenStarted = this.generateFieldForBoolean(callbackClass, "hasBeenStarted");
        GeneratedField hasBeenInitialized = this.generateFieldForBoolean(callbackClass, "hasBeenInitialized");
        GeneratedMethod constructor = callbackClass.constructor(1);
        constructor.body().assign((AssignmentTarget)hasBeenStarted, ExpressionFactory.FALSE);
        constructor.body().assign((AssignmentTarget)hasBeenInitialized, ExpressionFactory.FALSE);
        callbackClass.getter(messageProcessor);
        callbackClass.setter(messageProcessor);
        GeneratedMethod saveAccessTokenMethod = callbackClass.method(1, (Type)this.ctx().getCodeModel().VOID, "saveAccessToken");
        GeneratedVariable accessToken = saveAccessTokenMethod.param((Type)this.ref(String.class), "accessToken");
        GeneratedVariable accessTokenSecret = saveAccessTokenMethod.param((Type)this.ref(String.class), "accessTokenSecret");
        GeneratedVariable event = saveAccessTokenMethod.body().decl((Type)this.ref(MuleEvent.class), "event", (GeneratedExpression)this.ref(RequestContext.class).staticInvoke("getEvent"));
        GeneratedConditional ifAccessTokenNotNull = saveAccessTokenMethod.body()._if(accessToken.isNotNull());
        ifAccessTokenNotNull._then().add((Statement)event.invoke("getMessage").invoke("setInvocationProperty").arg("OAuthAccessToken").arg((GeneratedExpression)accessToken));
        GeneratedConditional ifAccessTokenSecretNotNull = saveAccessTokenMethod.body()._if(accessTokenSecret.isNotNull());
        ifAccessTokenSecretNotNull._then().add((Statement)event.invoke("getMessage").invoke("setInvocationProperty").arg("OAuthAccessTokenSecret").arg((GeneratedExpression)accessTokenSecret));
        GeneratedConditional ifMuleContextAware = saveAccessTokenMethod.body()._if(Op._instanceof((GeneratedExpression)messageProcessor, (Type)this.ref(MuleContextAware.class)));
        ifMuleContextAware._then().add((Statement)ExpressionFactory.cast((Type)this.ref(MuleContextAware.class), (GeneratedExpression)messageProcessor).invoke("setMuleContext").arg((GeneratedExpression)this.ref(RequestContext.class).staticInvoke("getEventContext").invoke("getMuleContext")));
        GeneratedConditional ifFlowConstructAware = saveAccessTokenMethod.body()._if(Op._instanceof((GeneratedExpression)messageProcessor, (Type)this.ref(FlowConstructAware.class)));
        ifFlowConstructAware._then().add((Statement)ExpressionFactory.cast((Type)this.ref(FlowConstructAware.class), (GeneratedExpression)messageProcessor).invoke("setFlowConstruct").arg((GeneratedExpression)this.ref(RequestContext.class).staticInvoke("getEventContext").invoke("getFlowConstruct")));
        GeneratedConditional ifNotInitialized = saveAccessTokenMethod.body()._if(Op.not((GeneratedExpression)hasBeenInitialized));
        GeneratedConditional ifInitialisable = ifNotInitialized._then()._if(Op._instanceof((GeneratedExpression)messageProcessor, (Type)this.ref(Initialisable.class)));
        GeneratedTry tryToInitialize = ifInitialisable._then()._try();
        tryToInitialize.body().add((Statement)ExpressionFactory.cast((Type)this.ref(Initialisable.class), (GeneratedExpression)messageProcessor).invoke("initialise"));
        GeneratedCatchBlock catchInitlize = tryToInitialize._catch(this.ref(Exception.class));
        GeneratedVariable exception = catchInitlize.param("e");
        catchInitlize.body().add((Statement)logger.invoke("error").arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)exception));
        ifNotInitialized._then().assign((AssignmentTarget)hasBeenInitialized, ExpressionFactory.TRUE);
        GeneratedConditional ifNotStarted = saveAccessTokenMethod.body()._if(Op.not((GeneratedExpression)hasBeenStarted));
        GeneratedConditional ifStartable = ifNotStarted._then()._if(Op._instanceof((GeneratedExpression)messageProcessor, (Type)this.ref(Startable.class)));
        GeneratedTry tryToStart = ifStartable._then()._try();
        tryToStart.body().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)messageProcessor).invoke("start"));
        GeneratedCatchBlock catchStart = tryToStart._catch(this.ref(Exception.class));
        exception = catchStart.param("e");
        catchStart.body().add((Statement)logger.invoke("error").arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)exception));
        ifNotStarted._then().assign((AssignmentTarget)hasBeenStarted, ExpressionFactory.TRUE);
        GeneratedTry tryProcess = saveAccessTokenMethod.body()._try();
        tryProcess.body().add((Statement)messageProcessor.invoke("process").arg((GeneratedExpression)event));
        GeneratedCatchBlock catchProcess = tryProcess._catch(this.ref(Exception.class));
        exception = catchProcess.param("e");
        catchProcess.body().add((Statement)logger.invoke("error").arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)exception));
    }

    private GeneratedClass getDefaultSaveAccessTokenCallbackClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass clazz = pkg._class("DefaultSaveAccessTokenCallback");
        clazz._implements((TypeReference)this.ctx().getProduct(Product.SAVE_ACCESS_TOKEN_CALLBACK_INTERFACE));
        this.ctx().registerProduct(Product.DEFAULT_SAVE_ACCESS_TOKEN_CALLBACK, (Object)clazz);
        return clazz;
    }
}

