/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth.processors;

import java.util.Arrays;
import java.util.List;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;

public class UnauthorizeMessageProcessorGenerator
extends AbstractOAuthAdapterGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.OAUTH_ADAPTER, Product.ABSTRACT_MESSAGE_PROCESSOR, Product.ABSTRACT_CONNECTED_PROCESSOR, Product.OAUTH_MANAGER, Product.CONNECTION_INTERFACES);
    private static final List<Product> PRODUCES = Arrays.asList(Product.MESSAGE_PROCESSOR);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass messageProcessorClass = this.getUnauthorizeMessageProcessorClass(module);
        GeneratedField logger = this.generateLoggerField(messageProcessorClass);
        this.generateProcessMethod((OAuthModule)module, messageProcessorClass, logger);
    }

    private void generateProcessMethod(OAuthModule oauthModule, GeneratedClass messageProcessorClass, GeneratedField logger) {
        TypeReference muleEvent = this.ref(MuleEvent.class);
        GeneratedMethod process = messageProcessorClass.method(1, (org.mule.devkit.model.code.Type)muleEvent, "process");
        process.javadoc().add((Object)"Unauthorize the connector");
        process.javadoc().addParam("event MuleEvent to be processed");
        process.javadoc().addThrows(this.ref(MuleException.class));
        process._throws(MuleException.class);
        GeneratedVariable event = process.param((org.mule.devkit.model.code.Type)muleEvent, "event");
        GeneratedVariable moduleObject = process.body().decl((org.mule.devkit.model.code.Type)this.getModuleObject((Type)oauthModule), "moduleObject", ExpressionFactory._null());
        GeneratedTry attempt = process.body()._try();
        GeneratedInvocation findOrCreate = ExpressionFactory.invoke((String)"findOrCreate").arg(this.getModuleObject((Type)oauthModule).dotclass());
        if (oauthModule.needsConfig()) {
            findOrCreate.arg(ExpressionFactory.FALSE);
        } else {
            findOrCreate.arg(ExpressionFactory.TRUE);
        }
        findOrCreate.arg(ExpressionFactory._null());
        attempt.body().assign((AssignmentTarget)moduleObject, (GeneratedExpression)findOrCreate);
        GeneratedCatchBlock catchIllegalAccess = attempt._catch(this.ref(IllegalAccessException.class));
        catchIllegalAccess.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMuleException.class)).arg((GeneratedExpression)this.ref(CoreMessages.class).staticInvoke("failedToStart").arg("authorize")).arg((GeneratedExpression)catchIllegalAccess.param("e")));
        GeneratedCatchBlock catchInstantiationException = attempt._catch(this.ref(InstantiationException.class));
        catchInstantiationException.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMuleException.class)).arg((GeneratedExpression)this.ref(CoreMessages.class).staticInvoke("failedToStart").arg("authorize")).arg((GeneratedExpression)catchInstantiationException.param("e")));
        if (oauthModule.getUserIdentifierMethod() == null) {
            process.body().add((Statement)moduleObject.invoke("reset"));
            process.body()._return((GeneratedExpression)event);
        } else {
            GeneratedClass oauthAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)oauthModule);
            GeneratedVariable connector = process.body().decl((org.mule.devkit.model.code.Type)oauthAdapterClass, "connector", ExpressionFactory._null());
            attempt = process.body()._try();
            GeneratedClass abstractConnectedProcessor = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_CONNECTED_PROCESSOR);
            GeneratedInvocation getGenericType = abstractConnectedProcessor.dotclass().invoke("getDeclaredField").arg(ExpressionFactory.lit((String)"_accessTokenIdType")).invoke("getGenericType");
            GeneratedInvocation evaluateAndTransform = ExpressionFactory.invoke((String)"evaluateAndTransform").arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext")).arg((GeneratedExpression)event).arg((GeneratedExpression)getGenericType).arg(ExpressionFactory._null()).arg((GeneratedExpression)ExpressionFactory.invoke((String)"getAccessTokenId"));
            GeneratedVariable tokenId = attempt.body().decl((org.mule.devkit.model.code.Type)this.ref(String.class), "_transformedToken", (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(String.class), (GeneratedExpression)evaluateAndTransform));
            attempt.body()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().add((Statement)logger.invoke("debug").arg(Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"Attempting to acquire access token using from store for user "), (GeneratedExpression)tokenId.invoke("toString"))));
            attempt.body().assign((AssignmentTarget)connector, (GeneratedExpression)moduleObject.invoke("acquireAccessToken").arg((GeneratedExpression)tokenId));
            GeneratedConditional isConnectionNull = attempt.body()._if(connector.isNull());
            isConnectionNull._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)((TypeReference)this.ctx().getProduct(Product.UNABLE_TO_ACQUIRE_CONNECTION_EXCEPTION))));
            isConnectionNull._else()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().add((Statement)logger.invoke("debug").arg(Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"Access Token has been acquired for [tokenId="), (GeneratedExpression)connector.invoke(oauthModule.getUserIdentifierMethod().getName())), (GeneratedExpression)ExpressionFactory.lit((String)"]"))));
            isConnectionNull._else().invoke((GeneratedExpression)moduleObject, "destroyAccessToken").arg((GeneratedExpression)tokenId).arg((GeneratedExpression)connector);
            isConnectionNull._else()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().add((Statement)logger.invoke("debug").arg(Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"Access token for [tokenId="), (GeneratedExpression)connector.invoke(oauthModule.getUserIdentifierMethod().getName())), (GeneratedExpression)ExpressionFactory.lit((String)"] has been successfully destroyed"))));
            GeneratedCatchBlock catchException = attempt._catch(this.ref(Exception.class));
            GeneratedVariable e = catchException.param("e");
            catchException.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMuleException.class)).arg((GeneratedExpression)this.ref(CoreMessages.class).staticInvoke("createStaticMessage").arg("Unable to unauthorize the connector")).arg((GeneratedExpression)e));
            process.body()._return((GeneratedExpression)event);
        }
    }

    private GeneratedClass getUnauthorizeMessageProcessorClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".processors");
        GeneratedClass abstractMessageProcessor = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_MESSAGE_PROCESSOR);
        GeneratedClass moduleObject = null;
        moduleObject = module instanceof OAuthModule && ((OAuthModule)module).getUserIdentifierMethod() != null ? ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)module)).topLevelClass() : ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass clazz = pkg._class("UnauthorizeMessageProcessor", abstractMessageProcessor.narrow((TypeReference)moduleObject), new Class[]{MessageProcessor.class, MuleContextAware.class, FlowConstructAware.class});
        this.ctx().registerProduct(Product.MESSAGE_PROCESSOR, (Identifiable)module, "unauthorize", (Object)clazz);
        return clazz;
    }

    protected GeneratedClass getModuleObject(Type type) {
        if (type instanceof OAuthModule && ((OAuthModule)type).getUserIdentifierMethod() != null) {
            return (GeneratedClass)this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)type);
        }
        if (this.ctx().getProduct(Product.PROCESS_ADAPTER, (Identifiable)type) != null) {
            return ((GeneratedClass)this.ctx().getProduct(Product.PROCESS_ADAPTER, (Identifiable)type)).topLevelClass();
        }
        return null;
    }
}

