/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth.processors;

import java.util.Arrays;
import java.util.List;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.MessageFactory;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchAccessTokenMessageProcessorGenerator
extends AbstractOAuthAdapterGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.OAUTH_ADAPTER, Product.OAUTH_MANAGER, Product.INJECTION_ADAPTER, Product.HTTP_CALLBACK_ADAPTER, Product.METADATA_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.OAUTH_FETCH_ACCESS_TOKEN_MESSAGE_PROCESSOR);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule;
    }

    public void generate(Module module) throws GenerationException {
        OAuthModule oauthModule = (OAuthModule)module;
        GeneratedClass messageProcessor = this.getFetchAccessTokenMessageProcessorClass(module);
        GeneratedField oauthAdapterField = null;
        GeneratedField oauthManagerField = null;
        GeneratedField redirectUri = messageProcessor.field(1, (Type)this.ref(String.class), "redirectUri");
        messageProcessor.setter(redirectUri);
        GeneratedField accessTokenUrl = this.generateAccessTokenUrlField(messageProcessor);
        GeneratedField authorizeUrl = null;
        GeneratedField requestTokenUrl = null;
        if (oauthModule.getOAuthVersion() == OAuthVersion.V10A) {
            authorizeUrl = this.generateAuthorizationUrlField(messageProcessor);
            requestTokenUrl = this.generateRequestTokenUrlField(messageProcessor);
        }
        if (oauthModule.getUserIdentifierMethod() == null) {
            GeneratedClass oauthAdapterCall = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
            oauthAdapterField = messageProcessor.field(4, (Type)oauthAdapterCall, "oauthAdapter");
            GeneratedMethod constructor = messageProcessor.constructor(1);
            GeneratedVariable oauthAdapter = constructor.param((Type)oauthAdapterCall, "oauthAdapter");
            constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)oauthAdapterField), (GeneratedExpression)oauthAdapter);
        } else {
            oauthManagerField = messageProcessor.field(4, (Type)((TypeReference)this.ctx().getProduct(Product.OAUTH_MANAGER_INTERFACE)), "oauthManager");
            GeneratedMethod constructor = messageProcessor.constructor(1);
            GeneratedVariable oauthManager = constructor.param((Type)((TypeReference)this.ctx().getProduct(Product.OAUTH_MANAGER_INTERFACE)), "oauthManager");
            constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)oauthManagerField), (GeneratedExpression)oauthManager);
        }
        GeneratedMethod processMethod = messageProcessor.method(1, (Type)this.ref(MuleEvent.class), "process")._throws(this.ref(MuleException.class));
        GeneratedVariable event = processMethod.param((Type)this.ref(MuleEvent.class), "event");
        GeneratedTry tryToExtractVerifier = processMethod.body()._try();
        if (oauthModule.getUserIdentifierMethod() == null) {
            tryToExtractVerifier.body().add((Statement)oauthAdapterField.invoke("setOauthVerifier").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)event.invoke("getMessage").invoke("getInvocationProperty").arg("_oauthVerifier"))));
            if (oauthModule.getOAuthVersion() == OAuthVersion.V10A) {
                tryToExtractVerifier.body().add((Statement)oauthAdapterField.invoke("fetchAccessToken").arg((GeneratedExpression)requestTokenUrl).arg((GeneratedExpression)accessTokenUrl).arg((GeneratedExpression)authorizeUrl).arg((GeneratedExpression)redirectUri));
            } else {
                tryToExtractVerifier.body().add((Statement)oauthAdapterField.invoke("fetchAccessToken").arg((GeneratedExpression)accessTokenUrl).arg((GeneratedExpression)redirectUri));
            }
        } else {
            GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
            GeneratedClass oauthManagerClass = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)module)).topLevelClass();
            GeneratedVariable oauthAdapter = tryToExtractVerifier.body().decl((Type)connectorClass, "oauthAdapter", (GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)oauthManagerField.invoke("createAccessToken").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)event.invoke("getMessage").invoke("getInvocationProperty").arg("_oauthVerifier")))));
            tryToExtractVerifier.body()._if(oauthAdapter.invoke("getAccessTokenUrl").eq(ExpressionFactory._null()))._then().block().add((Statement)oauthAdapter.invoke("setAccessTokenUrl").arg((GeneratedExpression)accessTokenUrl));
            if (oauthModule.getOAuthVersion() == OAuthVersion.V10A) {
                tryToExtractVerifier.body().add((Statement)oauthAdapter.invoke("fetchAccessToken").arg((GeneratedExpression)requestTokenUrl).arg((GeneratedExpression)oauthAdapter.invoke("getAccessTokenUrl")).arg((GeneratedExpression)authorizeUrl).arg((GeneratedExpression)redirectUri));
            } else {
                tryToExtractVerifier.body().add((Statement)oauthAdapter.invoke("fetchAccessToken").arg((GeneratedExpression)oauthAdapter.invoke("getAccessTokenUrl")).arg((GeneratedExpression)redirectUri));
            }
            tryToExtractVerifier.body().add((Statement)ExpressionFactory.cast((Type)oauthManagerClass, (GeneratedExpression)oauthManagerField).invoke("getAccessTokenPoolFactory").invoke("passivateObject").arg((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)oauthAdapter).invoke(oauthModule.getUserIdentifierMethod().getName())).arg((GeneratedExpression)oauthAdapter));
            tryToExtractVerifier.body().add((Statement)event.invoke("getMessage").invoke("setInvocationProperty").arg("OAuthAccessTokenId").arg((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)oauthAdapter).invoke(oauthModule.getUserIdentifierMethod().getName())));
        }
        GeneratedCatchBlock catchBlock = tryToExtractVerifier._catch(this.ref(Exception.class));
        GeneratedVariable exceptionCaught = catchBlock.param("e");
        catchBlock.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(MessagingException.class)).arg((GeneratedExpression)this.ref(MessageFactory.class).staticInvoke("createStaticMessage").arg("Unable to fetch access token")).arg((GeneratedExpression)event).arg((GeneratedExpression)exceptionCaught));
        processMethod.body()._return((GeneratedExpression)event);
    }

    private GeneratedClass getFetchAccessTokenMessageProcessorClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass clazz = pkg._class("FetchAccessTokenMessageProcessor", new Class[]{MessageProcessor.class});
        this.ctx().registerProduct(Product.OAUTH_FETCH_ACCESS_TOKEN_MESSAGE_PROCESSOR, (Object)clazz);
        return clazz;
    }
}

