package org.mule.devkit.generation.oauth;


import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.*;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;

import javax.lang.model.type.TypeMirror;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

///**
// * Exception thrown when a message processor requires for the connector to be authorized
// * using OAuth and its not.
// */
//public class NotAuthorizedException extends Exception {
//    /**
//     * Create a new connection exception
//     *
//     * @param message Message describing what went wrong
//     */
//    public NotAuthorizedException(String message) {
//        super(message);
//    }
//
//    /**
//     * Create a new connection exception
//     *
//     * @param throwable Inner exception
//     * @param message   Message describing what went wrong
//     */
//    public NotAuthorizedException(String message, Throwable throwable) {
//        super(message, throwable);
//    }
//}
@JustOnce
public class UnableToAcquireAccessTokenExceptionGenerator implements ModuleGenerator {

    @Override
    public List<Product> consumes() {
        return new ArrayList<Product>();
    }

    @Override
    public List<Product> produces() {
        return Arrays.asList(Product.UNABLE_TO_ACQUIRE_ACCESS_TOKEN_EXCEPTION);
    }

    @Override
    public boolean shouldGenerate(Module module) {
        return true;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        GeneratedPackage pkg = ctx().getCodeModel()._package(module.getPackage().getName() + OAuthClientNamingConstants.OAUTH_NAMESPACE);
        GeneratedClass clazz = pkg._class(OAuthClientNamingConstants.UNABLE_TO_ACQUIRE_ACCESS_TOKEN);

        ctx().registerProduct(Product.UNABLE_TO_ACQUIRE_ACCESS_TOKEN_EXCEPTION, clazz);
        clazz.javadoc().append("Exception thrown when the access token needed for accessing a protected resource cannot be acquired");
        clazz._extends(ref(Exception.class));
        GeneratedMethod unableToAcquireAccessTokenExceptionGeneratorzedException = clazz.constructor(Modifier.PUBLIC);
        unableToAcquireAccessTokenExceptionGeneratorzedException.param(ref(Throwable.class), "throwable");
        unableToAcquireAccessTokenExceptionGeneratorzedException.body().directStatement("super(throwable);");


        GeneratedClass requestException = pkg._class(OAuthClientNamingConstants.UNABLE_TO_ACQUIRE_REQUEST_TOKEN);
        ctx().registerProduct(Product.UNABLE_TO_ACQUIRE_REQUEST_TOKEN_EXCEPTION,requestException);
        requestException.javadoc().append("Exception thrown when the request token needed for building the authorization URL cannot be acquired");
        requestException._extends(ref(Exception.class));
        GeneratedMethod unableToAcquireRequestTokenExceptionGeneratorzedException = requestException.constructor(Modifier.PUBLIC);
        unableToAcquireRequestTokenExceptionGeneratorzedException.param(ref(Throwable.class), "throwable");
        unableToAcquireRequestTokenExceptionGeneratorzedException.body().directStatement("super(throwable);");


    }

    protected TypeReference ref(Class<?> clazz) {
        return ctx().getCodeModel().ref(clazz);
    }

    protected Type ref(TypeMirror typeMirror) {
        return ctx().getCodeModel().ref(typeMirror);
    }

    protected Type ref(Module module) {
        return ctx().getCodeModel().ref(module.asTypeMirror());
    }

    protected Context context;

    public Context ctx() {
        return context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }
}
