/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.oauth.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.generation.oauth.OAuthClientNamingConstants;
import org.mule.devkit.model.code.*;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;

import java.util.Arrays;
import java.util.List;

@JustOnce
public class ManagedAccessTokenProcessTemplateGenerator extends AbstractOAuthAdapterGenerator {
    private final static List<Product> CONSUMES = Arrays.asList(new Product[]{Product.OAUTH_ADAPTER, Product.PROCESS_CALLBACK_PROCESS_INTERCEPTOR, Product.MANAGED_ACCESS_TOKEN_PROCESS_INTERCEPTOR, Product.REFRESH_TOKEN_PROCESS_INTERCEPTOR
            ,Product.PROCESS_INTERFACES});
    private final static List<Product> PRODUCES = Arrays.asList(new Product[]{Product.MANAGED_ACCESS_TOKEN_PROCESS_TEMPLATE});

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule && ((OAuthModule) module).getUserIdentifierMethod() != null;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        GeneratedClass processTemplateClass = getManagedAccessTokenProcessTemplateClass(module);

        GeneratedClass connectionIdentifierAdapterClass = ctx().getProduct(Product.OAUTH_ADAPTER, module);
        GeneratedField processInterceptor = processTemplateClass.field(Modifier.FINAL | Modifier.PRIVATE, ((TypeReference) ctx().getProduct(Product.PROCESS_INTERCEPTOR_INTERFACE)).narrow(processTemplateClass.typeParams()[0]).narrow(connectionIdentifierAdapterClass), "processInterceptor");

        generateInterceptorConstructor(connectionIdentifierAdapterClass, processTemplateClass, processInterceptor);

        generateExecuteMethod(processTemplateClass, connectionIdentifierAdapterClass, processInterceptor);
        generateExecuteMethodForMessage(processTemplateClass, connectionIdentifierAdapterClass, processInterceptor);
    }

    private void generateExecuteMethod(GeneratedClass processTemplateClass, GeneratedClass connectionIdentifierAdapterClass, GeneratedField processInterceptor) {
        GeneratedMethod executeMethod = processTemplateClass.method(Modifier.PUBLIC, ref(Object.class), "execute");
        executeMethod.type(processTemplateClass.typeParams()[0]);
        executeMethod._throws(ref(Exception.class));
        GeneratedVariable processCallback = executeMethod.param(((TypeReference) ctx().getProduct(Product.PROCESS_CALLBACK_INTERFACE)).narrow(processTemplateClass.typeParams()[0]).narrow(connectionIdentifierAdapterClass), "processCallback");
        GeneratedVariable messageProcessor = executeMethod.param(ref(MessageProcessor.class), "messageProcessor");
        GeneratedVariable event = executeMethod.param(ref(MuleEvent.class), "event");

        executeMethod.body()._return(processInterceptor.invoke("execute").arg(processCallback).arg(ExpressionFactory._null()).arg(messageProcessor).arg(event));
    }

    private void generateExecuteMethodForMessage(GeneratedClass processTemplateClass, GeneratedClass connectionIdentifierAdapterClass, GeneratedField processInterceptor) {
        GeneratedMethod executeMethod = processTemplateClass.method(Modifier.PUBLIC, ref(Object.class), "execute");
        executeMethod.type(processTemplateClass.typeParams()[0]);
        executeMethod._throws(ref(Exception.class));
        GeneratedVariable processCallback = executeMethod.param(((TypeReference) ctx().getProduct(Product.PROCESS_CALLBACK_INTERFACE)).narrow(processTemplateClass.typeParams()[0]).narrow(connectionIdentifierAdapterClass), "processCallback");
        GeneratedVariable filter = executeMethod.param(ref(Filter.class), "filter");
        GeneratedVariable message = executeMethod.param(ref(MuleMessage.class), "message");

        executeMethod.body()._return(processInterceptor.invoke("execute").arg(processCallback).arg(ExpressionFactory._null()).arg(filter).arg(message));
    }

    private GeneratedClass getManagedAccessTokenProcessTemplateClass(Module module) {
        GeneratedClass capabilitiesAdapterClass = ctx().getProduct(Product.OAUTH_ADAPTER, module);
        GeneratedPackage pkg = ctx().getCodeModel()._package(module.getPackage().getName() + OAuthClientNamingConstants.OAUTH_NAMESPACE);
        GeneratedClass processTemplateClass = pkg._class(Modifier.PUBLIC, OAuthClientNamingConstants.MANAGED_ACCESS_TOKEN_PROCESS_TEMPLATE_CLASS_NAME);
        TypeVariable payload = processTemplateClass.generify("P");
        processTemplateClass._implements(((TypeReference) ctx().getProduct(Product.PROCESS_TEMPLATE_INTERFACE)).narrow(payload).narrow(capabilitiesAdapterClass));

        ctx().registerProduct(Product.MANAGED_ACCESS_TOKEN_PROCESS_TEMPLATE, processTemplateClass);

        return processTemplateClass;
    }

    private void generateInterceptorConstructor(GeneratedClass connectionIdentifierAdapterClass, GeneratedClass processTemplateClass, GeneratedField processInterceptor) {
        GeneratedClass processCallbackProcessInterceptorClass = ctx().getProduct(Product.PROCESS_CALLBACK_PROCESS_INTERCEPTOR);
        GeneratedClass refreshTokenProcessInterceptorClass = ctx().getProduct(Product.REFRESH_TOKEN_PROCESS_INTERCEPTOR);
        GeneratedClass managedAccessTokenProcessInterceptorClass = ctx().getProduct(Product.MANAGED_ACCESS_TOKEN_PROCESS_INTERCEPTOR);

        GeneratedMethod constructor = processTemplateClass.constructor(Modifier.PUBLIC);
        GeneratedVariable oauthManager = constructor.param(((TypeReference) ctx().getProduct(Product.OAUTH_MANAGER_INTERFACE)).narrow(connectionIdentifierAdapterClass), "oauthManager");
        GeneratedVariable muleContext = constructor.param(ref(MuleContext.class), "muleContext");

        GeneratedVariable processCallbackProcessInterceptor = constructor.body().decl(((TypeReference) ctx().getProduct(Product.PROCESS_INTERCEPTOR_INTERFACE)).narrow(processTemplateClass.typeParams()[0]).narrow(connectionIdentifierAdapterClass), "processCallbackProcessInterceptor",
                ExpressionFactory._new(processCallbackProcessInterceptorClass.narrow(processTemplateClass.typeParams()[0]).narrow(connectionIdentifierAdapterClass)));

        GeneratedVariable refreshTokenProcessInterceptor = constructor.body().decl(((TypeReference) ctx().getProduct(Product.PROCESS_INTERCEPTOR_INTERFACE)).narrow(processTemplateClass.typeParams()[0]).narrow(connectionIdentifierAdapterClass), "refreshTokenProcessInterceptor",
                ExpressionFactory._new(refreshTokenProcessInterceptorClass.narrow(processTemplateClass.typeParams()[0])).arg(processCallbackProcessInterceptor));

        GeneratedVariable managedAccessTokenProcessInterceptor = constructor.body().decl(((TypeReference) ctx().getProduct(Product.PROCESS_INTERCEPTOR_INTERFACE)).narrow(processTemplateClass.typeParams()[0]).narrow(connectionIdentifierAdapterClass), "managedAccessTokenProcessInterceptor",
                ExpressionFactory._new(managedAccessTokenProcessInterceptorClass.narrow(processTemplateClass.typeParams()[0])).arg(refreshTokenProcessInterceptor).arg(oauthManager).arg(muleContext));

        constructor.body().assign(processInterceptor, managedAccessTokenProcessInterceptor);
    }
}
