/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.oauth.process;

import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.generation.oauth.OAuthClientNamingConstants;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Modifier;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthCallbackParameterField;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class OAuthStateGenerator extends AbstractOAuthAdapterGenerator {
    private final static List<Product> PRODUCES = Arrays.asList(Product.OAUTH_ADAPTER);

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule && ((OAuthModule) module).getUserIdentifierMethod() != null;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        GeneratedClass oauthStateClass = getOAuthStateClass(module);

        GeneratedField accessToken = oauthStateClass.field(Modifier.PUBLIC, ref(String.class), "accessToken");
        oauthStateClass.getter(accessToken);
        oauthStateClass.setter(accessToken);

        GeneratedField authorizationUrl = oauthStateClass.field(Modifier.PUBLIC, ref(String.class), "authorizationUrl");
        oauthStateClass.getter(authorizationUrl);
        oauthStateClass.setter(authorizationUrl);

        GeneratedField accessTokenUrl = oauthStateClass.field(Modifier.PUBLIC, ref(String.class), "accessTokenUrl");
        oauthStateClass.getter(accessTokenUrl);
        oauthStateClass.setter(accessTokenUrl);

        if (((OAuthModule) module).getOAuthVersion() == OAuthVersion.V10A) {
            GeneratedField accessTokenSecret = oauthStateClass.field(Modifier.PUBLIC, ref(String.class), "accessTokenSecret");
            oauthStateClass.getter(accessTokenSecret);
            oauthStateClass.setter(accessTokenSecret);

            GeneratedField requestTokenUrl = oauthStateClass.field(Modifier.PUBLIC, ref(String.class), "requestTokenUrl");
            oauthStateClass.getter(requestTokenUrl);
            oauthStateClass.setter(requestTokenUrl);
        }

        if (((OAuthModule) module).getOAuthVersion() == OAuthVersion.V2) {
            GeneratedField refreshToken = oauthStateClass.field(Modifier.PUBLIC, ref(String.class), "refreshToken");
            oauthStateClass.getter(refreshToken);
            oauthStateClass.setter(refreshToken);
        }

        for (OAuthCallbackParameterField field : ((OAuthModule) module).getCallbackParameters()) {
            GeneratedField callbackField = oauthStateClass.field(Modifier.PUBLIC, ref(field.asTypeMirror()), field.getName());
            oauthStateClass.getter(callbackField);
            oauthStateClass.setter(callbackField);
        }
    }

    protected GeneratedClass getOAuthStateClass(Module module) {
        GeneratedPackage pkg = ctx().getCodeModel()._package(module.getPackage().getName() + OAuthClientNamingConstants.OAUTH_NAMESPACE);

        GeneratedClass oauthAdapter = pkg._class(Modifier.PUBLIC, module.getClassName() + OAuthClientNamingConstants.OAUTH_STATE_CLASS_NAME);
        oauthAdapter._implements(Serializable.class);

        ctx().registerProduct(Product.OAUTH_STATE, module, oauthAdapter);

        oauthAdapter.javadoc().add("Serializable class used to save and restore OAuth state from ");
        oauthAdapter.javadoc().add(ref(module.asTypeMirror()));

        return oauthAdapter;
    }
}
