/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.oauth.processors;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.MessageFactory;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.generation.oauth.OAuthClientNamingConstants;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Modifier;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;

import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtractAuthorizationCodeMessageProcessorGenerator extends AbstractOAuthAdapterGenerator {
    private final static List<Product> CONSUMES = Arrays.asList(new Product[]{});
    private final static List<Product> PRODUCES = Arrays.asList(new Product[]{Product.OAUTH_EXTRACT_AUTHORIZATION_CODE_MESSAGE_PROCESSOR});

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        GeneratedClass messageProcessor = getExtractAuthorizationCodeMessageProcessorClass(module);

        GeneratedField pattern = messageProcessor.field(Modifier.PRIVATE, ref(Pattern.class), "pattern");

        generateConstructor(messageProcessor, pattern);

        GeneratedMethod processMethod = messageProcessor.method(Modifier.PUBLIC, ref(MuleEvent.class), "process")._throws(ref(MuleException.class));
        GeneratedVariable event = processMethod.param(ref(MuleEvent.class), "event");

        GeneratedTry tryToExtractVerifier = processMethod.body()._try();
        tryToExtractVerifier.body().add(event.invoke("getMessage").invoke("setInvocationProperty").arg("_oauthVerifier").arg(ExpressionFactory.invoke("extractAuthorizationCode").arg(event.invoke("getMessageAsString"))));

        GeneratedCatchBlock catchBlock = tryToExtractVerifier._catch(ref(Exception.class));
        GeneratedVariable exceptionCaught = catchBlock.param("e");
        catchBlock.body()._throw(ExpressionFactory._new(
                ref(MessagingException.class)).
                arg(ref(MessageFactory.class).staticInvoke("createStaticMessage").arg("Could not extract OAuth verifier")).arg(event).arg(exceptionCaught));

        processMethod.body()._return(event);

        GeneratedMethod extractMethod = messageProcessor.method(Modifier.PRIVATE, ref(String.class), "extractAuthorizationCode")._throws(ref(Exception.class));
        GeneratedVariable response = extractMethod.param(String.class, "response");
        GeneratedVariable matcher = extractMethod.body().decl(ref(Matcher.class), "matcher", pattern.invoke("matcher").arg(response));
        GeneratedConditional ifVerifierFound = extractMethod.body()._if(Op.cand(matcher.invoke("find"), Op.gte(matcher.invoke("groupCount"), ExpressionFactory.lit(1))));
        GeneratedInvocation group = matcher.invoke("group").arg(ExpressionFactory.lit(1));
        ifVerifierFound._then()._return(ref(URLDecoder.class).staticInvoke("decode").arg(group).arg(ENCODING));
        ifVerifierFound._else()._throw(ExpressionFactory._new(
                ref(Exception.class)).arg(ref(String.class).staticInvoke("format").arg("OAuth authorization code could not be extracted from: %s").arg(response)));
    }

    private void generateConstructor(GeneratedClass messageProcessor, GeneratedField patternField) {
        GeneratedMethod constructor = messageProcessor.constructor(Modifier.PUBLIC);
        GeneratedVariable pattern = constructor.param(ref(Pattern.class), "pattern");

        constructor.body().assign(ExpressionFactory._this().ref(patternField), pattern);
    }

    private GeneratedClass getExtractAuthorizationCodeMessageProcessorClass(Module module) {
        GeneratedPackage pkg = ctx().getCodeModel()._package(module.getPackage().getName() + OAuthClientNamingConstants.OAUTH_NAMESPACE);
        GeneratedClass clazz = pkg._class(OAuthClientNamingConstants.EXTRACT_AUTHORIZATION_CODE_MESSAGE_PROCESSOR_CLASS_NAME, new Class[]{
                MessageProcessor.class});

        ctx().registerProduct(Product.OAUTH_EXTRACT_AUTHORIZATION_CODE_MESSAGE_PROCESSOR, clazz);

        return clazz;
    }


}
