/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class NotAuthorizedExceptionGenerator
implements ModuleGenerator {
    protected Context context;

    public List<Product> consumes() {
        return new ArrayList<Product>();
    }

    public List<Product> produces() {
        return Arrays.asList(Product.NOT_AUTHORIZED_EXCEPTION);
    }

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass clazz = pkg._class("NotAuthorizedException");
        this.ctx().registerProduct(Product.NOT_AUTHORIZED_EXCEPTION, (Object)clazz);
        clazz._extends(this.ref(Exception.class));
        GeneratedMethod notAuthorizedException = clazz.constructor(1);
        notAuthorizedException.param((Type)this.ref(String.class), "message");
        notAuthorizedException.body().directStatement("super(message);");
        GeneratedMethod notAuthorizedExceptionExtended = clazz.constructor(1);
        notAuthorizedExceptionExtended.param((Type)this.ref(String.class), "message");
        notAuthorizedExceptionExtended.param((Type)this.ref(Throwable.class), "throwable");
        notAuthorizedExceptionExtended.body().directStatement("super(message,throwable);");
    }

    protected TypeReference ref(Class<?> clazz) {
        return this.ctx().getCodeModel().ref(clazz);
    }

    protected Type ref(TypeMirror typeMirror) {
        return this.ctx().getCodeModel().ref(typeMirror);
    }

    protected Type ref(Module module) {
        return this.ctx().getCodeModel().ref(module.asTypeMirror());
    }

    public Context ctx() {
        return this.context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }
}

