/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth;

import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.oauth.OAuthConsumerKey;
import org.mule.api.annotations.oauth.OAuthConsumerSecret;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.util.IOUtils;

public class OAuth2ClientAdapterGenerator
extends AbstractOAuthAdapterGenerator {
    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule && ((OAuthModule)module).getOAuthVersion() == OAuthVersion.V2;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass oauthAdapter = this.getOAuthAdapterClass(module, "OAuth2Adapter", (TypeReference)this.ctx().getProduct(Product.OAUTH2_ADAPTER_INTERFACE));
        OAuthModule oAuthModule = (OAuthModule)module;
        this.accessTokenPatternConstant(oauthAdapter, oAuthModule);
        this.refreshTokenPatternConstant(oauthAdapter, oAuthModule);
        this.expirationPatternConstant(oauthAdapter, oAuthModule);
        this.muleContextField(oauthAdapter);
        this.authorizationCodeField(oauthAdapter);
        this.refreshTokenField(oauthAdapter);
        GeneratedField saveAccessTokenCallback = this.saveAccessTokenCallbackField(oauthAdapter);
        GeneratedField restoreAccessTokenCallback = this.restoreAccessTokenCallbackField(oauthAdapter);
        GeneratedField redirectUri = oauthAdapter.field(1, (Type)this.ref(String.class), "redirectUri");
        GeneratedField authorizationUrl = this.generateAuthorizationUrlField(oauthAdapter);
        GeneratedField accessTokenUrl = this.generateAccessTokenUrlField(oauthAdapter);
        this.expirationField(oauthAdapter, oAuthModule);
        this.generateInitialiseMethod(oauthAdapter);
        GeneratedField logger = FieldBuilder.newLoggerField((GeneratedClass)oauthAdapter);
        this.generateOAuth2AuthorizeMethod(oauthAdapter, oAuthModule, logger, authorizationUrl);
        this.generateRestoreAccessTokenMethod(oAuthModule, oauthAdapter, restoreAccessTokenCallback, logger);
        this.generateFetchAccessTokenMethod(oauthAdapter, oAuthModule);
        this.generateRefreshAccessTokenMethod(oauthAdapter, oAuthModule, logger);
        this.generateFetchAndExtractMethod(oauthAdapter, oAuthModule, saveAccessTokenCallback, logger);
        this.generateHasTokenExpiredMethod(oAuthModule, oauthAdapter);
        this.generateResetMethod(oAuthModule, oauthAdapter);
        this.generateHasBeenAuthorizedMethod(oAuthModule, oauthAdapter);
        this.generateGetProcessTemplateMethod(oauthAdapter, (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module));
    }

    protected GeneratedField refreshTokenField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name("refreshToken").getterAndSetter().build();
    }

    private void accessTokenPatternConstant(GeneratedClass oauthAdapter, OAuthModule module) {
        new FieldBuilder(oauthAdapter).type(Pattern.class).name("ACCESS_CODE_PATTERN").staticField().finalField().initialValue((GeneratedExpression)this.ref(Pattern.class).staticInvoke("compile").arg(module.getAccessTokenRegex())).build();
    }

    private void refreshTokenPatternConstant(GeneratedClass oauthAdapter, OAuthModule module) {
        new FieldBuilder(oauthAdapter).type(Pattern.class).name("REFRESH_TOKEN_PATTERN").staticField().finalField().initialValue((GeneratedExpression)this.ref(Pattern.class).staticInvoke("compile").arg(module.getRefreshTokenRegex())).build();
    }

    private void expirationPatternConstant(GeneratedClass oauthAdapter, OAuthModule module) {
        if (!StringUtils.isEmpty((String)module.getExpirationRegex())) {
            new FieldBuilder(oauthAdapter).type(Pattern.class).name("EXPIRATION_TIME_PATTERN").staticField().finalField().initialValue((GeneratedExpression)this.ref(Pattern.class).staticInvoke("compile").arg(module.getExpirationRegex())).build();
        }
    }

    private void expirationField(GeneratedClass oauthAdapter, OAuthModule module) {
        if (!StringUtils.isEmpty((String)module.getExpirationRegex())) {
            new FieldBuilder(oauthAdapter).type(Date.class).name("expiration").setter().build();
        }
    }

    private void generateRestoreAccessTokenMethod(OAuthModule module, GeneratedClass oauthAdapter, GeneratedField restoreAccessTokenCallbackField, GeneratedField logger) {
        GeneratedMethod restoreAccessTokenMethod = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "restoreAccessToken");
        GeneratedConditional ifRestoreCallbackNotNull = restoreAccessTokenMethod.body()._if(restoreAccessTokenCallbackField.isNotNull());
        GeneratedConditional ifDebugEnabled = ifRestoreCallbackNotNull._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
        GeneratedVariable messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Attempting to restore access token..."));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        GeneratedTry tryToRestore = ifRestoreCallbackNotNull._then()._try();
        tryToRestore.body().add((Statement)restoreAccessTokenCallbackField.invoke("restoreAccessToken"));
        tryToRestore.body().invoke(module.getAccessTokenField().getSetter().getName()).arg((GeneratedExpression)restoreAccessTokenCallbackField.invoke("getAccessToken"));
        ifDebugEnabled = tryToRestore.body()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Access token and secret has been restored successfully "));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessToken = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)restoreAccessTokenCallbackField.invoke("getAccessToken")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        tryToRestore.body()._return(ExpressionFactory.TRUE);
        GeneratedCatchBlock logIfCannotRestore = tryToRestore._catch(this.ref(Exception.class));
        GeneratedVariable e = logIfCannotRestore.param("e");
        logIfCannotRestore.body().add((Statement)logger.invoke("error").arg("Cannot restore access token, an unexpected error occurred").arg((GeneratedExpression)e));
        restoreAccessTokenMethod.body()._return(ExpressionFactory.FALSE);
    }

    private void generateRefreshAccessTokenMethod(GeneratedClass oauthAdapter, OAuthModule module, GeneratedField logger) {
        GeneratedMethod refreshAccessTokenMethod = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "refreshAccessToken");
        GeneratedVariable accessTokenUrl = refreshAccessTokenMethod.param((Type)this.ref(String.class), "accessTokenUrl");
        refreshAccessTokenMethod._throws((TypeReference)this.ctx().getProduct(Product.UNABLE_TO_ACQUIRE_ACCESS_TOKEN_EXCEPTION));
        GeneratedBlock body = refreshAccessTokenMethod.body();
        GeneratedConditional ifDebugEnabled = body._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
        ifDebugEnabled._then().invoke((GeneratedExpression)logger, "debug").arg("Trying to refresh access token...");
        GeneratedConditional ifRefreshTokenIsNull = body._if(ExpressionFactory._this().ref("refreshToken").isNull());
        ifRefreshTokenIsNull._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(IllegalStateException.class)).arg("Cannot refresh access token since refresh token is null"));
        GeneratedVariable builder = body.decl((Type)this.ref(StringBuilder.class), "builder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        GeneratedInvocation consumerKey = ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith((Module)module, OAuthConsumerKey.class));
        GeneratedInvocation consumerSecret = ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith((Module)module, OAuthConsumerSecret.class));
        body.invoke((GeneratedExpression)builder, "append").arg("grant_type=refresh_token");
        body.invoke((GeneratedExpression)builder, "append").arg("&client_id=");
        body.invoke((GeneratedExpression)builder, "append").arg((GeneratedExpression)consumerKey);
        body.invoke((GeneratedExpression)builder, "append").arg("&client_secret=");
        body.invoke((GeneratedExpression)builder, "append").arg((GeneratedExpression)consumerSecret);
        body.invoke((GeneratedExpression)builder, "append").arg("&refresh_token=");
        body.invoke((GeneratedExpression)builder, "append").arg((GeneratedExpression)oauthAdapter.fields().get("refreshToken"));
        if (module.getScopeField() != null) {
            body.invoke((GeneratedExpression)builder, "append").arg("&scope=");
            GeneratedTry urlEncodeTry = body._try();
            urlEncodeTry.body().invoke((GeneratedExpression)builder, "append").arg((GeneratedExpression)this.ref(URLEncoder.class).staticInvoke("encode").arg((GeneratedExpression)ExpressionFactory.invoke((String)module.getScopeField().getGetter().getName())).arg("UTF-8"));
            this.generateCatchAndReThrow(urlEncodeTry, UnsupportedEncodingException.class, RuntimeException.class);
        }
        body.invoke("setAccessToken").arg(ExpressionFactory._null());
        body.invoke("fetchAndExtract").arg((GeneratedExpression)accessTokenUrl).arg((GeneratedExpression)builder.invoke("toString"));
    }

    private void generateFetchAccessTokenMethod(GeneratedClass oauthAdapter, OAuthModule module) {
        GeneratedMethod fetchAccessToken = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "fetchAccessToken");
        GeneratedVariable accessTokenUrl = fetchAccessToken.param((Type)this.ref(String.class), "accessTokenUrl");
        GeneratedVariable redirectUri = fetchAccessToken.param((Type)this.ref(String.class), "redirectUri");
        fetchAccessToken._throws((TypeReference)this.ctx().getProduct(Product.UNABLE_TO_ACQUIRE_ACCESS_TOKEN_EXCEPTION));
        GeneratedInvocation consumerKey = ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith((Module)module, OAuthConsumerKey.class));
        GeneratedInvocation consumerSecret = ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith((Module)module, OAuthConsumerSecret.class));
        GeneratedVariable builder = fetchAccessToken.body().decl((Type)this.ref(StringBuilder.class), "builder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        GeneratedTry tryBlock = fetchAccessToken.body()._try();
        GeneratedBlock tryBody = tryBlock.body();
        tryBody.invoke((GeneratedExpression)builder, "append").arg("code=");
        tryBody.invoke((GeneratedExpression)builder, "append").arg((GeneratedExpression)this.ref(URLEncoder.class).staticInvoke("encode").arg((GeneratedExpression)oauthAdapter.fields().get("oauthVerifier")).arg("UTF-8"));
        tryBody.invoke((GeneratedExpression)builder, "append").arg("&client_id=");
        tryBody.invoke((GeneratedExpression)builder, "append").arg((GeneratedExpression)this.ref(URLEncoder.class).staticInvoke("encode").arg((GeneratedExpression)consumerKey).arg("UTF-8"));
        tryBody.invoke((GeneratedExpression)builder, "append").arg("&client_secret=");
        tryBody.invoke((GeneratedExpression)builder, "append").arg((GeneratedExpression)this.ref(URLEncoder.class).staticInvoke("encode").arg((GeneratedExpression)consumerSecret).arg("UTF-8"));
        tryBody.invoke((GeneratedExpression)builder, "append").arg("&grant_type=");
        tryBody.invoke((GeneratedExpression)builder, "append").arg((GeneratedExpression)this.ref(URLEncoder.class).staticInvoke("encode").arg("authorization_code").arg("UTF-8"));
        tryBody.invoke((GeneratedExpression)builder, "append").arg("&redirect_uri=");
        tryBody.invoke((GeneratedExpression)builder, "append").arg((GeneratedExpression)this.ref(URLEncoder.class).staticInvoke("encode").arg((GeneratedExpression)redirectUri));
        this.generateCatchAndReThrow(tryBlock, UnsupportedEncodingException.class, RuntimeException.class);
        fetchAccessToken.body().invoke("fetchAndExtract").arg((GeneratedExpression)accessTokenUrl).arg((GeneratedExpression)builder.invoke("toString"));
    }

    private void generateFetchAndExtractMethod(GeneratedClass oauthAdapter, OAuthModule module, GeneratedField saveAccessTokenCallback, GeneratedField logger) {
        GeneratedVariable expirationMatcher;
        GeneratedMethod fetchAccessToken = oauthAdapter.method(4, (Type)this.ctx().getCodeModel().VOID, "fetchAndExtract");
        GeneratedVariable accessTokenUrl = fetchAccessToken.param((Type)this.ref(String.class), "accessTokenUrl");
        GeneratedVariable requestBodyParam = fetchAccessToken.param((Type)this.ref(String.class), "requestBodyParam");
        fetchAccessToken._throws((TypeReference)this.ctx().getProduct(Product.UNABLE_TO_ACQUIRE_ACCESS_TOKEN_EXCEPTION));
        fetchAccessToken.body().invoke("restoreAccessToken");
        GeneratedConditional ifAccessTokenNull = fetchAccessToken.body()._if(ExpressionFactory.invoke((String)module.getAccessTokenField().getGetter().getName()).isNull());
        GeneratedTry tryStatement = ifAccessTokenNull._then()._try();
        GeneratedConditional ifDebugEnabled = tryStatement.body()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
        GeneratedVariable messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Retrieving access token..."));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        GeneratedBlock body = tryStatement.body();
        GeneratedVariable conn = body.decl((Type)this.ref(HttpURLConnection.class), "conn", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(HttpURLConnection.class), (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(URL.class)).arg((GeneratedExpression)accessTokenUrl).invoke("openConnection")));
        body.invoke((GeneratedExpression)conn, "setRequestMethod").arg("POST");
        body.invoke((GeneratedExpression)conn, "setDoOutput").arg(ExpressionFactory.lit((boolean)true));
        ifDebugEnabled = tryStatement.body()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Sending request to ["));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)accessTokenUrl));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("] using the following as content ["));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)requestBodyParam));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("]"));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        GeneratedVariable out = body.decl((Type)this.ref(OutputStreamWriter.class), "out", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(OutputStreamWriter.class)).arg((GeneratedExpression)conn.invoke("getOutputStream")));
        body.invoke((GeneratedExpression)out, "write").arg((GeneratedExpression)requestBodyParam);
        body.invoke((GeneratedExpression)out, "close");
        GeneratedVariable response = body.decl((Type)this.ref(String.class), "response", (GeneratedExpression)this.ref(IOUtils.class).staticInvoke("toString").arg((GeneratedExpression)conn.invoke("getInputStream")));
        ifDebugEnabled = tryStatement.body()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Received response ["));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)response));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("]"));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        GeneratedVariable matcher = body.decl((Type)this.ref(Matcher.class), "matcher", (GeneratedExpression)((GeneratedField)oauthAdapter.fields().get("ACCESS_CODE_PATTERN")).invoke("matcher").arg((GeneratedExpression)response));
        GeneratedConditional ifAccessTokenFound = body._if(Op.cand((GeneratedExpression)matcher.invoke("find"), (GeneratedExpression)Op.gte((GeneratedExpression)matcher.invoke("groupCount"), (GeneratedExpression)ExpressionFactory.lit((int)1))));
        GeneratedInvocation group = matcher.invoke("group").arg(ExpressionFactory.lit((int)1));
        ifAccessTokenFound._then().invoke(module.getAccessTokenField().getSetter().getName()).arg((GeneratedExpression)this.ref(URLDecoder.class).staticInvoke("decode").arg((GeneratedExpression)group).arg("UTF-8"));
        ifDebugEnabled = ifAccessTokenFound._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Access token retrieved successfully "));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessToken = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)ExpressionFactory.invoke((String)module.getAccessTokenField().getGetter().getName())));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        ifAccessTokenFound._else()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Exception.class)).arg((GeneratedExpression)this.ref(String.class).staticInvoke("format").arg("OAuth access token could not be extracted from: %s").arg((GeneratedExpression)response)));
        GeneratedConditional ifSaveCallbackNotNull = ifAccessTokenFound._then()._if(saveAccessTokenCallback.isNotNull());
        GeneratedInvocation saveAccessToken = saveAccessTokenCallback.invoke("saveAccessToken").arg((GeneratedExpression)ExpressionFactory.invoke((String)module.getAccessTokenField().getGetter().getName())).arg(ExpressionFactory._null());
        GeneratedTry tryToSave = ifSaveCallbackNotNull._then()._try();
        ifDebugEnabled = ifSaveCallbackNotNull._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Attempting to save access token..."));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessToken = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)ExpressionFactory.invoke((String)module.getAccessTokenField().getGetter().getName())));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        tryToSave.body().add((Statement)saveAccessToken);
        GeneratedCatchBlock logIfCannotSave = tryToSave._catch(this.ref(Exception.class));
        GeneratedVariable e2 = logIfCannotSave.param("e");
        logIfCannotSave.body().add((Statement)logger.invoke("error").arg("Cannot save access token, an unexpected error occurred").arg((GeneratedExpression)e2));
        if (!StringUtils.isEmpty((String)module.getExpirationRegex())) {
            ifDebugEnabled = ifAccessTokenFound._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
            messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Attempting to extract expiration time using "));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[expirationPattern = ")));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(module.getExpirationRegex()));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
            ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
            expirationMatcher = ifAccessTokenFound._then().decl((Type)this.ref(Matcher.class), "expirationMatcher", (GeneratedExpression)((GeneratedField)oauthAdapter.fields().get("EXPIRATION_TIME_PATTERN")).invoke("matcher").arg((GeneratedExpression)response));
            GeneratedConditional ifExpirationFound = ifAccessTokenFound._then()._if(Op.cand((GeneratedExpression)expirationMatcher.invoke("find"), (GeneratedExpression)Op.gte((GeneratedExpression)expirationMatcher.invoke("groupCount"), (GeneratedExpression)ExpressionFactory.lit((int)1))));
            GeneratedVariable seconds = ifExpirationFound._then().decl((Type)this.ref(Long.class), "expirationSecsAhead", (GeneratedExpression)this.ref(Long.class).staticInvoke("parseLong").arg((GeneratedExpression)expirationMatcher.invoke("group").arg(ExpressionFactory.lit((int)1))));
            ifExpirationFound._then().assign((AssignmentTarget)oauthAdapter.fields().get("expiration"), (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Date.class)).arg(Op.plus((GeneratedExpression)this.ref(System.class).staticInvoke("currentTimeMillis"), (GeneratedExpression)Op.mul((GeneratedExpression)seconds, (GeneratedExpression)ExpressionFactory.lit((int)1000)))));
            ifDebugEnabled = ifExpirationFound._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
            messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Token expiration extracted successfully "));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[expiration = ")));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)oauthAdapter.fields().get("expiration")));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
            ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
            ifDebugEnabled = ifExpirationFound._else()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
            messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Token expiration could not be extracted from "));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[response = ")));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)response));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
            ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        }
        if (!StringUtils.isEmpty((String)module.getRefreshTokenRegex())) {
            ifDebugEnabled = ifAccessTokenFound._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
            messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Attempting to extract refresh token time using "));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[refreshTokenPattern = ")));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(module.getRefreshTokenRegex()));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
            ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
            expirationMatcher = ifAccessTokenFound._then().decl((Type)this.ref(Matcher.class), "refreshTokenMatcher", (GeneratedExpression)((GeneratedField)oauthAdapter.fields().get("REFRESH_TOKEN_PATTERN")).invoke("matcher").arg((GeneratedExpression)response));
            GeneratedConditional ifRefreshTokenFound = ifAccessTokenFound._then()._if(Op.cand((GeneratedExpression)expirationMatcher.invoke("find"), (GeneratedExpression)Op.gte((GeneratedExpression)expirationMatcher.invoke("groupCount"), (GeneratedExpression)ExpressionFactory.lit((int)1))));
            ifRefreshTokenFound._then().assign((AssignmentTarget)oauthAdapter.fields().get("refreshToken"), (GeneratedExpression)expirationMatcher.invoke("group").arg(ExpressionFactory.lit((int)1)));
            ifDebugEnabled = ifRefreshTokenFound._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
            messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Refresh token extracted successfully "));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[refresh token = ")));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)oauthAdapter.fields().get("refreshToken")));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
            ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
            ifDebugEnabled = ifRefreshTokenFound._else()._if((GeneratedExpression)logger.invoke("isDebugEnabled"));
            messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Refresh token could not be extracted from "));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[response = ")));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((GeneratedExpression)response));
            ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
            ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)messageStringBuilder.invoke("toString")));
        }
        if (module.getCallbackParameters() != null && !module.getCallbackParameters().isEmpty()) {
            this.generateFetchCallbackParameters(oauthAdapter, module);
            ifAccessTokenFound._then().invoke("fetchCallbackParameters").arg((GeneratedExpression)response);
        }
        if (module.getPostAuthorizationMethod() != null) {
            ifAccessTokenFound._then().invoke(module.getPostAuthorizationMethod().getName());
        }
        this.generateCatchAndReThrow(tryStatement, Exception.class, RuntimeException.class);
    }

    private void generateHasTokenExpiredMethod(OAuthModule module, GeneratedClass oauthAdapter) {
        GeneratedMethod hasTokenExpired = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "hasTokenExpired");
        if (!StringUtils.isEmpty((String)module.getExpirationRegex())) {
            GeneratedField expirationDate = (GeneratedField)oauthAdapter.fields().get("expiration");
            hasTokenExpired.body()._return(Op.cand((GeneratedExpression)expirationDate.isNotNull(), (GeneratedExpression)expirationDate.invoke("before").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Date.class)))));
        } else {
            hasTokenExpired.body()._return(ExpressionFactory.FALSE);
        }
    }

    private void generateResetMethod(OAuthModule module, GeneratedClass oauthAdapter) {
        GeneratedMethod reset = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "reset");
        if (!StringUtils.isEmpty((String)module.getExpirationRegex())) {
            reset.body().assign((AssignmentTarget)oauthAdapter.fields().get("expiration"), ExpressionFactory._null());
        }
        reset.body().assign((AssignmentTarget)oauthAdapter.fields().get("oauthVerifier"), ExpressionFactory._null());
        reset.body().invoke(module.getAccessTokenField().getSetter().getName()).arg(ExpressionFactory._null());
    }

    protected void generateGetProcessTemplateMethod(GeneratedClass oauthAdapterClass, GeneratedClass capabilitiesAdapterClass) {
        GeneratedClass oauthProcessTemplateClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_PROCESS_TEMPLATE);
        GeneratedMethod getProcessTemplate = oauthAdapterClass.method(1, (Type)((TypeReference)this.ctx().getProduct(Product.PROCESS_TEMPLATE_INTERFACE)), "getProcessTemplate");
        getProcessTemplate.annotate(this.ref(Override.class));
        TypeVariable p = getProcessTemplate.generify("P");
        getProcessTemplate.type((Type)((TypeReference)this.ctx().getProduct(Product.PROCESS_TEMPLATE_INTERFACE)).narrow((TypeReference)p).narrow((TypeReference)capabilitiesAdapterClass));
        GeneratedInvocation newProcessTemplate = ExpressionFactory._new((TypeReference)oauthProcessTemplateClass).arg(ExpressionFactory._this());
        getProcessTemplate.body()._return((GeneratedExpression)newProcessTemplate);
    }
}

