/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth;

import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class OAuthInterfacesGenerator
implements ModuleGenerator {
    protected Context context;

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        try {
            this.generateOAuthAdapterInterface(module);
            this.generateOAuth1AdapterInterface(module);
            this.generateOAuth2AdapterInterface(module);
            this.generateSaveAccessTokenCallBackInterface(module);
            this.generateRestoreAccessTokenCallbackInterface(module);
            this.generateOAuthManagerInterface(module);
        }
        catch (ClassAlreadyExistsException e) {
            this.ctx().warn("Devkit tried to generate an oauth interface but it already exists");
        }
    }

    private void generateOAuthManagerInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass clazz = pkg._interface("OAuthManager");
        this.ctx().registerProduct(Product.OAUTH_MANAGER_INTERFACE, (Object)clazz);
        clazz.generify("C", (TypeReference)this.ctx().getProduct(Product.OAUTH_ADAPTER_INTERFACE));
        clazz.javadoc().append((Object)"Wrapper around {@link org.mule.api.annotations.oauth.OAuth} annotated class that will infuse it with\naccess token management capabilities.\n<p/>It can receive a {@link org.mule.config.PoolingProfile} which is a configuration object used to \ndefine the OAuth access tokens pooling parameters.\n@param <C> Actual connector object that represents a connection\n");
        clazz.direct("/**\n     * Create a new access token using the specified verifier\n     * and insert it into the pool\n     *\n     * @param verifier OAuth verifier\n     * @return A newly created connector\n     * @throws Exception If the access token cannot be retrieved\n     */\n    C createAccessToken(String verifier) throws Exception;\n\n    /**\n     * Borrow an access token from the pool\n     *\n     * @param userId User identification used to borrow the access token\n     * @return An existing authorized connector\n     * @throws Exception If the access token cannot be retrieved\n     */\n    C acquireAccessToken(String userId) throws Exception;\n\n    /**\n     * Return an access token to the pool\n     *\n     * @param userId    User identification used to borrow the access token\n     * @param connector Authorized connector to be returned to the pool\n     * @throws Exception If the access token cannot be returned\n     */\n    void releaseAccessToken(String userId, C connector) throws Exception;\n\n    /**\n     * Destroy an access token\n     *\n     * @param userId    User identification used to borrow the access token\n     * @param connector Authorized connector to the destroyed\n     * @throws Exception If the access token could not be destroyed.\n     */\n    void destroyAccessToken(String userId, C connector) throws Exception;\n\n    /**\n     * Retrieve default unauthorized connector\n     */\n    C getDefaultUnauthorizedConnector();");
    }

    private void generateRestoreAccessTokenCallbackInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass clazz = pkg._interface("RestoreAccessTokenCallback");
        this.ctx().registerProduct(Product.RESTORE_ACCESS_TOKEN_CALLBACK_INTERFACE, (Object)clazz);
        clazz.direct(" /**\n     * Restore access token and secret\n     */\n    void restoreAccessToken();\n\n    /**\n     * Retrieve the just restored access token\n     *\n     * @return A string representing the access token\n     */\n    String getAccessToken();\n\n    /**\n     * Retrieve the access token secret\n     *\n     * @return A string representing the access token secret\n     */\n    String getAccessTokenSecret();");
    }

    private void generateSaveAccessTokenCallBackInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass clazz = pkg._interface("SaveAccessTokenCallback");
        this.ctx().registerProduct(Product.SAVE_ACCESS_TOKEN_CALLBACK_INTERFACE, (Object)clazz);
        clazz.direct("    /**\n     * Save access token and secret\n     *\n     * @param accessToken       Access token to be saved\n     * @param accessTokenSecret Access token secret to be saved\n     */\n    void saveAccessToken(String accessToken, String accessTokenSecret);");
    }

    private void generateOAuth2AdapterInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass clazz = pkg._interface("OAuth2Adapter");
        this.ctx().registerProduct(Product.OAUTH2_ADAPTER_INTERFACE, (Object)clazz);
        clazz._extends((TypeReference)this.ctx().getProduct(Product.OAUTH_ADAPTER_INTERFACE));
        clazz.direct("/**\n     * Build authorization URL and create the inbound endpoint for the callback\n     *\n     * @param extraParameters Extra query string parameters that should be added to the authorization URL\n     * @return The authorization URL\n     */\n    String authorize(java.util.Map<String, String> extraParameters, String accessTokenUrl, String redirectUri) throws UnableToAcquireRequestTokenException;\n\n    /**\n     * Acquire access token and secret\n     *\n     * @throws UnableToAcquireAccessTokenException\n     *\n     */\n    void fetchAccessToken(String accessTokenUrl, String redirectUri) throws UnableToAcquireAccessTokenException;\n\n    void setExpiration(java.util.Date value);\n\n    boolean hasTokenExpired();\n\n    void refreshAccessToken(String accessTokenUrl) throws UnableToAcquireAccessTokenException;\n\n    String getRefreshToken();");
    }

    private void generateOAuthAdapterInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass clazz = pkg._interface("OAuthAdapter");
        this.ctx().registerProduct(Product.OAUTH_ADAPTER_INTERFACE, (Object)clazz);
        clazz.direct("/**\n     * Retrieve OAuth verifier\n     *\n     * @return A String representing the OAuth verifier\n     */\n    String getOauthVerifier();\n\n    /**\n     * Set OAuth verifier\n     *\n     * @param value OAuth verifier to set\n     */\n    void setOauthVerifier(String value);\n\n    /**\n     * Retrieve access token\n     */\n    String getAccessToken();\n\n    /**\n     * Set access token\n     *\n     * @param value\n     */\n    void setAccessToken(String value);\n\n    /**\n     * Set the callback to be called when the access token and secret need to be saved for\n     * later restoration\n     *\n     * @param saveCallback Callback to be called\n     */\n    void setOauthSaveAccessToken(SaveAccessTokenCallback saveCallback);\n\n    /**\n     * Set the callback to be called when the access token and secret need to be restored\n     *\n     * @param restoreCallback Callback to be called\n     */\n    void setOauthRestoreAccessToken(RestoreAccessTokenCallback restoreCallback);\n\n    /**\n     * Get the callback to be called when the access token and secret need to be saved for\n     * later restoration\n     */\n    SaveAccessTokenCallback getOauthSaveAccessToken();\n\n    /**\n     * Get the callback to be called when the access token and secret need to be restored\n     */\n    RestoreAccessTokenCallback getOauthRestoreAccessToken();\n\n    void hasBeenAuthorized() throws NotAuthorizedException;");
    }

    private void generateOAuth1AdapterInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass clazz = pkg._interface("OAuth1Adapter");
        this.ctx().registerProduct(Product.OAUTH1_ADAPTER_INTERFACE, (Object)clazz);
        clazz._extends((TypeReference)this.ctx().getProduct(Product.OAUTH_ADAPTER_INTERFACE));
        clazz.direct("    public String authorize(java.util.Map<String, String> extraParameters, String requestTokenUrl, String accessTokenUrl, String authorizationUrl, String redirectUri)\n        throws UnableToAcquireRequestTokenException\n    ;\n\n    public void fetchAccessToken(String requestTokenUrl, String accessTokenUrl, String authorizationUrl, String redirectUri)\n        throws UnableToAcquireAccessTokenException\n    ;\n\n    public String getAccessTokenSecret();\n\n    public void setAccessTokenSecret(String value);");
    }

    public List<Product> consumes() {
        return Arrays.asList(Product.UNABLE_TO_ACQUIRE_ACCESS_TOKEN_EXCEPTION);
    }

    public List<Product> produces() {
        return Arrays.asList(Product.OAUTH_INTERFACES);
    }

    public Context ctx() {
        return this.context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }

    protected TypeReference ref(Class<?> clazz) {
        return this.ctx().getCodeModel().ref(clazz);
    }

    protected Type ref(TypeMirror typeMirror) {
        return this.ctx().getCodeModel().ref(typeMirror);
    }

    protected Type ref(Module module) {
        return this.ctx().getCodeModel().ref(module.asTypeMirror());
    }
}

