/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth.config;

import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnauthorizeBeanDefinitionParserGenerator
extends AbstractOAuthAdapterGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.MESSAGE_PROCESSOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.BEAN_DEFINITION_PARSER);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass beanDefinitionParser = this.getUnauthorizeBeanDefinitionParserClass(module);
        GeneratedClass messageProcessorClass = (GeneratedClass)this.ctx().getProduct(Product.MESSAGE_PROCESSOR, (Identifiable)module, "unauthorize");
        GeneratedMethod parse = beanDefinitionParser.method(1, (Type)this.ref(BeanDefinition.class), "parse");
        GeneratedVariable element = parse.param((Type)this.ref(Element.class), "element");
        GeneratedVariable parserContext = parse.param((Type)this.ref(ParserContext.class), "parserContent");
        GeneratedVariable builder = parse.body().decl((Type)this.ref(BeanDefinitionBuilder.class), "builder", (GeneratedExpression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((GeneratedExpression)messageProcessorClass.dotclass().invoke("getName")));
        parse.body().invoke("parseConfigRef").arg((GeneratedExpression)element).arg((GeneratedExpression)builder);
        if (((OAuthModule)module).getUserIdentifierMethod() != null) {
            parse.body().invoke("parseProperty").arg((GeneratedExpression)builder).arg((GeneratedExpression)element).arg("accessTokenId");
        }
        GeneratedVariable definition = parse.body().decl((Type)this.ref(BeanDefinition.class), "definition", (GeneratedExpression)builder.invoke("getBeanDefinition"));
        parse.body().invoke("setNoRecurseOnDefinition").arg((GeneratedExpression)definition);
        parse.body().invoke("attachProcessorDefinition").arg((GeneratedExpression)parserContext).arg((GeneratedExpression)definition);
        parse.body()._return((GeneratedExpression)definition);
    }

    private GeneratedClass getUnauthorizeBeanDefinitionParserClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".config");
        GeneratedClass abstractDefinitionParser = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_BEAN_DEFINITION_PARSER);
        GeneratedClass clazz = pkg._class("UnauthorizeDefinitionParser", (TypeReference)abstractDefinitionParser);
        this.ctx().registerProduct(Product.BEAN_DEFINITION_PARSER, (Identifiable)module, "unauthorize", (Object)clazz);
        return clazz;
    }
}

