/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.oauth.processors;

import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.callback.HttpCallback;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.generation.oauth.OAuth1ClientAdapterGenerator;
import org.mule.devkit.generation.oauth.OAuthClientNamingConstants;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Modifier;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.schema.SchemaTypeConversion;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class AuthorizeMessageProcessorGenerator extends AbstractOAuthAdapterGenerator {
    private static final String HTTP_STATUS_PROPERTY = "http.status";
    private static final String REDIRECT_HTTP_STATUS = "302";
    private static final String LOCATION_PROPERTY = "Location";
    private static final String CALLBACK_FIELD_NAME = "oauthCallback";
    private final static List<Product> CONSUMES = Arrays.asList(new Product[]{Product.OAUTH_ADAPTER, Product.OAUTH_MANAGER, Product.ABSTRACT_MESSAGE_PROCESSOR, Product.OAUTH_EXTRACT_AUTHORIZATION_CODE_MESSAGE_PROCESSOR, Product.OAUTH_FETCH_ACCESS_TOKEN_MESSAGE_PROCESSOR});
    private final static List<Product> PRODUCES = Arrays.asList(new Product[]{Product.MESSAGE_PROCESSOR});

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        // get class
        GeneratedClass messageProcessorClass;

        messageProcessorClass = getAuthorizeMessageProcessorClass(module);

        GeneratedField listenerMessageProcessor = messageProcessorClass.field(Modifier.PRIVATE, ref(MessageProcessor.class), "listener");
        messageProcessorClass.setter(listenerMessageProcessor);

        GeneratedField authorizationUrl = generateAuthorizationUrlField(messageProcessorClass);
        GeneratedField accessTokenUrl = generateAccessTokenUrlField(messageProcessorClass);
        GeneratedField requestTokenUrl = null;

        if( ((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A ) {
            requestTokenUrl = generateRequestTokenUrlField(messageProcessorClass);
        }

        GeneratedField oauthCallback = oauthCallbackField(messageProcessorClass);

        GeneratedField authorizeCodePattern = authorizationCodePatternConstant(messageProcessorClass, ((OAuthModule) module).getVerifierRegex());

        GeneratedField state = generateStateField(messageProcessorClass);

        generateExtraParameterFields((OAuthModule) module, messageProcessorClass);

        generateInitMethod(messageProcessorClass);

        generateStartMethod(module, messageProcessorClass, oauthCallback, listenerMessageProcessor, authorizeCodePattern, requestTokenUrl, accessTokenUrl, authorizationUrl);
        generateStopMethod(messageProcessorClass);

        generateProcessMethod((OAuthModule) module, messageProcessorClass, state, oauthCallback, requestTokenUrl, accessTokenUrl, authorizationUrl);
    }

    private void generateProcessMethod(OAuthModule module, GeneratedClass messageProcessorClass, GeneratedField state, GeneratedField oauthCallback, GeneratedField requestTokenUrlField, GeneratedField accessTokenUrlField, GeneratedField authorizationUrlField) {
        // add process method
        org.mule.devkit.model.code.Type muleEvent = ref(MuleEvent.class);

        GeneratedMethod process = messageProcessorClass.method(Modifier.PUBLIC, muleEvent, "process");
        process.javadoc().add("Starts the OAuth authorization process");
        process.javadoc().addParam("event MuleEvent to be processed");
        process.javadoc().addThrows(ref(MuleException.class));

        process._throws(MuleException.class);
        GeneratedVariable event = process.param(muleEvent, "event");

        GeneratedVariable moduleObject = process.body().decl(getModuleObject(module), "moduleObject", ExpressionFactory._null());

        GeneratedTry tryToAuthorize = process.body()._try();

        GeneratedInvocation findOrCreate = ExpressionFactory.invoke("findOrCreate").arg(getModuleObject(module).dotclass());
        if (module.needsConfig()) {
            findOrCreate.arg(ExpressionFactory.FALSE);
        } else {
            findOrCreate.arg(ExpressionFactory.TRUE);
        }
        findOrCreate.arg(ExpressionFactory._null());
        tryToAuthorize.body().assign(moduleObject, findOrCreate);


        GeneratedVariable extraParameters = tryToAuthorize.body().decl(ref(Map.class).narrow(ref(String.class)).narrow(ref(String.class)), "extraParameters", ExpressionFactory._new(ref(HashMap.class).narrow(ref(String.class)).narrow(ref(String.class))));

        GeneratedConditional ifNotNull = tryToAuthorize.body()._if(state.isNotNull());
        GeneratedTry attempt = ifNotNull._then()._try();
        GeneratedVariable transformerState = attempt.body().decl(ref(String.class), "transformerState",
                ExpressionFactory.cast(ref(String.class),
                ExpressionFactory.invoke("evaluateAndTransform").arg(
                        ExpressionFactory.invoke("getMuleContext")).arg(
                        event).arg(
                        messageProcessorClass.dotclass().invoke("getDeclaredField").arg("state").invoke("getGenericType")).arg(
                        ExpressionFactory._null()).arg(state)
        ));
        attempt.body().add(extraParameters.invoke("put").arg("state").arg(transformerState));

        GeneratedCatchBlock noSuchFieldExceptionCatch = attempt._catch(ref(NoSuchFieldException.class));

        noSuchFieldExceptionCatch.body()._throw(
                ExpressionFactory._new(ref(MessagingException.class))
                        .arg(ref(CoreMessages.class).staticInvoke("createStaticMessage").arg("internal error"))
                        .arg(event)
                        .arg(noSuchFieldExceptionCatch.param("e")));

        if (module.getAuthorizationParameters() != null) {
            for (OAuthAuthorizationParameter parameter : module.getAuthorizationParameters()) {
                if (SchemaTypeConversion.isSupported(parameter.getType().asTypeMirror().toString()) || parameter.getType().isEnum()) {

                    ifNotNull = tryToAuthorize.body()._if(ExpressionFactory.ref(parameter.getName()).isNotNull());
                    attempt = ifNotNull._then()._try();
                    GeneratedVariable first = attempt.body().decl(ref(Object.class), "first",
                            ExpressionFactory.invoke("evaluateAndTransform").arg(
                                    ExpressionFactory.invoke("getMuleContext")).arg(
                                    event).arg(
                                    messageProcessorClass.dotclass().invoke("getDeclaredField").arg("_" + parameter.getName() + "Type").invoke("getGenericType")).arg(
                                    ExpressionFactory._null()).arg(
                                    ExpressionFactory.ref(parameter.getName()))
                    );
                    GeneratedVariable second = attempt.body().decl(ref(String.class), "second",
                            ExpressionFactory.cast(ref(String.class), ExpressionFactory.invoke("evaluateAndTransform").arg(
                                    ExpressionFactory.invoke("getMuleContext")).arg(
                                    event).arg(
                                    messageProcessorClass.dotclass().invoke("getDeclaredField").arg("state").invoke("getGenericType")).arg(
                                    ExpressionFactory._null()).arg(
                                    first))
                    );

                    attempt.body().add(extraParameters.invoke("put").arg(parameter.getName()).arg(second.invoke("toLowerCase")));

                    noSuchFieldExceptionCatch = attempt._catch(ref(NoSuchFieldException.class));

                    noSuchFieldExceptionCatch.body()._throw(
                            ExpressionFactory._new(ref(MessagingException.class))
                                    .arg(ref(CoreMessages.class).staticInvoke("createStaticMessage").arg("internal error"))
                                    .arg(event)
                                    .arg(noSuchFieldExceptionCatch.param("e")));
                }
            }
        }

        GeneratedVariable transformedAuthorizationUrl = tryToAuthorize.body().decl(ref(String.class),"transformedAuthorizationUrl", ExpressionFactory.cast(ref(String.class), ExpressionFactory.invoke("evaluateAndTransform")
                .arg(ExpressionFactory.invoke("getMuleContext"))
                .arg(event)
                .arg(messageProcessorClass.dotclass().invoke("getDeclaredField").arg("authorizationUrl").invoke("getGenericType")).arg(ExpressionFactory._null()).arg(authorizationUrlField)));

        GeneratedVariable transformedAccessTokenUrl = tryToAuthorize.body().decl(ref(String.class),"transformedAccessTokenUrl", ExpressionFactory.cast(ref(String.class), ExpressionFactory.invoke("evaluateAndTransform")
                .arg(ExpressionFactory.invoke("getMuleContext"))
                .arg(event)
                .arg(messageProcessorClass.dotclass().invoke("getDeclaredField").arg("accessTokenUrl").invoke("getGenericType")).arg(ExpressionFactory._null()).arg(accessTokenUrlField)));

        tryToAuthorize.body().add(moduleObject.invoke("setAccessTokenUrl").arg(transformedAccessTokenUrl));



        GeneratedVariable location = null;
        if( module.getOAuthVersion() == OAuthVersion.V10A ) {
            location = tryToAuthorize.body().decl(ref(String.class), "location",
                    ExpressionFactory.invoke(moduleObject, OAuth1ClientAdapterGenerator.AUTHORIZE_METHOD_NAME).arg(extraParameters).arg(requestTokenUrlField).arg(accessTokenUrlField).arg(authorizationUrlField).arg(oauthCallback.invoke("getUrl"))
            );
        } else {
            location = tryToAuthorize.body().decl(ref(String.class), "location",
                    ExpressionFactory.invoke(moduleObject, OAuth1ClientAdapterGenerator.AUTHORIZE_METHOD_NAME).arg(extraParameters).arg(transformedAuthorizationUrl).arg(oauthCallback.invoke("getUrl"))
            );
        }
        tryToAuthorize.body().invoke(event.invoke("getMessage"), "setOutboundProperty").arg(HTTP_STATUS_PROPERTY).arg(REDIRECT_HTTP_STATUS);
        tryToAuthorize.body().invoke(event.invoke("getMessage"), "setOutboundProperty").arg(LOCATION_PROPERTY).arg(location);
        tryToAuthorize.body()._return(event);

        GeneratedCatchBlock catchException = tryToAuthorize._catch(ref(Exception.class));
        GeneratedVariable exception = catchException.param("e");
        TypeReference coreMessages = ref(CoreMessages.class);
        GeneratedInvocation failedToInvoke = coreMessages.staticInvoke("failedToInvoke");
        failedToInvoke.arg(ExpressionFactory.lit("authorize"));
        GeneratedInvocation messageException = ExpressionFactory._new(ref(MessagingException.class));
        messageException.arg(failedToInvoke);
        messageException.arg(event);
        messageException.arg(exception);
        catchException.body()._throw(messageException);
    }

    private void generateInitMethod(GeneratedClass messageProcessorClass) {
        GeneratedMethod initialise = messageProcessorClass.method(Modifier.PUBLIC, ctx().getCodeModel().VOID, "initialise");
        initialise._throws(InitialisationException.class);
    }

    private GeneratedField generateStateField(GeneratedClass messageProcessorClass) {
        GeneratedField state = messageProcessorClass.field(Modifier.PRIVATE, ref(String.class), "state");
        messageProcessorClass.setter(state);
        return state;
    }

    private void generateExtraParameterFields(OAuthModule module, GeneratedClass messageProcessorClass) {
        if (module.getAuthorizationParameters() != null) {
            for (OAuthAuthorizationParameter parameter : module.getAuthorizationParameters()) {
                if (SchemaTypeConversion.isSupported(parameter.getType().asTypeMirror().toString()) || parameter.getType().isEnum()) {
                    GeneratedField field = messageProcessorClass.field(Modifier.PRIVATE, ref(Object.class), parameter.getName());
                    messageProcessorClass.setter(field);
                    GeneratedField fieldType = messageProcessorClass.field(Modifier.PRIVATE, ref(parameter.getType().asTypeMirror()), "_" + parameter.getName() + "Type");
                }
            }
        }
    }

    private GeneratedClass getAuthorizeMessageProcessorClass(Module module) {
        GeneratedPackage pkg = ctx().getCodeModel()._package(module.getPackage().getName() + OAuthClientNamingConstants.MESSAGE_PROCESSOR_NAMESPACE);
        GeneratedClass abstractMessageProcessor = ctx().getProduct(Product.ABSTRACT_MESSAGE_PROCESSOR);
        GeneratedClass moduleObject = null;

        if (((OAuthModule) module).getUserIdentifierMethod() != null) {
            moduleObject = ctx().<GeneratedClass>getProduct(Product.OAUTH_MANAGER, module);
        } else {
            moduleObject = ctx().<GeneratedClass>getProduct(Product.OAUTH_ADAPTER, module).topLevelClass();
        }

        GeneratedClass clazz = pkg._class(OAuthClientNamingConstants.AUTHORIZE_MESSAGE_PROCESSOR_CLASS_NAME, abstractMessageProcessor.narrow(moduleObject), new Class[]{
                Initialisable.class,
                Startable.class,
                Stoppable.class,
                InterceptingMessageProcessor.class,
                MuleContextAware.class,
                FlowConstructAware.class});

        ctx().registerProduct(Product.MESSAGE_PROCESSOR, module, "authorize", clazz);

        return clazz;
    }


    protected GeneratedField oauthCallbackField(GeneratedClass messageProcessorClass) {
        return new FieldBuilder(messageProcessorClass).type(ref(HttpCallback.class)).name(CALLBACK_FIELD_NAME).build();
    }

    protected void generateStopMethod(GeneratedClass messageProcessorClass) {
        GeneratedMethod start = messageProcessorClass.method(Modifier.PUBLIC, ctx().getCodeModel().VOID, Stoppable.PHASE_NAME);
        start._throws(MuleException.class);

        start.body()._if(messageProcessorClass.fields().get(CALLBACK_FIELD_NAME).isNotNull())._then().invoke(messageProcessorClass.fields().get(CALLBACK_FIELD_NAME), Stoppable.PHASE_NAME);
    }

    protected void generateStartMethod(Module module, GeneratedClass messageProcessorClass, GeneratedField callback, GeneratedField listener, GeneratedField oauthAuthorizationPattern, GeneratedField requestTokenUrl, GeneratedField accessTokenUrl, GeneratedField authorizationUrl) {
        GeneratedMethod start = messageProcessorClass.method(Modifier.PUBLIC, ctx().getCodeModel().VOID, Startable.PHASE_NAME);
        start._throws(MuleException.class);

        GeneratedVariable moduleObject = start.body().decl(getModuleObject(module), "moduleObject", ExpressionFactory._null());

        GeneratedTry attempt = start.body()._try();

        GeneratedInvocation findOrCreate = ExpressionFactory.invoke("findOrCreate").arg(getModuleObject(module).dotclass());
        if (module.needsConfig()) {
            findOrCreate.arg(ExpressionFactory.FALSE);
        } else {
            findOrCreate.arg(ExpressionFactory.TRUE);
        }
        findOrCreate.arg(ExpressionFactory._null());
        attempt.body().assign(moduleObject, findOrCreate);

        GeneratedCatchBlock catchIllegalAccess = attempt._catch(ref(IllegalAccessException.class));
        catchIllegalAccess.body()._throw(ExpressionFactory._new(ref(DefaultMuleException.class)).arg(ref(CoreMessages.class).staticInvoke("failedToStart").arg("authorize")).arg(catchIllegalAccess.param("e")));

        GeneratedCatchBlock catchInstantiationException = attempt._catch(ref(InstantiationException.class));
        catchInstantiationException.body()._throw(ExpressionFactory._new(ref(DefaultMuleException.class)).arg(ref(CoreMessages.class).staticInvoke("failedToStart").arg("authorize")).arg(catchInstantiationException.param("e")));

        GeneratedClass extractAuthorizationCodeMessageProcessorClass = ctx().<GeneratedClass>getProduct(Product.OAUTH_EXTRACT_AUTHORIZATION_CODE_MESSAGE_PROCESSOR);
        GeneratedInvocation newExtractAuthorizationCodeMessageProcessor = ExpressionFactory._new(extractAuthorizationCodeMessageProcessorClass);
        newExtractAuthorizationCodeMessageProcessor.arg(oauthAuthorizationPattern);

        GeneratedClass fetchAccessTokenMessageProcessorClass = ctx().<GeneratedClass>getProduct(Product.OAUTH_FETCH_ACCESS_TOKEN_MESSAGE_PROCESSOR);
        GeneratedInvocation newFetchAccessTokenMessageProcessor = ExpressionFactory._new(fetchAccessTokenMessageProcessorClass);
        newFetchAccessTokenMessageProcessor.arg(moduleObject);

        GeneratedConditional ifCallbackIsNull = start.body()._if(callback.isNull());
        GeneratedVariable fetchAccessTokenMessageProcessor = ifCallbackIsNull._then().decl(fetchAccessTokenMessageProcessorClass, "fetchAccessTokenMessageProcessor", newFetchAccessTokenMessageProcessor);
        ifCallbackIsNull._then().assign(callback, ExpressionFactory._new(ctx().<GeneratedClass>getProduct(Product.DEFAULT_HTTP_CALLBACK))
                .arg(ref(Arrays.class).staticInvoke("asList").arg(newExtractAuthorizationCodeMessageProcessor).arg(fetchAccessTokenMessageProcessor).arg(listener))
                .arg(ExpressionFactory.invoke("getMuleContext"))
                .arg(moduleObject.invoke("getDomain"))
                .arg(moduleObject.invoke("getLocalPort"))
                .arg(moduleObject.invoke("getRemotePort"))
                .arg(moduleObject.invoke("getPath"))
                .arg(moduleObject.invoke("getAsync"))
                .arg(ExpressionFactory.invoke("getFlowConstruct").invoke("getExceptionListener"))
                .arg(moduleObject.invoke("getConnector")));
        ifCallbackIsNull._then().invoke(fetchAccessTokenMessageProcessor, "setRedirectUri").arg(callback.invoke("getUrl"));

        GeneratedConditional ifAccessTokenUrlNotNull = ifCallbackIsNull._then()._if(accessTokenUrl.isNotNull());
        ifAccessTokenUrlNotNull._then().invoke(fetchAccessTokenMessageProcessor, "setAccessTokenUrl").arg(accessTokenUrl);
        ifAccessTokenUrlNotNull._else().invoke(fetchAccessTokenMessageProcessor, "setAccessTokenUrl").arg(moduleObject.invoke("getAccessTokenUrl"));

        if ( ((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A ) {
            GeneratedConditional ifRequestTokenUrlNotNull = ifCallbackIsNull._then()._if(requestTokenUrl.isNotNull());
            ifRequestTokenUrlNotNull._then().invoke(fetchAccessTokenMessageProcessor, "setRequestTokenUrl").arg(requestTokenUrl);
            ifRequestTokenUrlNotNull._else().invoke(fetchAccessTokenMessageProcessor, "setRequestTokenUrl").arg(moduleObject.invoke("getRequestTokenUrl"));

            GeneratedConditional ifAuthorizationUrlNotNull = ifCallbackIsNull._then()._if(authorizationUrl.isNotNull());
            ifAuthorizationUrlNotNull._then().invoke(fetchAccessTokenMessageProcessor, "setAuthorizationUrl").arg(authorizationUrl);
            ifAuthorizationUrlNotNull._else().invoke(fetchAccessTokenMessageProcessor, "setAuthorizationUrl").arg(moduleObject.invoke("getAuthorizationUrl"));
        }

        ifCallbackIsNull._then().invoke(callback, Startable.PHASE_NAME);
    }

    protected GeneratedClass getModuleObject(org.mule.devkit.model.Type type) {
        if (type instanceof OAuthModule && ((OAuthModule) type).getUserIdentifierMethod() != null) {
            return ctx().getProduct(Product.OAUTH_MANAGER, type);
        } else {
            if (ctx().<GeneratedClass>getProduct(Product.PROCESS_ADAPTER, type) != null) {
                return ctx().<GeneratedClass>getProduct(Product.PROCESS_ADAPTER, type).topLevelClass();
            }
        }

        return null;
    }

    protected GeneratedField authorizationCodePatternConstant(GeneratedClass oauthAdapter, String regex) {
        return new FieldBuilder(oauthAdapter).type(Pattern.class).name(AUTH_CODE_PATTERN_FIELD_NAME).staticField().finalField().
                initialValue(ref(Pattern.class).staticInvoke("compile").arg(regex)).build();
    }
}
