/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.oauth.processors;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;

import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.MessageFactory;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.generation.oauth.OAuthClientNamingConstants;
import org.mule.devkit.model.code.*;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;

import java.util.Arrays;
import java.util.List;

public class FetchAccessTokenMessageProcessorGenerator extends AbstractOAuthAdapterGenerator {
    private final static List<Product> CONSUMES = Arrays.asList(new Product[]{Product.CAPABILITIES_ADAPTER,
            Product.LIFECYCLE_ADAPTER,
            Product.OAUTH_ADAPTER,
            Product.OAUTH_MANAGER,
            Product.INJECTION_ADAPTER,
            Product.HTTP_CALLBACK_ADAPTER,
            Product.METADATA_ADAPTER});
    private final static List<Product> PRODUCES = Arrays.asList(new Product[]{Product.OAUTH_FETCH_ACCESS_TOKEN_MESSAGE_PROCESSOR});

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        OAuthModule oauthModule = (OAuthModule) module;
        GeneratedClass messageProcessor = getFetchAccessTokenMessageProcessorClass(module);

        GeneratedField oauthAdapterField = null;
        GeneratedField oauthManagerField = null;

        GeneratedField redirectUri = messageProcessor.field(Modifier.PUBLIC, ref(String.class), "redirectUri");
        messageProcessor.setter(redirectUri);

        GeneratedField accessTokenUrl = generateAccessTokenUrlField(messageProcessor);

        GeneratedField authorizeUrl = null;
        GeneratedField requestTokenUrl = null;
        if( oauthModule.getOAuthVersion() == OAuthVersion.V10A ) {
            authorizeUrl = generateAuthorizationUrlField(messageProcessor);
            requestTokenUrl = generateRequestTokenUrlField(messageProcessor);
        }

        if (oauthModule.getUserIdentifierMethod() == null) {
            GeneratedClass oauthAdapterCall = ctx().<GeneratedClass>getProduct(Product.OAUTH_ADAPTER, module).topLevelClass();
            oauthAdapterField = messageProcessor.field(Modifier.PRIVATE, oauthAdapterCall, "oauthAdapter");

            GeneratedMethod constructor = messageProcessor.constructor(Modifier.PUBLIC);
            GeneratedVariable oauthAdapter = constructor.param(oauthAdapterCall, "oauthAdapter");
            constructor.body().assign(ExpressionFactory._this().ref(oauthAdapterField), oauthAdapter);
        } else {
            oauthManagerField = messageProcessor.field(Modifier.PRIVATE, (TypeReference) ctx().getProduct(Product.OAUTH_MANAGER_INTERFACE), "oauthManager");

            GeneratedMethod constructor = messageProcessor.constructor(Modifier.PUBLIC);
            GeneratedVariable oauthManager = constructor.param((TypeReference) ctx().getProduct(Product.OAUTH_MANAGER_INTERFACE), "oauthManager");
            constructor.body().assign(ExpressionFactory._this().ref(oauthManagerField), oauthManager);
        }

        GeneratedMethod processMethod = messageProcessor.method(Modifier.PUBLIC, ref(MuleEvent.class), "process")._throws(ref(MuleException.class));
        GeneratedVariable event = processMethod.param(ref(MuleEvent.class), "event");

        GeneratedTry tryToExtractVerifier = processMethod.body()._try();

        if (oauthModule.getUserIdentifierMethod() == null) {
            tryToExtractVerifier.body().add(oauthAdapterField.invoke("setOauthVerifier").arg(ExpressionFactory.cast(ref(String.class), event.invoke("getMessage").invoke("getInvocationProperty").arg("_oauthVerifier"))));
            if( oauthModule.getOAuthVersion() == OAuthVersion.V10A ) {
                tryToExtractVerifier.body().add(oauthAdapterField.invoke("fetchAccessToken").arg(requestTokenUrl).arg(accessTokenUrl).arg(authorizeUrl).arg(redirectUri));
            } else {
                tryToExtractVerifier.body().add(oauthAdapterField.invoke("fetchAccessToken").arg(accessTokenUrl).arg(redirectUri));
            }
        } else {
            GeneratedClass connectorClass = ctx().<GeneratedClass>getProduct(Product.OAUTH_ADAPTER, module).topLevelClass();
            GeneratedClass oauthManagerClass = ctx().<GeneratedClass>getProduct(Product.OAUTH_MANAGER, module).topLevelClass();
            GeneratedVariable oauthAdapter = tryToExtractVerifier.body().decl(connectorClass, "oauthAdapter", ExpressionFactory.cast(connectorClass, oauthManagerField.invoke("createAccessToken").arg(ExpressionFactory.cast(ref(String.class), event.invoke("getMessage").invoke("getInvocationProperty").arg("_oauthVerifier")))));
            tryToExtractVerifier.body()._if(oauthAdapter.invoke("getAccessTokenUrl").eq(ExpressionFactory._null()))._then().block().add(oauthAdapter.invoke("setAccessTokenUrl").arg(accessTokenUrl));
            //tryToExtractVerifier.body().add(oauthAdapter.invoke("setAccessTokenUrl").arg(accessTokenUrl));
            if( oauthModule.getOAuthVersion() == OAuthVersion.V10A ) {
                tryToExtractVerifier.body().add(oauthAdapter.invoke("fetchAccessToken").arg(requestTokenUrl).arg(oauthAdapter.invoke("getAccessTokenUrl")).arg(authorizeUrl).arg(redirectUri));
            } else {
                tryToExtractVerifier.body().add(oauthAdapter.invoke("fetchAccessToken").arg(oauthAdapter.invoke("getAccessTokenUrl")).arg(redirectUri));
            }
            //tryToExtractVerifier.body().add(oauthManagerField.invoke("releaseAccessToken").arg(ExpressionFactory.cast(connectorClass, oauthAdapter).invoke(oauthModule.getUserIdentifierMethod().getName())).arg(oauthAdapter));

            tryToExtractVerifier.body().add(ExpressionFactory.cast(oauthManagerClass, oauthManagerField).invoke("getAccessTokenPoolFactory")
                    .invoke("passivateObject")
                    .arg(ExpressionFactory.cast(connectorClass, oauthAdapter).invoke(oauthModule.getUserIdentifierMethod().getName())).arg(oauthAdapter));

            tryToExtractVerifier.body().add(event.invoke("getMessage").invoke("setInvocationProperty").arg("OAuthAccessTokenId").arg(ExpressionFactory.cast(connectorClass, oauthAdapter).invoke(oauthModule.getUserIdentifierMethod().getName())));
        }

        GeneratedCatchBlock catchBlock = tryToExtractVerifier._catch(ref(Exception.class));
        GeneratedVariable exceptionCaught = catchBlock.param("e");
        catchBlock.body()._throw(ExpressionFactory._new(
                ref(MessagingException.class)).
                arg(ref(MessageFactory.class).staticInvoke("createStaticMessage").arg("Unable to fetch access token")).arg(event).arg(exceptionCaught));

        processMethod.body()._return(event);
    }

    private GeneratedClass getFetchAccessTokenMessageProcessorClass(Module module) {
        GeneratedPackage pkg = ctx().getCodeModel()._package(module.getPackage().getName() + OAuthClientNamingConstants.OAUTH_NAMESPACE);
        GeneratedClass clazz = pkg._class(OAuthClientNamingConstants.FETCH_ACCESS_TOKEN_MESSAGE_PROCESSOR_CLASS_NAME, new Class[]{
                MessageProcessor.class});

        ctx().registerProduct(Product.OAUTH_FETCH_ACCESS_TOKEN_MESSAGE_PROCESSOR, clazz);

        return clazz;
    }


}
