/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth;

import java.lang.annotation.Annotation;
import javax.lang.model.type.TypeKind;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.oauth.OAuthModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOAuthClientAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    protected abstract void verify(OAuthModule var1) throws AnnotationVerificationException;

    public void verify(Module module) throws AnnotationVerificationException {
        if (module instanceof OAuthModule && ((OAuthModule)module).getUserIdentifierMethod() != null) {
            if (!((OAuthModule)module).getUserIdentifierMethod().getReturnType().toString().equals("java.lang.String")) {
                throw new AnnotationVerificationException((Identifiable)module, "A @OAuthAccessTokenIdentifier must return java.lang.String.");
            }
            if (!((OAuthModule)module).getUserIdentifierMethod().isPublic()) {
                throw new AnnotationVerificationException((Identifiable)module, "A @OAuthAccessTokenIdentifier method must be public.");
            }
            if (((OAuthModule)module).getUserIdentifierMethod().isStatic()) {
                throw new AnnotationVerificationException((Identifiable)module, "A @OAuthAccessTokenIdentifier cannot be static.");
            }
            if (!((OAuthModule)module).getUserIdentifierMethod().getParameters().isEmpty()) {
                throw new AnnotationVerificationException((Identifiable)module, "The @OAuthAccessTokenIdentifier method cannot receive any arguments");
            }
        }
        this.verify((OAuthModule)module);
    }

    protected void verifyPostAuthorizationMethod(OAuthModule module) throws AnnotationVerificationException {
        if (module.getPostAuthorizationMethod() != null && module.getPostAuthorizationMethod().isPrivate()) {
            throw new AnnotationVerificationException((Identifiable)module, "@OAuthPostAuthorization-annotated method must be public or protected");
        }
        if (module.getPostAuthorizationMethod() != null && module.getPostAuthorizationMethod().getParameters().size() > 0) {
            throw new AnnotationVerificationException((Identifiable)module, "@OAuthPostAuthorization-annotated method cannot have any parameter");
        }
        if (module.getPostAuthorizationMethod() != null && module.getPostAuthorizationMethod().isStatic()) {
            throw new AnnotationVerificationException((Identifiable)module, "@OAuthPostAuthorization-annotated method cannot be static");
        }
        if (module.getPostAuthorizationMethod() != null && module.getPostAuthorizationMethod().getReturnType().getKind() != TypeKind.VOID) {
            throw new AnnotationVerificationException((Identifiable)module, "@OAuthPostAuthorization-annotated method must be void");
        }
    }

    protected boolean classHasMethodWithParameterAnnotated(Module module, Class<? extends Annotation> annotation) {
        for (Method method : module.getMethods()) {
            for (Parameter parameter : method.getParameters()) {
                if (parameter.getAnnotation(annotation) == null) continue;
                return true;
            }
        }
        return false;
    }
}

