/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth.config;

import java.util.Arrays;
import java.util.List;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.spring.factories.MessageProcessorChainFactoryBean;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class DefaultRestoreAccessTokenCallbackFactoryGenerator
extends AbstractOAuthAdapterGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.DEFAULT_RESTORE_ACCESS_TOKEN_CALLBACK);
    private static final List<Product> PRODUCES = Arrays.asList(Product.DEFAULT_RESTORE_ACCESS_TOKEN_CALLBACK_FACTORY);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule && ((OAuthModule)module).getUserIdentifierMethod() == null;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass factory = this.getDefaultRestoreAccessTokenCallbackFactoryClass(module);
        GeneratedClass callback = (GeneratedClass)this.ctx().getProduct(Product.DEFAULT_RESTORE_ACCESS_TOKEN_CALLBACK);
        GeneratedMethod getObjectType = factory.method(1, (Type)this.ref(Class.class), "getObjectType");
        getObjectType.body()._return(callback.dotclass());
        GeneratedMethod getObject = factory.method(1, (Type)this.ref(Object.class), "getObject");
        getObject._throws(this.ref(Exception.class));
        GeneratedVariable callbackVariable = getObject.body().decl((Type)callback, "callback", (GeneratedExpression)ExpressionFactory._new((TypeReference)callback));
        getObject.body().add((Statement)callbackVariable.invoke("setMessageProcessor").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(MessageProcessor.class), (GeneratedExpression)ExpressionFactory._super().invoke("getObject"))));
        getObject.body()._return((GeneratedExpression)callbackVariable);
    }

    private GeneratedClass getDefaultRestoreAccessTokenCallbackFactoryClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".config");
        GeneratedClass clazz = pkg._class("RestoreAccessTokenCallbackFactoryBean");
        clazz._extends(this.ref(MessageProcessorChainFactoryBean.class));
        this.ctx().registerProduct(Product.DEFAULT_RESTORE_ACCESS_TOKEN_CALLBACK_FACTORY, (Object)clazz);
        return clazz;
    }
}

