/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.common.security.oauth.AuthorizationParameter;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.common.security.oauth.exception.UnableToAcquireAccessTokenException;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;

public class OAuth2ClientAdapterGenerator
extends AbstractOAuthAdapterGenerator {
    public boolean shouldGenerate(Module module) {
        return false;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass oauthAdapter = this.getOAuthAdapterClass(module, "OAuth2Adapter", this.ref(OAuth2Adapter.class));
        oauthAdapter._implements(OAuth2Adapter.class);
        OAuthModule oAuthModule = (OAuthModule)module;
        GeneratedClass oauthManagerClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)module);
        GeneratedField oauthManager = oauthAdapter.field(4, (Type)this.ref(OAuth2Manager.class).narrow(OAuth2Adapter.class), "oauthManager");
        this.generateConstructor(oauthAdapter, oauthManager, OAuth2Manager.class, OAuth2Adapter.class);
        this.accessTokenPatternConstant(oauthAdapter, oAuthModule);
        this.refreshTokenPatternConstant(oauthAdapter, oAuthModule);
        this.expirationPatternConstant(oauthAdapter, oAuthModule);
        GeneratedField name = oauthAdapter.field(4, (Type)this.ref(String.class), "name");
        oauthAdapter.getter(name);
        oauthAdapter.setterOverride(name);
        this.generateOnNoTokenPolicyField(oauthAdapter);
        this.authorizationCodeField(oauthAdapter);
        this.refreshTokenField(oauthAdapter);
        GeneratedField redirectUri = oauthAdapter.field(1, (Type)this.ref(String.class), "redirectUri");
        GeneratedField authorizationUrl = this.generateAuthorizationUrlField(oauthAdapter);
        GeneratedField accessTokenUrl = this.generateAccessTokenUrlField(oauthAdapter);
        this.expirationField(oauthAdapter, oAuthModule);
        this.generateInitialiseMethod(oauthAdapter);
        GeneratedField logger = FieldBuilder.newLoggerField((GeneratedClass)oauthAdapter);
        this.generateOAuth2AuthorizeMethod(oauthAdapter, oauthManager);
        this.generateFetchAccessTokenMethod(oauthAdapter, oauthManager);
        this.generateRefreshAccessTokenMethod(oauthAdapter, oauthManager);
        this.generateHasTokenExpiredMethod(oauthAdapter, oAuthModule);
        this.generateResetMethod(oAuthModule, oauthAdapter);
        this.generateHasBeenAuthorizedMethod(oAuthModule, oauthAdapter);
        this.generateRegexpGetters(oauthAdapter);
        this.generateOAuth2ConnectorInterfaceImpl(oAuthModule, oauthAdapter);
        this.generateGetProcessTemplateMethod(oauthAdapter, (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module), oauthManager);
    }

    protected void generateHasBeenAuthorizedMethod(OAuthModule module, GeneratedClass oauthAdapter) {
        GeneratedMethod hasBeenAuthorized = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "hasBeenAuthorized");
        hasBeenAuthorized._throws(this.ref(NotAuthorizedException.class));
        GeneratedBlock ifAccessTokenIsNull = hasBeenAuthorized.body()._if(ExpressionFactory.invoke((String)module.getAccessTokenField().getGetter().getName()).isNull())._then();
        GeneratedInvocation newNotAuthorizedException = ExpressionFactory._new((TypeReference)this.ref(NotAuthorizedException.class));
        newNotAuthorizedException.arg("This connector has not yet been authorized, please authorize by calling \"authorize\".");
        ifAccessTokenIsNull._throw((GeneratedExpression)newNotAuthorizedException);
    }

    private void generateOAuth2ConnectorInterfaceImpl(OAuthModule oAuthModule, GeneratedClass oauthAdapter) {
        GeneratedVariable value;
        GeneratedMethod getAuthorizationParameters = oauthAdapter.method(1, (Type)this.ref(Set.class).narrow(this.ref(AuthorizationParameter.class).narrow(this.ctx().getCodeModel().wildcard())), "getAuthorizationParameters");
        getAuthorizationParameters.annotate(Override.class);
        ArrayList<GeneratedVariable> generatedVariableList = new ArrayList<GeneratedVariable>();
        for (OAuthAuthorizationParameter parameter : oAuthModule.getAuthorizationParameters()) {
            GeneratedVariable param = getAuthorizationParameters.body().decl((Type)this.ref(AuthorizationParameter.class).narrow(String.class), parameter.getName(), (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(AuthorizationParameter.class).narrow(String.class)).arg(ExpressionFactory.lit((String)parameter.getName())).arg(ExpressionFactory.lit((String)parameter.getDescription())).arg(ExpressionFactory.lit((boolean)parameter.isOptional())).arg(ExpressionFactory.lit((String)parameter.getDefaultValue())).arg(this.ref(parameter.getType().asTypeMirror()).dotclass()));
            generatedVariableList.add(param);
        }
        GeneratedVariable result = getAuthorizationParameters.body().decl((Type)this.ref(Set.class).narrow(this.ref(AuthorizationParameter.class).narrow(this.ctx().getCodeModel().wildcard())), "result", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(HashSet.class).narrow(this.ref(AuthorizationParameter.class).narrow(this.ctx().getCodeModel().wildcard()))));
        for (GeneratedVariable param : generatedVariableList) {
            getAuthorizationParameters.body().add((Statement)result.invoke("add").arg((GeneratedExpression)param));
        }
        getAuthorizationParameters.body()._return((GeneratedExpression)result);
        if (!oAuthModule.hasMethodWithName("getConsumerKey")) {
            GeneratedMethod getConsumerKeyMethod = oauthAdapter.method(1, (Type)this.ref(String.class), "getConsumerKey");
            getConsumerKeyMethod.annotate(Override.class);
            getConsumerKeyMethod.body()._return((GeneratedExpression)ExpressionFactory._this().invoke(oAuthModule.getConsumerKeyField().getGetter().getName()));
        }
        if (!oAuthModule.hasMethodWithName("setConsumerKey")) {
            GeneratedMethod setConsumerKey = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setConsumerKey");
            value = setConsumerKey.param((Type)this.ref(String.class), "value");
            setConsumerKey.annotate(Override.class);
            setConsumerKey.body().add((Statement)ExpressionFactory._this().invoke(oAuthModule.getConsumerKeyField().getSetter().getName()).arg((GeneratedExpression)value));
        }
        if (!oAuthModule.hasMethodWithName("getConsumerSecret")) {
            GeneratedMethod getConsumerSecret = oauthAdapter.method(1, (Type)this.ref(String.class), "getConsumerSecret");
            getConsumerSecret.annotate(Override.class);
            getConsumerSecret.body()._return((GeneratedExpression)ExpressionFactory._this().invoke(oAuthModule.getConsumerSecretField().getGetter().getName()));
        }
        if (!oAuthModule.hasMethodWithName("setConsumerSecret")) {
            GeneratedMethod setConsumerSecret = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setConsumerSecret");
            value = setConsumerSecret.param((Type)this.ref(String.class), "value");
            setConsumerSecret.annotate(Override.class);
            setConsumerSecret.body().add((Statement)ExpressionFactory._this().invoke(oAuthModule.getConsumerSecretField().getSetter().getName()).arg((GeneratedExpression)value));
        }
        if (!oAuthModule.hasMethodWithName("getAccessToken")) {
            GeneratedMethod getAccessToken = oauthAdapter.method(1, (Type)this.ref(String.class), "getAccessToken");
            getAccessToken.annotate(Override.class);
            getAccessToken.body()._return((GeneratedExpression)ExpressionFactory._this().invoke(oAuthModule.getAccessTokenField().getGetter().getName()));
        }
        if (!oAuthModule.hasMethodWithName("setAccessToken")) {
            GeneratedMethod setAccessToken = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setAccessToken");
            value = setAccessToken.param((Type)this.ref(String.class), "value");
            setAccessToken.annotate(Override.class);
            setAccessToken.body().add((Statement)ExpressionFactory._this().invoke(oAuthModule.getAccessTokenField().getSetter().getName()).arg((GeneratedExpression)value));
        }
        if (!oAuthModule.hasMethodWithName("getScope")) {
            GeneratedMethod getScope = oauthAdapter.method(1, (Type)this.ref(String.class), "getScope");
            getScope.annotate(Override.class);
            if (oAuthModule.getScopeField() != null) {
                getScope.body()._return((GeneratedExpression)ExpressionFactory._this().invoke(oAuthModule.getScopeField().getGetter().getName()));
            } else {
                getScope.body()._return(ExpressionFactory.lit((String)""));
            }
        }
        if (!oAuthModule.hasMethodWithName("setScope") && oAuthModule.getScopeField() != null) {
            GeneratedMethod setScope = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setScope");
            value = setScope.param((Type)this.ref(String.class), "value");
            setScope.body().add((Statement)ExpressionFactory._this().invoke(oAuthModule.getScopeField().getSetter().getName()).arg((GeneratedExpression)value));
        }
        if (!oAuthModule.hasMethodWithName("postAuth")) {
            GeneratedMethod postAuth = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "postAuth");
            postAuth.annotate(Override.class);
            if (oAuthModule.getPostAuthorizationMethod() != null) {
                postAuth._throws(Exception.class);
                postAuth.body().add((Statement)ExpressionFactory._this().invoke(oAuthModule.getPostAuthorizationMethod().getName()));
            }
        }
    }

    private void generateRegexpGetters(GeneratedClass oauthAdapter) {
        oauthAdapter.direct("@Override\n    public String getAccessTokenRegex() {\n        return ACCESS_CODE_PATTERN.pattern();\n    }\n\n    @Override\n    public String getExpirationRegex() {\n        return EXPIRATION_TIME_PATTERN.pattern();\n    }\n\n    @Override\n    public String getRefreshTokenRegex() {\n        return REFRESH_TOKEN_PATTERN.pattern();\n    }\n\n    @Override\n    public String getVerifierRegex() {\n        return oauthVerifier;\n    }");
    }

    protected GeneratedField refreshTokenField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name("refreshToken").getterAndSetter().build();
    }

    private void accessTokenPatternConstant(GeneratedClass oauthAdapter, OAuthModule module) {
        GeneratedField accessTokenPattern = new FieldBuilder(oauthAdapter).type(Pattern.class).name("ACCESS_CODE_PATTERN").staticField().finalField().initialValue((GeneratedExpression)this.ref(Pattern.class).staticInvoke("compile").arg(module.getAccessTokenRegex())).build();
        GeneratedMethod getter = oauthAdapter.getter(accessTokenPattern);
        getter.name("getAccessCodePattern");
        getter.annotate(Override.class);
    }

    private void refreshTokenPatternConstant(GeneratedClass oauthAdapter, OAuthModule module) {
        GeneratedField refreshTokenPattern = new FieldBuilder(oauthAdapter).type(Pattern.class).name("REFRESH_TOKEN_PATTERN").staticField().finalField().initialValue((GeneratedExpression)this.ref(Pattern.class).staticInvoke("compile").arg(module.getRefreshTokenRegex())).build();
        GeneratedMethod getter = oauthAdapter.getter(refreshTokenPattern);
        getter.name("getRefreshTokenPattern");
        getter.annotate(Override.class);
    }

    private void expirationPatternConstant(GeneratedClass oauthAdapter, OAuthModule module) {
        if (!StringUtils.isEmpty((String)module.getExpirationRegex())) {
            GeneratedField expirationPattern = new FieldBuilder(oauthAdapter).type(Pattern.class).name("EXPIRATION_TIME_PATTERN").staticField().finalField().initialValue((GeneratedExpression)this.ref(Pattern.class).staticInvoke("compile").arg(module.getExpirationRegex())).build();
            GeneratedMethod getter = oauthAdapter.getter(expirationPattern);
            getter.name("getExpirationTimePattern");
            getter.annotate(Override.class);
        }
    }

    private void expirationField(GeneratedClass oauthAdapter, OAuthModule module) {
        if (!StringUtils.isEmpty((String)module.getExpirationRegex())) {
            new FieldBuilder(oauthAdapter).type(Date.class).name("expiration").setter().build();
        }
    }

    private void generateRefreshAccessTokenMethod(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod refreshAccessTokenMethod = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "refreshAccessToken");
        GeneratedVariable accessTokenId = refreshAccessTokenMethod.param(String.class, "accessTokenId");
        refreshAccessTokenMethod._throws(this.ref(UnableToAcquireAccessTokenException.class));
        refreshAccessTokenMethod.annotate(Override.class);
        refreshAccessTokenMethod.body().add((Statement)oauthManager.invoke("refreshAccessToken").arg(ExpressionFactory._this()).arg((GeneratedExpression)accessTokenId));
    }

    private void generateFetchAccessTokenMethod(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod fetchAccessToken = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "fetchAccessToken");
        GeneratedVariable redirectUri = fetchAccessToken.param((Type)this.ref(String.class), "redirectUri");
        fetchAccessToken._throws(this.ref(UnableToAcquireAccessTokenException.class));
        fetchAccessToken.body().add((Statement)oauthManager.invoke("fetchAccessToken").arg(ExpressionFactory._this()).arg((GeneratedExpression)redirectUri));
    }

    private void generateHasTokenExpiredMethod(GeneratedClass oauthAdapter, OAuthModule module) {
        GeneratedMethod hasTokenExpired = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "hasTokenExpired");
        if (!StringUtils.isEmpty((String)module.getExpirationRegex())) {
            GeneratedField expirationDate = (GeneratedField)oauthAdapter.fields().get("expiration");
            hasTokenExpired.body()._return(Op.cand((GeneratedExpression)expirationDate.isNotNull(), (GeneratedExpression)expirationDate.invoke("before").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Date.class)))));
        } else {
            hasTokenExpired.body()._return(ExpressionFactory.FALSE);
        }
    }

    private void generateResetMethod(OAuthModule module, GeneratedClass oauthAdapter) {
        GeneratedMethod reset = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "reset");
        if (!StringUtils.isEmpty((String)module.getExpirationRegex())) {
            reset.body().assign((AssignmentTarget)oauthAdapter.fields().get("expiration"), ExpressionFactory._null());
        }
        reset.body().assign((AssignmentTarget)oauthAdapter.fields().get("oauthVerifier"), ExpressionFactory._null());
        reset.body().invoke(module.getAccessTokenField().getSetter().getName()).arg(ExpressionFactory._null());
    }

    protected void generateGetProcessTemplateMethod(GeneratedClass oauthAdapterClass, GeneratedClass capabilitiesAdapterClass, GeneratedField oauthManager) {
        GeneratedMethod getProcessTemplate = oauthAdapterClass.method(1, (Type)this.ref(ProcessTemplate.class), "getProcessTemplate");
        getProcessTemplate.annotate(this.ref(Override.class));
        TypeVariable p = getProcessTemplate.generify("P");
        getProcessTemplate.type((Type)this.ref(ProcessTemplate.class).narrow((TypeReference)p).narrow((TypeReference)capabilitiesAdapterClass));
        getProcessTemplate.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)));
    }
}

