/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth;

import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.api.annotations.oauth.OAuthAccessTokenSecret;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.generation.oauth.AbstractOAuthClientAnnotationVerifier;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthCallbackParameterField;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.schema.SchemaTypeConversion;

public class OAuth2ClientAnnotationVerifier
extends AbstractOAuthClientAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return super.shouldVerify(module) && module instanceof OAuthModule && ((OAuthModule)module).getOAuthVersion() == OAuthVersion.V2;
    }

    public void verify(OAuthModule module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        if (module.getKind() == ModuleKind.GENERIC) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_172, new Object[0]);
        }
        if (module.getConsumerKeyField() == null) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_173, new Object[0]);
        } else {
            if (!module.getConsumerKeyField().hasGetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_174, new Object[0]);
            }
            if (!module.getConsumerKeyField().hasSetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_175, new Object[0]);
            }
        }
        if (module.getConsumerSecretField() == null) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_176, new Object[0]);
        } else {
            if (!module.getConsumerSecretField().hasGetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_177, new Object[0]);
            }
            if (!module.getConsumerSecretField().hasSetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_178, new Object[0]);
            }
        }
        if (this.classHasMethodWithParameterAnnotated((Module)module, OAuthAccessToken.class)) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_179, new Object[0]);
        }
        if (this.classHasMethodWithParameterAnnotated((Module)module, OAuthAccessTokenSecret.class)) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_180, new Object[0]);
        }
        if (module.getAccessTokenField() == null) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_181, new Object[0]);
        } else {
            if (!module.getAccessTokenField().hasGetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_182, new Object[0]);
            }
            if (!module.getAccessTokenField().hasSetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_183, new Object[0]);
            }
        }
        if (module.getAuthorizationParameters() != null) {
            for (OAuthAuthorizationParameter parameter : module.getAuthorizationParameters()) {
                if (SchemaTypeConversion.isSupported((String)((Object)parameter.getType().asTypeMirror()).toString()) || parameter.getType().isEnum()) continue;
                gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_184, new Object[]{parameter.getType().getName()});
            }
        }
        if (module.getCallbackParameters() != null) {
            for (OAuthCallbackParameterField field : module.getCallbackParameters()) {
                if (field.hasSetter()) continue;
                gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_185, new Object[]{field.getName()});
            }
        }
        this.verifyPostAuthorizationMethod(module);
    }
}

