/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.oauth;

import org.mule.devkit.generation.api.Generator;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.Plugin;
import org.mule.devkit.generation.api.PostProcessor;
import org.mule.devkit.generation.oauth.config.AuthorizeBeanDefinitionParserGenerator;
import org.mule.devkit.generation.oauth.config.DefaultRestoreAccessTokenCallbackFactoryGenerator;
import org.mule.devkit.generation.oauth.config.DefaultSaveAccessTokenCallbackFactoryGenerator;
import org.mule.devkit.generation.oauth.config.UnauthorizeBeanDefinitionParserGenerator;
import org.mule.devkit.generation.oauth.process.DefaultRestoreAccessTokenCallbackGenerator;
import org.mule.devkit.generation.oauth.process.OAuthProcessTemplateGenerator;
import org.mule.devkit.generation.oauth.process.OAuthStateGenerator;
import org.mule.devkit.generation.oauth.process.RefreshTokenProcessInterceptorGenerator;
import org.mule.devkit.generation.oauth.processors.AuthorizeMessageProcessorGenerator;
import org.mule.devkit.generation.oauth.processors.ExtractAuthorizationCodeMessageProcessorGenerator;
import org.mule.devkit.generation.oauth.processors.UnauthorizeMessageProcessorGenerator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OAuthClientPlugin implements Plugin {
    private List<ModuleAnnotationVerifier> annotationVerifiers;
    private List<Generator> moduleGenerators;

    public OAuthClientPlugin() {
        moduleGenerators = new ArrayList<Generator>();

        annotationVerifiers = new ArrayList<ModuleAnnotationVerifier>();
        annotationVerifiers.add(new OAuth1ClientAnnotationVerifier());
        annotationVerifiers.add(new OAuth2ClientAnnotationVerifier());

        moduleGenerators = new ArrayList<Generator>();
        moduleGenerators.add(new AuthorizeBeanDefinitionParserGenerator());
        moduleGenerators.add(new AuthorizeMessageProcessorGenerator());
        moduleGenerators.add(new DefaultRestoreAccessTokenCallbackFactoryGenerator());
        moduleGenerators.add(new DefaultRestoreAccessTokenCallbackGenerator());
        moduleGenerators.add(new DefaultSaveAccessTokenCallbackFactoryGenerator());
        moduleGenerators.add(new OAuth1ClientAdapterGenerator());
        moduleGenerators.add(new OAuth2ClientAdapterGenerator());
        moduleGenerators.add(new OAuthProcessTemplateGenerator());
        moduleGenerators.add(new UnauthorizeMessageProcessorGenerator());
        moduleGenerators.add(new UnauthorizeBeanDefinitionParserGenerator());
        moduleGenerators.add(new OAuthManagerGenerator());
        moduleGenerators.add(new ExtractAuthorizationCodeMessageProcessorGenerator());
        moduleGenerators.add(new OAuthStateGenerator());
        moduleGenerators.add(new RefreshTokenProcessInterceptorGenerator());
        moduleGenerators.add(new NotAuthorizedExceptionGenerator());
    }

    @Override
    public String getOptionName() {
        return null;
    }

    @Override
    public List<ModuleAnnotationVerifier> getVerifiers() {
        return annotationVerifiers;
    }

    @Override
    public List<Generator> getGenerators() {
        return moduleGenerators;
    }

    @Override
    public List<PostProcessor> getPostProcessors() {
        return Collections.emptyList();
    }
}
