package org.mule.devkit.generation.oauth.process;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.generation.oauth.OAuthClientNamingConstants;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Modifier;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.security.oauth.callback.ProcessCallback;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;

import java.util.Arrays;
import java.util.List;

public class RefreshTokenProcessInterceptorGenerator extends AbstractOAuthAdapterGenerator implements ModuleGenerator {
    private final static List<Product> CONSUMES = Arrays.asList(Product.CONNECTION_KEY,
            Product.OAUTH_ADAPTER,
            Product.ABSTRACT_EXPRESSION_EVALUATOR,
            Product.OAUTH_INTERFACES,
            Product.PROCESS_INTERFACES);
    private final static List<Product> PRODUCES = Arrays.asList(Product.REFRESH_TOKEN_PROCESS_INTERCEPTOR);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public boolean shouldGenerate(Module module) {
        return false;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        OAuthModule oauthModule = (OAuthModule) module;
        GeneratedClass oauthAdapterClass = ctx().getProduct(Product.OAUTH_ADAPTER, module);

        GeneratedClass refreshTokenProcessInterceptorClass = getRefreshTokenProcessInterceptorClass(oauthModule);
        TypeVariable t = refreshTokenProcessInterceptorClass.generify("T");
        refreshTokenProcessInterceptorClass._implements((ref(ProcessInterceptor.class)).narrow(t).narrow(oauthAdapterClass));

        GeneratedField logger = generateLoggerField(refreshTokenProcessInterceptorClass);
        GeneratedField next = refreshTokenProcessInterceptorClass.field(Modifier.FINAL | Modifier.PRIVATE, (ref(ProcessInterceptor.class)).narrow(t).narrow(oauthAdapterClass), "next");

        generateConstructor(refreshTokenProcessInterceptorClass, oauthModule, next);

        generateExecuteMethod(oauthModule, oauthAdapterClass, refreshTokenProcessInterceptorClass, t, logger, next);
        generateExecuteMethodForMessage(oauthModule, oauthAdapterClass, refreshTokenProcessInterceptorClass, t, logger, next);
    }

    private GeneratedClass getRefreshTokenProcessInterceptorClass(OAuthModule type) {

        GeneratedPackage pkg = ctx().getCodeModel()._package(type.getPackage().getName() + OAuthClientNamingConstants.OAUTH_NAMESPACE);
        GeneratedClass clazz = pkg._class(Modifier.PUBLIC, OAuthClientNamingConstants.REFRESH_TOKEN_PROCESS_INTERCEPTOR_CLASS_NAME);
        clazz._extends(ref(ExpressionEvaluatorSupport.class));

        ctx().registerProduct(Product.REFRESH_TOKEN_PROCESS_INTERCEPTOR, clazz);

        return clazz;
    }

    private void generateConstructor(GeneratedClass refreshTokenProcessInterceptorClass, OAuthModule module, GeneratedField nextField) {
        GeneratedClass oauthAdapterClass = ctx().getProduct(Product.OAUTH_ADAPTER, module);

        GeneratedMethod constructor = refreshTokenProcessInterceptorClass.constructor(Modifier.PUBLIC);
        GeneratedVariable next = constructor.param((ref(ProcessInterceptor.class)).narrow(refreshTokenProcessInterceptorClass.typeParams()[0]).narrow(oauthAdapterClass), "next");

        constructor.body().assign(ExpressionFactory._this().ref(nextField), next);
    }

    private void generateExecuteMethodForMessage(OAuthModule oauthModule, GeneratedClass oauthAdapterClass, GeneratedClass refreshTokenProcessInterceptorClass, TypeVariable t, GeneratedField logger, GeneratedField next) {
        GeneratedMethod execute = refreshTokenProcessInterceptorClass.method(Modifier.PUBLIC, t, "execute");
        execute._throws(ref(Exception.class));
        GeneratedVariable processCallback = execute.param((ref(ProcessCallback.class)).narrow(t).narrow(oauthAdapterClass), "processCallback");
        GeneratedVariable object = execute.param(oauthAdapterClass, "object");
        GeneratedVariable filter = execute.param(ref(Filter.class), "filter");
        GeneratedVariable message = execute.param(ref(MuleMessage.class), "event");

        execute.body()._throw(ExpressionFactory._new(ref(UnsupportedOperationException.class)));
    }

    private void generateExecuteMethod(OAuthModule oauthModule, GeneratedClass oauthAdapterClass, GeneratedClass refreshTokenProcessInterceptorClass, TypeVariable t, GeneratedField logger, GeneratedField next) {
        GeneratedMethod execute = refreshTokenProcessInterceptorClass.method(Modifier.PUBLIC, t, "execute");
        execute._throws(ref(Exception.class));
        GeneratedVariable processCallback = execute.param((ref(ProcessCallback.class)).narrow(t).narrow(oauthAdapterClass), "processCallback");
        GeneratedVariable object = execute.param(oauthAdapterClass, "object");
        GeneratedVariable messageProcessor = execute.param(ref(MessageProcessor.class), "messageProcessor");
        GeneratedVariable event = execute.param(ref(MuleEvent.class), "event");

        GeneratedVariable result = execute.body().decl(t, "result", ExpressionFactory._null());
        GeneratedVariable cause = execute.body().decl(ref(Exception.class), "cause", ExpressionFactory._null());

        GeneratedTry attempt = execute.body()._try();
        attempt.body().assign(result, ExpressionFactory._this().ref(next).invoke("execute").arg(processCallback).arg(object).arg(messageProcessor).arg(event));
        attempt.body()._return(result);

        GeneratedCatchBlock catchException = attempt._catch(ref(Exception.class));
        GeneratedVariable e = catchException.param("e");

        GeneratedConditional ifManagedExceptions = catchException.body()._if(processCallback.invoke("getManagedExceptions").isNotNull());
        //ifManagedExceptions._else()._throw(e);
        GeneratedForEach forEachException = ifManagedExceptions._then().forEach(ref(Class.class), "exceptionClass", ExpressionFactory.cast(ref(List.class).narrow(ref(Class.class)), processCallback.invoke("getManagedExceptions")));
        GeneratedConditional ifIsManaged = forEachException.body()._if(forEachException.var().invoke("isInstance").arg(e));
        GeneratedConditional ifRefreshToken = ifIsManaged._then()._if(ExpressionFactory.cast((TypeReference) ctx().getProduct(Product.OAUTH2_ADAPTER_INTERFACE), object).invoke("getRefreshToken").isNotNull());

        ifRefreshToken._then()._if(logger.invoke("isDebugEnabled"))._then().invoke(logger, "debug").arg("A managed exception has been thrown. Attempting to refresh access token.");
        GeneratedTry refreshAccessTokenAttempt = ifRefreshToken._then()._try();
        refreshAccessTokenAttempt.body().invoke(ExpressionFactory.cast((TypeReference) ctx().getProduct(Product.OAUTH2_ADAPTER_INTERFACE), object), "refreshAccessToken")
            .arg(ExpressionFactory.cast(oauthAdapterClass, object).invoke("getAccessTokenUrl"));

        GeneratedCatchBlock catchExceptionOnRefreshToken = refreshAccessTokenAttempt._catch(ref(Exception.class));
        GeneratedVariable newException = catchExceptionOnRefreshToken.param("newException");
        catchExceptionOnRefreshToken.body()._if(logger.invoke("isDebugEnabled"))._then().invoke(logger, "debug").arg("Another exception was thrown while attempting to refresh the access token. Throwing original exception back up").arg(newException);
        catchExceptionOnRefreshToken.body()._throw(e);

        ifRefreshToken._then().assign(result, ExpressionFactory._this().ref(next).invoke("execute").arg(processCallback).arg(object).arg(messageProcessor).arg(event));
        ifRefreshToken._then()._return(result);

        catchException.body()._throw(e);

        //execute.body()._return(ExpressionFactory._null());
    }
}
