/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.oauth;

import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.annotations.Dependency;
import org.mule.devkit.generation.api.annotations.RequiresMavenDependencies;
import org.mule.devkit.generation.api.gatherer.*;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.schema.SchemaTypeConversion;

@RequiresMavenDependencies({
        @Dependency(groupId = "oauth.signpost", artifactId = "signpost-core", version = "[1.2.1.2]")
})
public class OAuth1ClientAnnotationVerifier extends AbstractOAuthClientAnnotationVerifier {

    @Override
    public boolean shouldVerify(Module module) {
        return super.shouldVerify(module) &&
                module instanceof OAuthModule && ((OAuthModule) module).getOAuthVersion() == OAuthVersion.V10A;
    }

    @Override
    public void verify(OAuthModule module,NotificationGatherer gatherer) throws AnnotationVerificationException {
        if (module.getKind() == ModuleKind.GENERIC) {
            gatherer.error(module, Message.DEVKIT_156);
        }
        if (module.getConsumerKeyField() == null) {
            gatherer.error(module, Message.DEVKIT_157);
        }else{
            if (!module.getConsumerKeyField().hasGetter()) {
                gatherer.error(module, Message.DEVKIT_158);
            }
            if (!module.getConsumerKeyField().hasSetter()) {
                gatherer.error(module, Message.DEVKIT_159);
            }
        }
        if (module.getConsumerSecretField() == null) {
            gatherer.error(module, Message.DEVKIT_160);
        }else{
            if (!module.getConsumerSecretField().hasGetter()) {
                gatherer.error(module, Message.DEVKIT_161);
            }
            if (!module.getConsumerSecretField().hasSetter()) {
                gatherer.error(module, Message.DEVKIT_162);
            }
        }
        if (classHasMethodWithParameterAnnotated(module, OAuthAccessToken.class)) {
            gatherer.error(module, Message.DEVKIT_163);
        }
        if (module.getAccessTokenField() == null) {
            gatherer.error(module, Message.DEVKIT_164);
        }else{
            if (!module.getAccessTokenField().hasGetter()) {
                gatherer.error(module, Message.DEVKIT_165);
            }
            if (!module.getAccessTokenField().hasSetter()) {
                gatherer.error(module, Message.DEVKIT_166);
            }
        }
        if (module.getAccessTokenSecretField() == null) {
            gatherer.error(module, Message.DEVKIT_167);
        }else{
            if (!module.getAccessTokenSecretField().hasGetter()) {
                gatherer.error(module, Message.DEVKIT_168);
            }
            if (!module.getAccessTokenSecretField().hasSetter()) {
                gatherer.error(module, Message.DEVKIT_169);
            }
        }
        // check types on the authorization parameters
        if (module.getAuthorizationParameters() != null) {
            for (OAuthAuthorizationParameter parameter : module.getAuthorizationParameters()) {
                if (!SchemaTypeConversion.isSupported(parameter.getType().asTypeMirror().toString()) &&
                        !parameter.getType().isEnum()) {
                    gatherer.error(module, Message.DEVKIT_170, parameter.getType().getName());
                }
            }
        }

        if(module.getUserIdentifierMethod() != null) {
            gatherer.error(module, Message.DEVKIT_171);
        }

        verifyPostAuthorizationMethod(module);
    }
}
