/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.oauth.process;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.generation.oauth.OAuthClientNamingConstants;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Modifier;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.security.oauth.callback.ProcessCallback;

import java.util.Arrays;
import java.util.List;

@JustOnce
public class OAuthProcessTemplateGenerator extends AbstractOAuthAdapterGenerator {
    private final static List<Product> CONSUMES = Arrays.asList(new Product[]{Product.CAPABILITIES_ADAPTER, Product.OAUTH_INTERFACES, Product.PROCESS_INTERFACES});
    private final static List<Product> PRODUCES = Arrays.asList(new Product[]{Product.OAUTH_PROCESS_TEMPLATE});

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public boolean shouldGenerate(Module module) {
        return false;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        GeneratedClass processTemplateClass = getOAuthProcessTemplateClass(module);

        GeneratedField object = generateObjectField(processTemplateClass, module);

        generateConstructor(processTemplateClass, object, module);

        generateExecuteMethod(module, processTemplateClass, object);
        generateExecuteMethodForMessage(module, processTemplateClass, object);
    }

    private void generateExecuteMethod(Module module, GeneratedClass processTemplate, GeneratedField object) {
        GeneratedClass capabilitiesAdapterClass = ctx().getProduct(Product.CAPABILITIES_ADAPTER, module);

        GeneratedMethod execute = processTemplate.method(Modifier.PUBLIC, processTemplate.typeParams()[0], "execute");
        execute._throws(ref(Exception.class));
        GeneratedVariable processCallback = execute.param((ref(ProcessCallback.class)).narrow(processTemplate.typeParams()[0]).narrow(capabilitiesAdapterClass), "processCallback");
        execute.param(ref(MessageProcessor.class), "messageProcessor");
        execute.param(ref(MuleEvent.class), "event");

        execute.body()._if(processCallback.invoke("isProtected"))._then().add(ExpressionFactory.cast((TypeReference) ctx().getProduct(Product.OAUTH_ADAPTER_INTERFACE), object).invoke("hasBeenAuthorized"));
        execute.body()._return(processCallback.invoke("process").arg(object));
    }

    private void generateExecuteMethodForMessage(Module module, GeneratedClass processTemplate, GeneratedField object) {
        GeneratedClass capabilitiesAdapterClass = ctx().getProduct(Product.CAPABILITIES_ADAPTER, module);

        GeneratedMethod execute = processTemplate.method(Modifier.PUBLIC, processTemplate.typeParams()[0], "execute");
        execute._throws(ref(Exception.class));
        GeneratedVariable processCallback = execute.param((ref(ProcessCallback.class)).narrow(processTemplate.typeParams()[0]).narrow(capabilitiesAdapterClass), "processCallback");
        execute.param(ref(Filter.class), "filter");
        execute.param(ref(MuleMessage.class), "message");

        execute.body()._if(processCallback.invoke("isProtected"))._then().add(ExpressionFactory.cast((TypeReference) ctx().getProduct(Product.OAUTH_ADAPTER_INTERFACE), object).invoke("hasBeenAuthorized"));
        execute.body()._return(processCallback.invoke("process").arg(object));
    }

    private void generateConstructor(GeneratedClass processTemplate, GeneratedField object, Module module) {
        GeneratedClass capabilitiesAdapterClass = ctx().getProduct(Product.CAPABILITIES_ADAPTER, module);
        GeneratedMethod constructor = processTemplate.constructor(Modifier.PUBLIC);
        GeneratedVariable newObject = constructor.param(capabilitiesAdapterClass, "object");
        constructor.body().assign(ExpressionFactory._this().ref(object), newObject);
    }

    private GeneratedField generateObjectField(GeneratedClass processTemplate, Module module) {
        GeneratedClass capabilitiesAdapterClass = ctx().getProduct(Product.CAPABILITIES_ADAPTER, module);
        return processTemplate.field(Modifier.PRIVATE | Modifier.FINAL, capabilitiesAdapterClass, "object");
    }

    private GeneratedClass getOAuthProcessTemplateClass(Module module) {
        GeneratedClass capabilitiesAdapterClass = ctx().getProduct(Product.CAPABILITIES_ADAPTER, module);
        GeneratedPackage pkg = ctx().getCodeModel()._package(module.getPackage().getName() + OAuthClientNamingConstants.OAUTH_NAMESPACE);
        GeneratedClass processTemplateClass = pkg._class(Modifier.PUBLIC, OAuthClientNamingConstants.OAUTH_PROCESS_TEMPLATE_CLASS_NAME);
        TypeVariable payload = processTemplateClass.generify("P");
        processTemplateClass._implements(ref(ProcessTemplate.class).narrow(payload).narrow(capabilitiesAdapterClass));

        ctx().registerProduct(Product.OAUTH_PROCESS_TEMPLATE, processTemplateClass);

        return processTemplateClass;
    }
}
