/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.oauth.processors;

import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.generation.oauth.OAuthClientNamingConstants;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Modifier;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.security.oauth.OAuth1Adapter;
import org.mule.security.oauth.processor.BaseOAuth1UnauthorizeMessageProcessor;
import org.mule.security.oauth.processor.BaseOAuth2UnauthorizeMessageProcessor;

import java.util.Arrays;
import java.util.List;

public class UnauthorizeMessageProcessorGenerator extends AbstractOAuthAdapterGenerator {
    private final static List<Product> CONSUMES = Arrays.asList(new Product[]{Product.OAUTH_ADAPTER, Product.ABSTRACT_CONNECTED_PROCESSOR, Product.OAUTH_MANAGER, Product.CONNECTION_INTERFACES});
    private final static List<Product> PRODUCES = Arrays.asList(new Product[]{Product.MESSAGE_PROCESSOR});

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        // get class
        GeneratedClass messageProcessorClass;

        messageProcessorClass = getUnauthorizeMessageProcessorClass(module);

        GeneratedField logger = generateLoggerField(messageProcessorClass);

        if (((OAuthModule) module).getOAuthVersion().equals(OAuthVersion.V2)) {
            generateGetOAuthManagerClass(module,messageProcessorClass);
        } else {
            generateGetAdapterClass(module,messageProcessorClass);
        }

    }

    private void generateGetAdapterClass(Module module, GeneratedClass messageProcessorClass) {

        GeneratedMethod getAdapterClassMethod = messageProcessorClass.method(Modifier.PROTECTED, ref(Class.class).narrow(ref(OAuth1Adapter.class).wildcard()),"getAdapterClass");
        getAdapterClassMethod.annotate(Override.class);

        if (module.hasRestCalls()) {
            getAdapterClassMethod.body()._return(ExpressionFactory.direct(module.getPackage().getName() + ".adapters." + module.getClassName() + "RestClientAdapter.class"));
        } else {
            GeneratedClass oauthAdapter = ctx().getProduct(Product.OAUTH_ADAPTER,module);
            getAdapterClassMethod.body()._return(oauthAdapter.dotclass());
        }
    }

    private void generateGetOAuthManagerClass(Module module, GeneratedClass messageProcessorClass) {
        GeneratedClass oauthManager = ctx().<GeneratedClass>getProduct(Product.OAUTH_MANAGER, module);
        GeneratedMethod getOAuthManagerClassMethod = messageProcessorClass.method(Modifier.PROTECTED, ref(Class.class).narrow(oauthManager),"getOAuthManagerClass");
        getOAuthManagerClassMethod.annotate(Override.class);
        getOAuthManagerClassMethod.body()._return(oauthManager.dotclass());
    }

    private GeneratedClass getUnauthorizeMessageProcessorClass(Module module) {
        GeneratedPackage pkg = ctx().getCodeModel()._package(module.getPackage().getName() + OAuthClientNamingConstants.MESSAGE_PROCESSOR_NAMESPACE);

        GeneratedClass abstractMessageProcessor = ctx().getProduct(Product.ABSTRACT_MESSAGE_PROCESSOR);

        GeneratedClass moduleObject = null;  GeneratedClass clazz = null;

        if( module instanceof OAuthModule) {
            moduleObject = ctx().<GeneratedClass>getProduct(Product.OAUTH_MANAGER, module).topLevelClass();

            if (((OAuthModule) module).getOAuthVersion().equals(OAuthVersion.V2)) {
                 clazz = pkg._class(OAuthClientNamingConstants.UNAUTHORIZE_MESSAGE_PROCESSOR_CLASS_NAME, ref(BaseOAuth2UnauthorizeMessageProcessor.class), new Class[]{
                        MessageProcessor.class,
                        FlowConstructAware.class});
            } else {
                clazz = pkg._class(OAuthClientNamingConstants.UNAUTHORIZE_MESSAGE_PROCESSOR_CLASS_NAME, ref(BaseOAuth1UnauthorizeMessageProcessor.class), new Class[]{
                        MessageProcessor.class,
                        FlowConstructAware.class});
            }

        } else {
            //This should never be executed
            moduleObject = ctx().<GeneratedClass>getProduct(Product.OAUTH_ADAPTER, module).topLevelClass();
            clazz = pkg._class(OAuthClientNamingConstants.UNAUTHORIZE_MESSAGE_PROCESSOR_CLASS_NAME, abstractMessageProcessor.narrow(moduleObject), new Class[]{
                    MessageProcessor.class,
                    MuleContextAware.class,
                    FlowConstructAware.class});
        }


        ctx().registerProduct(Product.MESSAGE_PROCESSOR, module, "unauthorize", clazz);

        return clazz;
    }

}
