/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.oauth;

import org.mule.api.MuleContext;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuthConsumerKey;
import org.mule.api.annotations.oauth.OAuthConsumerSecret;
import org.mule.api.annotations.oauth.OAuthMessageSigner;
import org.mule.api.annotations.oauth.OAuthScope;
import org.mule.api.annotations.oauth.OAuthSigningStrategy;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.common.security.oauth.exception.UnableToAcquireRequestTokenException;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Modifier;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.security.oauth.OAuth1Connector;
import org.mule.security.oauth.OAuth2Connector;
import org.mule.security.oauth.OnNoTokenPolicy;
import org.mule.security.oauth.callback.RestoreAccessTokenCallback;
import org.mule.security.oauth.callback.SaveAccessTokenCallback;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.lang.model.type.TypeMirror;

import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.basic.DefaultOAuthProvider;
import oauth.signpost.signature.AuthorizationHeaderSigningStrategy;
import oauth.signpost.signature.HmacSha1MessageSigner;
import oauth.signpost.signature.PlainTextMessageSigner;
import oauth.signpost.signature.QueryStringSigningStrategy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOAuthAdapterGenerator implements ModuleGenerator {

    protected static final String REQUEST_TOKEN_FIELD_NAME = "requestToken";
    protected static final String REQUEST_TOKEN_SECRET_FIELD_NAME = "requestTokenSecret";
    protected static final String CONSUMER_FIELD_NAME = "consumer";
    public static final String VERIFIER_FIELD_NAME = "oauthVerifier";
    public static final String HAS_TOKEN_EXPIRED_METHOD_NAME = "hasTokenExpired";
    public static final String RESET_METHOD_NAME = "reset";
    public static final String AUTHORIZE_METHOD_NAME = "authorize";
    public static final String FETCH_ACCESS_TOKEN_METHOD_NAME = "fetchAccessToken";
    public static final String OAUTH_VERIFIER_FIELD_NAME = "oauthVerifier";
    public static final String REFRESH_TOKEN_FIELD_NAME = "refreshToken";
    public static final String REFRESH_TOKEN_PATTERN_FIELD_NAME = "REFRESH_TOKEN_PATTERN";
    public static final String ON_NO_TOKEN_POLICY_FIELD_NAME = "onNoTokenPolicy";
    protected static final String ENCODING = "UTF-8";
    protected static final String GRANT_TYPE = "authorization_code";
    protected static final String ACCESS_CODE_PATTERN_FIELD_NAME = "ACCESS_CODE_PATTERN";
    protected static final String AUTH_CODE_PATTERN_FIELD_NAME = "AUTH_CODE_PATTERN";
    protected static final String EXPIRATION_TIME_PATTERN_FIELD_NAME = "EXPIRATION_TIME_PATTERN";
    protected static final String EXPIRATION_FIELD_NAME = "expiration";
    protected static final String MULE_CONTEXT_FIELD_NAME = "muleContext";
    public static final String OAUTH_SAVE_ACCESS_TOKEN_CALLBACK_FIELD_NAME = "oauthSaveAccessToken";
    public static final String OAUTH_RESTORE_ACCESS_TOKEN_CALLBACK_FIELD_NAME = "oauthRestoreAccessToken";
    private final static List<Product> CONSUMES = Arrays.asList(Product.OAUTH_MANAGER);
    private final static List<Product> PRODUCES = Arrays.asList(Product.OAUTH_ADAPTER);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    protected Context context;

    public Context ctx() {
        return context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }

    protected TypeReference ref(Class<?> clazz) {
        return ctx().getCodeModel().ref(clazz);
    }

    protected org.mule.devkit.model.code.Type ref(TypeMirror typeMirror) {
        return ctx().getCodeModel().ref(typeMirror);
    }

    protected org.mule.devkit.model.code.Type ref(Module module) {
        return ctx().getCodeModel().ref(module.asTypeMirror());
    }

//    protected void generateFetchCallbackParameters(GeneratedClass oauthAdapter, OAuthModule typeElement) {
//        GeneratedMethod fetchCallbackParameters = oauthAdapter.method(Modifier.PRIVATE, context.getCodeModel().VOID, "fetchCallbackParameters");
//        GeneratedVariable response = fetchCallbackParameters.param(ref(String.class), "response");
//        GeneratedField muleContext = oauthAdapter.fields().get("muleContext");
//
//        GeneratedBlock body = fetchCallbackParameters.body();
//        GeneratedVariable expressionManager = body.decl(ref(ExpressionManager.class), "expressionManager",
//                muleContext.invoke("getExpressionManager"));
//
//        GeneratedVariable muleMessage = body.decl(ref(MuleMessage.class), "muleMessage",
//                ExpressionFactory._new(ref(DefaultMuleMessage.class)).arg(response).arg(muleContext));
//
//        for (OAuthCallbackParameterField field : typeElement.getCallbackParameters()) {
//
//            body.invoke("set" + StringUtils.capitalize(field.getName())).arg(
//                    ExpressionFactory.cast(ref(field.asTypeMirror()), expressionManager.invoke("evaluate").arg(field.getExpression()).arg(muleMessage)));
//        }
//
//    }
    protected void generateConstructor(GeneratedClass oauthAdapter, GeneratedField oauthManager, Class OAuthManager, Class OAuthAdapter) {
        GeneratedMethod constructor = oauthAdapter.constructor(Modifier.PUBLIC);
        GeneratedVariable oauthManagerParam = constructor.param(ref(OAuthManager).narrow(ref(OAuthAdapter)),"oauthManager");
        constructor.body().assign(ExpressionFactory._this().ref(oauthManager),oauthManagerParam);
    }

    protected void generateOnNoTokenPolicyField(GeneratedClass oauthAdapter) {
        GeneratedField onNoTokenPolicy = oauthAdapter.field(Modifier.PRIVATE,ref(OnNoTokenPolicy.class), ON_NO_TOKEN_POLICY_FIELD_NAME);
        onNoTokenPolicy.assign(ExpressionFactory.direct("OnNoTokenPolicy.EXCEPTION"));
        oauthAdapter.getter(onNoTokenPolicy);
        oauthAdapter.setter(onNoTokenPolicy);
    }

    protected GeneratedMethod generateCreateConsumerMethod(GeneratedClass oauthAdapter, OAuth oauth, Module module) {
        GeneratedMethod createConsumer = oauthAdapter.method(Modifier.PRIVATE, ctx().getCodeModel().VOID, "createConsumer");
        GeneratedInvocation getConsumerKey = ExpressionFactory.invoke(getterMethodForFieldAnnotatedWith(module, OAuthConsumerKey.class));
        GeneratedInvocation getConsumerSecret = ExpressionFactory.invoke(getterMethodForFieldAnnotatedWith(module, OAuthConsumerSecret.class));
        GeneratedField consumer = oauthAdapter.fields().get(CONSUMER_FIELD_NAME);
        createConsumer.body().assign(consumer, ExpressionFactory._new(ref(DefaultOAuthConsumer.class)).arg(getConsumerKey).arg(getConsumerSecret));
        if (oauth.messageSigner().equals(OAuthMessageSigner.HMAC_SHA1)) {
            createConsumer.body().invoke(consumer, "setMessageSigner").arg(ExpressionFactory._new(ref(HmacSha1MessageSigner.class)));
        } else if (oauth.messageSigner().equals(OAuthMessageSigner.PLAIN_TEXT)) {
            createConsumer.body().invoke(consumer, "setMessageSigner").arg(ExpressionFactory._new(ref(PlainTextMessageSigner.class)));
        }
        if (oauth.signingStrategy().equals(OAuthSigningStrategy.AUTHORIZATION_HEADER)) {
            createConsumer.body().invoke(consumer, "setSigningStrategy").arg(ExpressionFactory._new(ref(AuthorizationHeaderSigningStrategy.class)));
        } else if (oauth.signingStrategy().equals(OAuthSigningStrategy.QUERY_STRING)) {
            createConsumer.body().invoke(consumer, "setSigningStrategy").arg(ExpressionFactory._new(ref(QueryStringSigningStrategy.class)));
        }
        return createConsumer;
    }

    protected GeneratedClass getOAuthAdapterClass(Module module, String classSuffix, TypeReference interf) {
        GeneratedPackage pkg = ctx().getCodeModel()._package(module.getPackage().getName() + OAuthClientNamingConstants.ADAPTERS_NAMESPACE);

        TypeReference previous = null;
        if (module instanceof ManagedConnectionModule ||
                module.usesPooling() ||
                (module instanceof OAuthModule && ((OAuthModule) module).getOAuthVersion().equals(OAuthVersion.V2))) {
            previous = ctx().<GeneratedClass>getProduct(Product.CAPABILITIES_ADAPTER, module).topLevelClass();
        } else {
            previous = ctx().getProduct(Product.PROCESS_ADAPTER, module);
        }

        int modifiers = Modifier.PUBLIC;
        if (module.isAbstract()) {
            modifiers |= Modifier.ABSTRACT;
        }

        GeneratedClass oauthAdapter = pkg._class(modifiers, module.getClassName() + classSuffix, previous);

        if (module instanceof OAuthModule) {
            if (((OAuthModule) module).getOAuthVersion().equals(OAuthVersion.V2)) {
                oauthAdapter._implements(OAuth2Connector.class);
            } else {
                oauthAdapter._implements(OAuth1Connector.class);
            }
        }


        ctx().registerProduct(Product.OAUTH_ADAPTER, module, oauthAdapter);

        oauthAdapter.javadoc().add("A {@code " + oauthAdapter.name() + "} is a wrapper around ");
        oauthAdapter.javadoc().add(ref(module.asTypeMirror()));
        oauthAdapter.javadoc().add(" that adds OAuth capabilites to the pojo.");

        return oauthAdapter;
    }

    protected GeneratedField authorizationCodeField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name(OAUTH_VERIFIER_FIELD_NAME).getterAndSetter().build();
    }

    protected GeneratedField saveAccessTokenCallbackField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(ref(SaveAccessTokenCallback.class)).name(OAUTH_SAVE_ACCESS_TOKEN_CALLBACK_FIELD_NAME).getterAndSetter().build();
    }

    protected GeneratedField restoreAccessTokenCallbackField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(ref(RestoreAccessTokenCallback.class)).name(OAUTH_RESTORE_ACCESS_TOKEN_CALLBACK_FIELD_NAME).getterAndSetter().build();
    }

    protected GeneratedMethod generateInitialiseMethod(GeneratedClass oauthAdapter) {
        GeneratedMethod initialise = oauthAdapter.method(Modifier.PUBLIC, ctx().getCodeModel().VOID, Initialisable.PHASE_NAME);
        initialise._throws(ref(InitialisationException.class));

        initialise.body().invoke(ExpressionFactory._super(), Initialisable.PHASE_NAME);

        return initialise;
    }

    protected void muleContextField(GeneratedClass oauthAdapter) {
        new FieldBuilder(oauthAdapter).name(MULE_CONTEXT_FIELD_NAME).type(MuleContext.class).setter().build();
    }

    protected void generateHasBeenAuthorizedMethod(OAuthModule module, GeneratedClass oauthAdapter) {
        GeneratedMethod hasBeenAuthorized = oauthAdapter.method(Modifier.PUBLIC, ctx().getCodeModel().VOID, "hasBeenAuthorized");
        hasBeenAuthorized._throws(ref(NotAuthorizedException.class));
        GeneratedBlock ifAccessTokenIsNull = hasBeenAuthorized.body()._if(ExpressionFactory.invoke(module.getAccessTokenField().getGetter().getName()).isNull())._then();

        ifAccessTokenIsNull.invoke("restoreAccessToken");
        GeneratedBlock ifAccessTokenIsNull2 = ifAccessTokenIsNull._if(ExpressionFactory.invoke(module.getAccessTokenField().getGetter().getName()).isNull())._then();

        GeneratedInvocation newNotAuthorizedException = ExpressionFactory._new(ref(NotAuthorizedException.class));
        newNotAuthorizedException.arg("This connector has not yet been authorized, please authorize by calling \"authorize\".");

        ifAccessTokenIsNull2._throw(newNotAuthorizedException);
    }

    protected String getterMethodForFieldAnnotatedWith(Module module, Class<? extends Annotation> annotation) {
        return methodForFieldAnnotatedWith(module, annotation, "get");
    }

    private String methodForFieldAnnotatedWith(Module module, Class<? extends Annotation> annotation, String prefix) {
        for (Field field : module.getFields()) {
            if (field.getAnnotation(annotation) != null) {
                return prefix + StringUtils.capitalize(field.getName());
            }
        }
        return null;
    }

    protected GeneratedField generateLoggerField(GeneratedClass clazz) {
        return clazz.field(Modifier.PRIVATE | Modifier.STATIC, ref(Logger.class), "logger",
                ref(LoggerFactory.class).staticInvoke("getLogger").arg(clazz.dotclass()));
    }


    protected GeneratedField generateFieldForMessageProcessor(GeneratedClass messageProcessorClass, String name) {
        GeneratedField expressionManager = messageProcessorClass.field(Modifier.PRIVATE, ref(MessageProcessor.class), name);
        expressionManager.javadoc().add("Message Processor");
        return expressionManager;
    }

    protected GeneratedField generateFieldForBoolean(GeneratedClass messageProcessorClass, String name) {
        GeneratedField expressionManager = messageProcessorClass.field(Modifier.PRIVATE, ctx().getCodeModel().BOOLEAN, name);
        return expressionManager;
    }

    protected GeneratedField generateFieldForString(GeneratedClass messageProcessorClass, String name) {
        GeneratedField expressionManager = messageProcessorClass.field(Modifier.PRIVATE, ref(String.class), name);
        return expressionManager;
    }

    protected void generateOAuth2AuthorizeMethod(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod authorizeMethod = oauthAdapter.method(Modifier.PUBLIC, ctx().getCodeModel().VOID, AbstractOAuthAdapterGenerator.AUTHORIZE_METHOD_NAME);
        GeneratedVariable extraParameters = authorizeMethod.param(ref(Map.class).narrow(ref(String.class)).narrow(ref(String.class)), "extraParameters");
        GeneratedVariable authorizationUrl = authorizeMethod.param(ref(String.class), "authorizationUrl");
        GeneratedVariable redirectUri = authorizeMethod.param(ref(String.class), "redirectUri");
        authorizeMethod.type(ref(String.class));

        authorizeMethod.body()._return(oauthManager.invoke("buildAuthorizeUrl").arg(extraParameters).arg(authorizationUrl).arg(redirectUri));

    }

    protected void generateOAuth1AuthorizeMethod(GeneratedClass oauthAdapter, GeneratedField oauthManager)
    {
        GeneratedMethod authorizeMethod = oauthAdapter.method(Modifier.PUBLIC, ctx().getCodeModel().VOID, AbstractOAuthAdapterGenerator.AUTHORIZE_METHOD_NAME);
        GeneratedVariable extraParameters = authorizeMethod.param(ref(Map.class).narrow(ref(String.class)).narrow(ref(String.class)), "extraParameters");
        GeneratedVariable requestTokenUrl = authorizeMethod.param(ref(String.class), "requestTokenUrl");
        GeneratedVariable accessTokenUrl = authorizeMethod.param(ref(String.class), "accessTokenUrl");
        GeneratedVariable authorizationUrl = authorizeMethod.param(ref(String.class), "authorizationUrl");
        GeneratedVariable redirectUri = authorizeMethod.param(ref(String.class), "redirectUri");
        authorizeMethod._throws(ref(UnableToAcquireRequestTokenException.class));

        authorizeMethod.type(ref(String.class));

        authorizeMethod.body()._return(oauthManager.invoke("buildAuthorizeUrl")
                                               .arg(ExpressionFactory._this())
                                               .arg(extraParameters)
                                               .arg(requestTokenUrl)
                                               .arg(accessTokenUrl)
                                               .arg(authorizationUrl)
                                               .arg(redirectUri));
    }

    protected GeneratedVariable generateProvider(GeneratedVariable requestTokenUrl, GeneratedVariable accessTokenUrl, GeneratedVariable authorizationUrl, GeneratedBlock block, Module module) {
        block.assign(requestTokenUrl, Op.cond(requestTokenUrl.isNotNull(), requestTokenUrl, ExpressionFactory._this().ref("requestTokenUrl")));
        if (module.hasFieldAnnotatedWith(OAuthScope.class)) {
            GeneratedVariable scope = block.decl(ref(String.class), "scope", ExpressionFactory.invoke(getterMethodForFieldAnnotatedWith(module, OAuthScope.class)));
            GeneratedBlock ifScopeNotNull = block._if(scope.isNotNull())._then();
            GeneratedTry tryToEncodeScopeParam = ifScopeNotNull._try();

            GeneratedVariable scopeParam = tryToEncodeScopeParam.body().decl(ref(String.class), "scopeParam", ExpressionFactory.lit("?scope=").invoke("concat").arg(ref(URLEncoder.class).staticInvoke("encode").arg(scope).arg("UTF-8")));
            tryToEncodeScopeParam.body().assign(requestTokenUrl, requestTokenUrl.invoke("concat").arg(scopeParam));

            generateCatchAndReThrow(tryToEncodeScopeParam, UnsupportedEncodingException.class, RuntimeException.class);
        }

        Type oauthProviderClass = ref(DefaultOAuthProvider.class);
        if( ((OAuthModule)module).getOAuthProvider() != null ) {
            oauthProviderClass = ref(((OAuthModule)module).getOAuthProvider());
        }

        GeneratedInvocation newProvider = ExpressionFactory._new(oauthProviderClass)
                .arg(requestTokenUrl)
                .arg(Op.cond(accessTokenUrl.isNotNull(), accessTokenUrl, ExpressionFactory._this().ref("accessTokenUrl")))
                .arg(Op.cond(authorizationUrl.isNotNull(), authorizationUrl, ExpressionFactory._this().ref("authorizationUrl")));

        GeneratedVariable provider = block.decl(ref(OAuthProvider.class), "provider", newProvider);
        block.invoke(provider, "setOAuth10a").arg(ExpressionFactory.TRUE);
        return provider;
    }

    protected void generateCatchAndReThrow(GeneratedTry tryStatement, Class<? extends Exception> exceptionToCatch, Class<? extends Exception> exceptionToThrow) {
        GeneratedCatchBlock catchBlock = tryStatement._catch(ref(exceptionToCatch));
        GeneratedVariable caughtException = catchBlock.param("e");
        catchBlock.body()._throw(ExpressionFactory._new(ref(exceptionToThrow)).arg(caughtException));
    }

    protected void generateCatchAndReThrow(GeneratedTry tryStatement, Class<? extends Exception> exceptionToCatch, TypeReference exceptionToThrow) {
        GeneratedCatchBlock catchBlock = tryStatement._catch(ref(exceptionToCatch));
        GeneratedVariable caughtException = catchBlock.param("e");
        catchBlock.body()._throw(ExpressionFactory._new(exceptionToThrow).arg(caughtException));
    }

    protected GeneratedField generateAuthorizationUrlField(GeneratedClass generatedClass) {
        GeneratedField authorizationUrlField = generatedClass.field(Modifier.PRIVATE, ref(String.class), "authorizationUrl", ExpressionFactory._null());
        generatedClass.setter(authorizationUrlField);
        generatedClass.getter(authorizationUrlField);

        return authorizationUrlField;
    }

    protected GeneratedField generateAccessTokenUrlField(GeneratedClass generatedClass) {
        GeneratedField accessTokenUrlField = generatedClass.field(Modifier.PRIVATE, ref(String.class), "accessTokenUrl", ExpressionFactory._null());
        generatedClass.setter(accessTokenUrlField);
        generatedClass.getter(accessTokenUrlField);

        return accessTokenUrlField;
    }

    protected GeneratedField generateRequestTokenUrlField(GeneratedClass generatedClass) {
        GeneratedField requestTokenUrlField = generatedClass.field(Modifier.PRIVATE, ref(String.class), "requestTokenUrl", ExpressionFactory._null());
        generatedClass.setter(requestTokenUrlField);
        generatedClass.getter(requestTokenUrlField);

        return requestTokenUrlField;
    }
}